/*
 * Decompiled with CFR 0.152.
 */
package processing.transformations;

import java.awt.image.BufferedImage;

public class ModifierCanvas {
    public BufferedImage Agrandir(BufferedImage Source2, int newWidth, int newHeight, int CouleurFond) {
        return this.Agrandir(Source2, (int)((double)(newWidth - Source2.getWidth()) / 2.0), (int)((double)(newWidth - Source2.getWidth()) / 2.0), newWidth, newHeight, CouleurFond);
    }

    public BufferedImage Agrandir(BufferedImage Source2, int MargeX, int MargeY, int newWidth, int newHeight, int CouleurFond) {
        int x;
        int y;
        if (MargeX + Source2.getWidth() >= newWidth) {
            throw new IllegalArgumentException("Marge en X + nouvelle largeur >= Largeur.");
        }
        if (MargeY + Source2.getHeight() >= newHeight) {
            throw new IllegalArgumentException("Marge en Y + nouvelle hauteur >= Hauteur.");
        }
        BufferedImage Resultat = new BufferedImage(newWidth, newHeight, Source2.getType());
        for (y = 0; y < newHeight; ++y) {
            for (x = 0; x < newWidth; ++x) {
                Resultat.setRGB(x, y, CouleurFond);
            }
        }
        for (y = 0; y < Source2.getHeight(); ++y) {
            for (x = 0; x < Source2.getWidth(); ++x) {
                Resultat.setRGB(MargeX + x, MargeY + y, Source2.getRGB(x, y));
            }
        }
        return Resultat;
    }

    public BufferedImage Reduire(BufferedImage Source2, int newWidth, int newHeight) {
        return this.Reduire(Source2, (int)((double)(Source2.getWidth() - newWidth) / 2.0), (int)((double)(Source2.getWidth() - newWidth) / 2.0), newWidth, newHeight);
    }

    public BufferedImage Reduire(BufferedImage Source2, int MargeX, int MargeY, int newWidth, int newHeight) {
        if (MargeX + newWidth >= Source2.getWidth()) {
            throw new IllegalArgumentException("Marge en X + nouvelle largeur >= Largeur.");
        }
        if (MargeY + newHeight >= Source2.getHeight()) {
            throw new IllegalArgumentException("Marge en Y + nouvelle hauteur >= Hauteur.");
        }
        BufferedImage Resultat = new BufferedImage(newWidth, newHeight, Source2.getType());
        Resultat.setData(Source2.getSubimage(MargeX, MargeY, newWidth, newHeight).getRaster());
        return Resultat;
    }
}

