/*
 * Decompiled with CFR 0.152.
 */
package processing.thresholding.adaptive;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import mathematics.fourier.FastFourierTransform;
import processing.filters.ConvolutionFilter;
import processing.thresholding.ImageThresholder;

public class LocalMean
implements ImageThresholder {
    private ConvolutionFilter filter = new ConvolutionFilter();
    private double[][] mask = null;
    private BufferedImage thresholds = null;
    private int ForbidenValue = -1;
    private double percentage = 1.0;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        return this.Filter(source, this.ForbidenValue, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage source, int ForbidenValue, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), 12);
        this.Filter(source, result, ForbidenValue, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        if (this.mask == null) {
            throw new IllegalArgumentException("Convolution mask must be beforehand set.");
        }
        if (Result.getType() != 12) {
            throw new IllegalArgumentException("Result image must be binary.");
        }
        switch (Original.getType()) {
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        int width = Original.getWidth();
        int height = Original.getHeight();
        WritableRaster wrr = Result.getRaster();
        if (this.thresholds == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)Original, (BufferedImage)this.thresholds)) {
            this.thresholds = null;
            this.thresholds = ImageNew.Same((BufferedImage)Original);
        }
        this.filter.Filter(Original, this.thresholds, nbCPU);
        switch (Original.getType()) {
            case 10: {
                byte[] ori = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                byte[] thres = ((DataBufferByte)this.thresholds.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if ((double)(ori[pos] & 0xFF) <= (double)(thres[pos] & 0xFF) * this.percentage) {
                            wrr.setSample(x, y, 0, 0);
                        } else {
                            wrr.setSample(x, y, 0, 1);
                        }
                        ++x;
                        ++pos;
                    }
                }
                thres = null;
                ori = null;
                break;
            }
            case 11: {
                short[] orishort = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                short[] threshort = ((DataBufferUShort)this.thresholds.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if ((double)(orishort[pos] & 0xFFFF) <= (double)(threshort[pos] & 0xFFFF) * this.percentage) {
                            wrr.setSample(x, y, 0, 0);
                        } else {
                            wrr.setSample(x, y, 0, 1);
                        }
                        ++x;
                        ++pos;
                    }
                }
                threshort = null;
                orishort = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        wrr = null;
    }

    @Override
    public void Filter(BufferedImage Original, BufferedImage Result, int ForbidenValue, int nbCPU) {
        this.Filter(Original, Result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage Original, double[][] mask, int percentage, FastFourierTransform fft, int ForbidenValue, int nbCPU) {
        BufferedImage result = new BufferedImage(Original.getWidth(), Original.getHeight(), 12);
        this.Filter(Original, mask, percentage, result, fft, ForbidenValue, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, double[][] mask, int percentage, BufferedImage Result, FastFourierTransform fft, int ForbidenValue, int nbCPU) {
        this.Parameters(new Object[]{mask, percentage, fft});
        this.Filter(Original, Result, nbCPU);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public BufferedImage Tresholds() {
        return this.thresholds;
    }

    @Override
    public int[] getThresholds() {
        return null;
    }

    @Override
    public int getThreshold(int channel) {
        return -1;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 3) {
            throw new IllegalArgumentException("Exactly 3 parameters required.");
        }
        this.mask = (double[][])parameters[0];
        this.percentage = (double)((Integer)parameters[1]).intValue() / 100.0;
        this.filter.Parameters(new Object[]{this.mask, parameters[2]});
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(this.mask);
        params.add(this.percentage);
        params.add(this.thresholds);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public ImageThresholder Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

