/*
 * Decompiled with CFR 0.152.
 */
package processing.thresholding;

import dv.DV;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import measures.histogram.Histogram;
import processing.thresholding.Binary;
import processing.thresholding.ImageThresholder;

public class TriangleThresholding
implements ImageThresholder {
    private Binary binary = new Binary();
    private Histogram histogram = new Histogram();
    private int[] threshold = null;
    private int ForbiddenValue = -1;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        return this.Filter(source, this.ForbiddenValue, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage source, int ForbiddenValue, int nbCPU) {
        BufferedImage result = ImageNew.SameBinary((BufferedImage)source);
        this.Filter(source, result, ForbiddenValue, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        this.Filter(Original, Result, this.ForbiddenValue, nbCPU);
    }

    @Override
    public void Filter(BufferedImage Original, BufferedImage Result, int ForbiddenValue, int nbCPU) {
        int MAX;
        int channel = Original.getRaster().getNumBands();
        switch (Original.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 10: {
                MAX = 255;
                break;
            }
            case 11: {
                MAX = 65535;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        if (this.threshold == null || this.threshold.length != channel) {
            this.threshold = null;
            this.threshold = new int[channel];
        }
        Arrays.fill(this.threshold, -1);
        this.ForbiddenValue = ForbiddenValue;
        this.histogram.Fill(Original, ForbiddenValue);
        for (int c = 0; c < channel; ++c) {
            int i2;
            int[] data = this.histogram.getValues(c);
            int min = 0;
            int dmax = 0;
            int max = 0;
            int min2 = 0;
            for (i2 = 0; i2 < data.length; ++i2) {
                if (data[i2] <= 0) continue;
                min = i2;
                break;
            }
            if (min > 0) {
                --min;
            }
            for (i2 = MAX; i2 > 0; --i2) {
                if (data[i2] <= 0) continue;
                min2 = i2;
                break;
            }
            if (min2 < MAX) {
                ++min2;
            }
            for (i2 = 0; i2 <= MAX; ++i2) {
                if (data[i2] <= dmax) continue;
                max = i2;
                dmax = data[i2];
            }
            boolean inverted = false;
            if (max - min < min2 - max) {
                inverted = true;
                int left = 0;
                for (int right = MAX; left < right; ++left, --right) {
                    int temp = data[left];
                    data[left] = data[right];
                    data[right] = temp;
                }
                min = MAX - min2;
                max = MAX - max;
            }
            if (min == max) {
                this.threshold[c] = min;
                continue;
            }
            double nx = data[max];
            double ny = min - max;
            double d = Math.sqrt(nx * nx + ny * ny);
            nx /= d;
            ny /= d;
            d = nx * (double)min + ny * (double)data[min];
            int split = min;
            double splitDistance = 0.0;
            for (i2 = min + 1; i2 <= max; ++i2) {
                double newDistance = nx * (double)i2 + ny * (double)data[i2] - d;
                if (!(newDistance > splitDistance)) continue;
                split = i2;
                splitDistance = newDistance;
            }
            --split;
            if (inverted) {
                int left = 0;
                for (int right = MAX; left < right; ++left, --right) {
                    int temp = data[left];
                    data[left] = data[right];
                    data[right] = temp;
                }
                this.threshold[c] = MAX - split;
                continue;
            }
            this.threshold[c] = split;
        }
        if (channel == 1) {
            this.binary.setThreshold(this.threshold[0] + 1);
        } else {
            this.binary.setThreshold(this.threshold[0] + 1, this.threshold[1] + 1, this.threshold[2] + 1);
        }
        this.binary.Filter(Original, Result, nbCPU);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    @Override
    public int[] getThresholds() {
        return this.threshold;
    }

    @Override
    public int getThreshold(int channel) {
        return this.threshold[channel];
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public ImageThresholder Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

