/*
 * Decompiled with CFR 0.152.
 */
package processing.thresholding;

import dv.DV;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import measures.histogram.Histogram;
import processing.thresholding.Binary;
import processing.thresholding.ImageThresholder;

public class Renyi
implements ImageThresholder {
    private Binary binary = new Binary();
    private Histogram histogram = new Histogram();
    private int[] threshold = null;
    private int ForbiddenValue = -1;
    private double[] norm_histo = null;
    private double[] P1 = null;
    private double[] P2 = null;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        return this.Filter(source, this.ForbiddenValue, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage source, int ForbiddenValue, int nbCPU) {
        BufferedImage result = ImageNew.SameBinary((BufferedImage)source);
        this.Filter(source, result, ForbiddenValue, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        this.Filter(Original, Result, this.ForbiddenValue, nbCPU);
    }

    @Override
    public void Filter(BufferedImage Original, BufferedImage Result, int ForbiddenValue, int nbCPU) {
        int MAX;
        int channel = Original.getRaster().getNumBands();
        switch (Original.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 10: {
                MAX = 256;
                break;
            }
            case 11: {
                MAX = 65536;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        if (this.threshold == null || this.threshold.length != channel) {
            this.threshold = null;
            this.threshold = new int[channel];
        }
        Arrays.fill(this.threshold, -1);
        if (this.P1 == null || this.P1.length != MAX) {
            this.norm_histo = null;
            this.P2 = null;
            this.P1 = null;
            this.norm_histo = new double[MAX];
            this.P1 = new double[MAX];
            this.P2 = new double[MAX];
        }
        this.ForbiddenValue = ForbiddenValue;
        this.histogram.Fill(Original);
        for (int c = 0; c < channel; ++c) {
            int beta3;
            int beta2;
            int beta1;
            int tmp_var;
            double tot_ent;
            double ent_obj;
            double ent_back;
            int it;
            int ih;
            int[] data = this.histogram.getValues(c);
            int total = 0;
            for (ih = 0; ih < MAX; ++ih) {
                total += data[ih];
            }
            for (ih = 0; ih < MAX; ++ih) {
                this.norm_histo[ih] = (double)data[ih] / (double)total;
            }
            this.P1[0] = this.norm_histo[0];
            this.P2[0] = 1.0 - this.P1[0];
            for (ih = 1; ih < MAX; ++ih) {
                this.P1[ih] = this.P1[ih - 1] + this.norm_histo[ih];
                this.P2[ih] = 1.0 - this.P1[ih];
            }
            int first_bin = 0;
            for (ih = 0; ih < MAX; ++ih) {
                if (Math.abs(this.P1[ih]) < 2.220446049250313E-16) continue;
                first_bin = ih;
                break;
            }
            int last_bin = MAX - 1;
            for (ih = MAX - 1; ih >= first_bin; --ih) {
                if (Math.abs(this.P2[ih]) < 2.220446049250313E-16) continue;
                last_bin = ih;
                break;
            }
            int thresh = 0;
            double max_ent = 0.0;
            for (it = first_bin; it <= last_bin; ++it) {
                ent_back = 0.0;
                for (ih = 0; ih <= it; ++ih) {
                    if (data[ih] == 0) continue;
                    ent_back -= this.norm_histo[ih] / this.P1[it] * Math.log(this.norm_histo[ih] / this.P1[it]);
                }
                ent_obj = 0.0;
                for (ih = it + 1; ih < MAX; ++ih) {
                    if (data[ih] == 0) continue;
                    ent_obj -= this.norm_histo[ih] / this.P2[it] * Math.log(this.norm_histo[ih] / this.P2[it]);
                }
                tot_ent = ent_back + ent_obj;
                if (!(max_ent < tot_ent)) continue;
                max_ent = tot_ent;
                thresh = it;
            }
            int t_star2 = thresh;
            thresh = 0;
            max_ent = 0.0;
            double alpha = 0.5;
            double term = 1.0 / (1.0 - alpha);
            for (it = first_bin; it <= last_bin; ++it) {
                ent_back = 0.0;
                for (ih = 0; ih <= it; ++ih) {
                    ent_back += Math.sqrt(this.norm_histo[ih] / this.P1[it]);
                }
                ent_obj = 0.0;
                for (ih = it + 1; ih < MAX; ++ih) {
                    ent_obj += Math.sqrt(this.norm_histo[ih] / this.P2[it]);
                }
                tot_ent = term * (ent_back * ent_obj > 0.0 ? Math.log(ent_back * ent_obj) : 0.0);
                if (!(tot_ent > max_ent)) continue;
                max_ent = tot_ent;
                thresh = it;
            }
            int t_star1 = thresh;
            thresh = 0;
            max_ent = 0.0;
            alpha = 2.0;
            term = 1.0 / (1.0 - alpha);
            for (it = first_bin; it <= last_bin; ++it) {
                ent_back = 0.0;
                for (ih = 0; ih <= it; ++ih) {
                    ent_back += this.norm_histo[ih] * this.norm_histo[ih] / (this.P1[it] * this.P1[it]);
                }
                ent_obj = 0.0;
                for (ih = it + 1; ih < MAX; ++ih) {
                    ent_obj += this.norm_histo[ih] * this.norm_histo[ih] / (this.P2[it] * this.P2[it]);
                }
                tot_ent = term * (ent_back * ent_obj > 0.0 ? Math.log(ent_back * ent_obj) : 0.0);
                if (!(tot_ent > max_ent)) continue;
                max_ent = tot_ent;
                thresh = it;
            }
            int t_star3 = thresh;
            if (t_star2 < t_star1) {
                tmp_var = t_star1;
                t_star1 = t_star2;
                t_star2 = tmp_var;
            }
            if (t_star3 < t_star2) {
                tmp_var = t_star2;
                t_star2 = t_star3;
                t_star3 = tmp_var;
            }
            if (t_star2 < t_star1) {
                tmp_var = t_star1;
                t_star1 = t_star2;
                t_star2 = tmp_var;
            }
            if (Math.abs(t_star1 - t_star2) <= 5) {
                if (Math.abs(t_star2 - t_star3) <= 5) {
                    beta1 = 1;
                    beta2 = 2;
                    beta3 = 1;
                } else {
                    beta1 = 0;
                    beta2 = 1;
                    beta3 = 3;
                }
            } else if (Math.abs(t_star2 - t_star3) <= 5) {
                beta1 = 3;
                beta2 = 1;
                beta3 = 0;
            } else {
                beta1 = 1;
                beta2 = 2;
                beta3 = 1;
            }
            double omega = this.P1[t_star3] - this.P1[t_star1];
            this.threshold[c] = (int)((double)t_star1 * (this.P1[t_star1] + 0.25 * omega * (double)beta1) + 0.25 * (double)t_star2 * omega * (double)beta2 + (double)t_star3 * (this.P2[t_star3] + 0.25 * omega * (double)beta3));
        }
        if (channel == 1) {
            this.binary.setThreshold(this.threshold[0] + 1);
        } else {
            this.binary.setThreshold(this.threshold[0] + 1, this.threshold[1] + 1, this.threshold[2] + 1);
        }
        this.binary.Filter(Original, Result, nbCPU);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    @Override
    public int[] getThresholds() {
        return this.threshold;
    }

    @Override
    public int getThreshold(int channel) {
        return this.threshold[channel];
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public ImageThresholder Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

