/*
 * Decompiled with CFR 0.152.
 */
package processing.thresholding;

import dv.DV;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import measures.histogram.Histogram;
import processing.thresholding.Binary;
import processing.thresholding.ImageThresholder;

public class PercentileThresholding
implements ImageThresholder {
    private Binary binary = new Binary();
    private Histogram histogram = new Histogram();
    private int[] threshold = null;
    private int ForbiddenValue = -1;
    private int percentile = 50;

    public PercentileThresholding() {
    }

    public PercentileThresholding(int percentile) {
        this.Percentile(percentile);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        return this.Filter(source, this.ForbiddenValue, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage source, int ForbiddenValue, int nbCPU) {
        BufferedImage result = ImageNew.SameBinary((BufferedImage)source);
        this.Filter(source, result, ForbiddenValue, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        this.Filter(Original, Result, this.ForbiddenValue, nbCPU);
    }

    @Override
    public void Filter(BufferedImage Original, BufferedImage Result, int ForbiddenValue, int nbCPU) {
        this.Filter(Original, this.percentile, ForbiddenValue, Result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int percentile, int ForbiddenValue, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), 12);
        this.Filter(source, percentile, ForbiddenValue, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, int percentile, int ForbiddenValue, BufferedImage Result, int nbCPU) {
        int MAX;
        int channel = Original.getRaster().getNumBands();
        switch (Original.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 10: {
                MAX = 256;
                break;
            }
            case 11: {
                MAX = 65536;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        if (this.threshold == null || this.threshold.length != channel) {
            this.threshold = null;
            this.threshold = new int[channel];
        }
        Arrays.fill(this.threshold, -1);
        this.ForbiddenValue = ForbiddenValue;
        this.histogram.Fill(Original, ForbiddenValue);
        for (int c = 0; c < channel; ++c) {
            int[] data = this.histogram.getValues(c);
            this.threshold[c] = -1;
            double ptile = (double)percentile / 100.0;
            double[] avec = new double[MAX];
            Arrays.fill(avec, 0.0);
            double total = this.partialSum(data, MAX - 1);
            double temp = 1.0;
            for (int i2 = 0; i2 < MAX; ++i2) {
                avec[i2] = Math.abs(this.partialSum(data, i2) / total - ptile);
                if (!(avec[i2] < temp)) continue;
                temp = avec[i2];
                this.threshold[c] = i2;
            }
        }
        if (channel == 1) {
            this.binary.setThreshold(this.threshold[0] + 1);
        } else {
            this.binary.setThreshold(this.threshold[0] + 1, this.threshold[1] + 1, this.threshold[2] + 1);
        }
        this.binary.Filter(Original, Result, nbCPU);
    }

    private double partialSum(int[] y, int j) {
        double x = 0.0;
        for (int i2 = 0; i2 <= j; ++i2) {
            x += (double)y[i2];
        }
        return x;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    @Override
    public int[] getThresholds() {
        return this.threshold;
    }

    @Override
    public int getThreshold(int channel) {
        return this.threshold[channel];
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Only 1 parameter required.");
        }
        this.Percentile((Integer)parameters[0]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.percentile);
        return params;
    }

    public int Percentile() {
        return this.percentile;
    }

    public void Percentile(int percentile) {
        if (percentile < 0 || 100 < percentile) {
            throw new IllegalArgumentException("The percentile is not into the range [0,100].");
        }
        this.percentile = percentile;
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public ImageThresholder Clone() {
        return new PercentileThresholding(this.percentile);
    }
}

