/*
 * Decompiled with CFR 0.152.
 */
package processing.thresholding;

import dv.DV;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import measures.histogram.Histogram;
import processing.thresholding.BinaryDouble;
import processing.thresholding.ImageThresholder;

public class PercentileDoubleThresholding
implements ImageThresholder {
    private BinaryDouble binary = new BinaryDouble();
    private Histogram histogram = new Histogram();
    private int[] thresholds = null;
    private int ForbiddenValue = -1;
    private int percentilemin = 50;
    private int percentilemax = 75;

    public PercentileDoubleThresholding() {
    }

    public PercentileDoubleThresholding(int percentilemin, int percentilemax) {
        this.Percentiles(percentilemin, percentilemax);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        return this.Filter(source, this.ForbiddenValue, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage source, int ForbiddenValue, int nbCPU) {
        BufferedImage result = ImageNew.SameBinary((BufferedImage)source);
        this.Filter(source, result, ForbiddenValue, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        this.Filter(Original, Result, this.ForbiddenValue, nbCPU);
    }

    @Override
    public void Filter(BufferedImage Original, BufferedImage Result, int ForbiddenValue, int nbCPU) {
        this.Filter(Original, this.percentilemin, this.percentilemax, ForbiddenValue, Result, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int percentilemin, int percentilemax, int ForbiddenValue, int nbCPU) {
        BufferedImage result = ImageNew.SameBinary((BufferedImage)source);
        this.Filter(source, percentilemin, percentilemax, ForbiddenValue, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, int percentilemin, int percentilemax, int ForbiddenValue, BufferedImage Result, int nbCPU) {
        int MAX;
        int channel = Original.getRaster().getNumBands();
        if (channel != 1) {
            throw new IllegalArgumentException("Only images with one channel/band are supported.");
        }
        switch (Original.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 10: {
                MAX = 256;
                break;
            }
            case 11: {
                MAX = 65536;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        if (this.thresholds == null || this.thresholds.length != channel << 1) {
            this.thresholds = null;
            this.thresholds = new int[channel << 1];
        }
        Arrays.fill(this.thresholds, -1);
        double[] avec = new double[MAX];
        this.ForbiddenValue = ForbiddenValue;
        this.histogram.Fill(Original, ForbiddenValue);
        for (int c = 0; c < channel; ++c) {
            int i2;
            int[] data = this.histogram.getValues(c);
            double total = this.partialSum(data, MAX - 1);
            double ptile = (double)percentilemin / 100.0;
            Arrays.fill(avec, 0.0);
            double temp = 1.0;
            for (i2 = 0; i2 < MAX; ++i2) {
                avec[i2] = Math.abs(this.partialSum(data, i2) / total - ptile);
                if (!(avec[i2] < temp)) continue;
                temp = avec[i2];
                this.thresholds[c << 1] = i2;
            }
            ptile = (double)percentilemax / 100.0;
            Arrays.fill(avec, 0.0);
            temp = 1.0;
            for (i2 = 0; i2 < MAX; ++i2) {
                avec[i2] = Math.abs(this.partialSum(data, i2) / total - ptile);
                if (!(avec[i2] < temp)) continue;
                temp = avec[i2];
                this.thresholds[(c << 1) + 1] = i2;
            }
            data = null;
        }
        avec = null;
        switch (channel) {
            case 1: {
                this.binary.setThresholds(this.thresholds);
                break;
            }
            default: {
                throw new IllegalArgumentException("Only one channel supported.");
            }
        }
        this.binary.Filter(Original, Result, nbCPU);
    }

    private double partialSum(int[] y, int j) {
        double x = 0.0;
        for (int i2 = 0; i2 <= j; ++i2) {
            x += (double)y[i2];
        }
        return x;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    @Override
    public int[] getThresholds() {
        return this.thresholds;
    }

    @Override
    public int getThreshold(int channel) {
        return this.thresholds[channel];
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("2 parameters required.");
        }
        this.Percentiles((Integer)parameters[0], (Integer)parameters[1]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.percentilemin);
        params.add(this.percentilemax);
        return params;
    }

    public int PercentileLow() {
        return this.percentilemin;
    }

    public int PercentileHigh() {
        return this.percentilemax;
    }

    public void Percentiles(int min, int max) {
        if (min < 0 || 100 < min) {
            throw new IllegalArgumentException("The min percentile is not into the range [0,100].");
        }
        if (max < 0 || 100 < max) {
            throw new IllegalArgumentException("The max percentile is not into the range [0,100].");
        }
        if (max <= min) {
            throw new IllegalArgumentException("max <= min.");
        }
        this.percentilemin = min;
        this.percentilemax = max;
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public ImageThresholder Clone() {
        return new PercentileDoubleThresholding(this.percentilemin, this.percentilemax);
    }
}

