/*
 * Decompiled with CFR 0.152.
 */
package processing.thresholding;

import dv.DV;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import measures.histogram.Histogram;
import processing.thresholding.Binary;
import processing.thresholding.ImageThresholder;

public class Otsu
implements ImageThresholder {
    protected Binary binary = new Binary();
    protected int[] Threshold = new int[]{-1, -1, -1};
    private int ForbiddenValue = -1;

    public BufferedImage Filter(BufferedImage source) {
        return this.binary.Filter(source, this.ComputeThreshold(source));
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        return this.Filter(source, this.ForbiddenValue, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage source, int ForbiddenValue, int nbCPU) {
        BufferedImage result = ImageNew.SameBinary((BufferedImage)source);
        this.Filter(source, result, ForbiddenValue, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        this.Filter(Original, Result, this.ForbiddenValue, nbCPU);
    }

    @Override
    public void Filter(BufferedImage Original, BufferedImage Result, int ForbiddenValue, int nbCPU) {
        this.ForbiddenValue = ForbiddenValue;
        this.Threshold[0] = this.ComputeThreshold(Original);
        this.binary.Filter(Original, this.Threshold[0], Result, nbCPU);
    }

    public int ComputeThreshold(BufferedImage source) {
        int MAX;
        double sigmaMax = 0.0;
        int threshold = 0;
        switch (source.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 10: {
                MAX = 255;
                break;
            }
            case 11: {
                MAX = 65535;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        GrayLevel C1 = new GrayLevel(source, this.ForbiddenValue, true);
        GrayLevel C2 = new GrayLevel(source, this.ForbiddenValue, false);
        float fullMu = C1.getOmega() * C1.getMu() + C2.getOmega() * C2.getMu();
        for (int i2 = 0; i2 < MAX; ++i2) {
            double v1 = C1.getMu() - fullMu;
            double v2 = C2.getMu() - fullMu;
            double sigma = (double)C1.getOmega() * v1 * v1 + (double)C2.getOmega() * v2 * v2;
            if (sigma > sigmaMax) {
                sigmaMax = sigma;
                threshold = C1.getThreshold();
            }
            C1.addToEnd();
            C2.removeFromBeginning();
        }
        C1 = null;
        C2 = null;
        return threshold;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    @Override
    public int[] getThresholds() {
        return this.Threshold;
    }

    @Override
    public int getThreshold(int channel) {
        return this.Threshold[channel];
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public ImageThresholder Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    private class GrayLevel {
        protected float[] probabilityHistogram;
        public boolean probabilityHistogramDone = false;
        public int MAX;
        public int N;
        protected int index;
        protected float omega;
        protected float mu;
        protected Histogram histo = new Histogram();

        public GrayLevel(BufferedImage img, int ForbiddenValue, boolean first) {
            switch (img.getType()) {
                case 10: {
                    this.MAX = 256;
                    break;
                }
                case 11: {
                    this.MAX = 65536;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Image type not supported.");
                }
            }
            this.N = img.getWidth() * img.getHeight();
            if (!this.probabilityHistogramDone) {
                this.histo.Fill(img, ForbiddenValue);
                int[] histogram = this.histo.getValues(0);
                this.probabilityHistogram = new float[this.MAX];
                for (int i2 = 0; i2 < this.MAX; ++i2) {
                    this.probabilityHistogram[i2] = (float)histogram[i2] / (float)this.N;
                }
                this.probabilityHistogramDone = true;
            }
            if (first) {
                this.index = 1;
                this.omega = this.probabilityHistogram[this.index - 1];
                this.mu = (double)this.omega == 0.0 ? 0.0f : this.probabilityHistogram[this.index - 1] / this.omega;
            } else {
                this.index = 2;
                this.omega = 0.0f;
                this.mu = 0.0f;
                for (int i3 = this.index; i3 < this.MAX; ++i3) {
                    this.omega += this.probabilityHistogram[i3 - 1];
                    this.mu += this.probabilityHistogram[i3 - 1] * (float)i3;
                }
                this.mu = (double)this.omega == 0.0 ? 0.0f : (this.mu /= this.omega);
            }
        }

        public void removeFromBeginning() {
            ++this.index;
            this.mu = 0.0f;
            this.omega = 0.0f;
            for (int i2 = this.index; i2 < this.MAX; ++i2) {
                this.omega += this.probabilityHistogram[i2 - 1];
                this.mu += (float)i2 * this.probabilityHistogram[i2 - 1];
            }
            this.mu = (double)this.omega == 0.0 ? 0.0f : (this.mu /= this.omega);
        }

        public void addToEnd() {
            ++this.index;
            this.mu = 0.0f;
            this.omega = 0.0f;
            for (int i2 = 1; i2 < this.index; ++i2) {
                this.omega += this.probabilityHistogram[i2 - 1];
                this.mu += (float)i2 * this.probabilityHistogram[i2 - 1];
            }
            this.mu = (double)this.omega == 0.0 ? 0.0f : (this.mu /= this.omega);
        }

        public String toString() {
            StringBuilder ret = new StringBuilder(113);
            ret.append("Index : ").append(this.index).append("\n");
            ret.append("Mu : ").append(this.mu).append("\n");
            ret.append("Omega : ").append(this.omega).append("\n");
            return ret.toString();
        }

        public float getMu() {
            return this.mu;
        }

        public float getOmega() {
            return this.omega;
        }

        public int getThreshold() {
            return this.index;
        }
    }
}

