/*
 * Decompiled with CFR 0.152.
 */
package processing.thresholding;

import arrayTiTi.ArrayConverter;
import dv.DV;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import measures.histogram.Histogram;
import processing.thresholding.Binary;
import processing.thresholding.ImageThresholder;

public class MinimumThresholding
implements ImageThresholder {
    private Binary binary = new Binary();
    private Histogram histogram = new Histogram();
    private int[] threshold = null;
    private int ForbiddenValue = -1;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        return this.Filter(source, this.ForbiddenValue, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage source, int ForbiddenValue, int nbCPU) {
        BufferedImage result = ImageNew.SameBinary((BufferedImage)source);
        this.Filter(source, result, ForbiddenValue, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        this.Filter(Original, Result, this.ForbiddenValue, nbCPU);
    }

    @Override
    public void Filter(BufferedImage Original, BufferedImage Result, int ForbiddenValue, int nbCPU) {
        int MAX;
        int channel = Original.getRaster().getNumBands();
        switch (Original.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 10: {
                MAX = 255;
                break;
            }
            case 11: {
                MAX = 65535;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        if (this.threshold == null || this.threshold.length != channel) {
            this.threshold = null;
            this.threshold = new int[channel];
        }
        Arrays.fill(this.threshold, -1);
        this.ForbiddenValue = ForbiddenValue;
        this.histogram.Fill(Original, ForbiddenValue);
        for (int c = 0; c < channel; ++c) {
            int i2;
            int iter = 0;
            this.threshold[c] = -1;
            double[] iHisto = ArrayConverter.IntToDouble((int[])this.histogram.getValues(c));
            double[] tHisto = new double[iHisto.length];
            while (!this.bimodalTest(iHisto)) {
                for (i2 = 1; i2 < MAX; ++i2) {
                    tHisto[i2] = (iHisto[i2 - 1] + iHisto[i2] + iHisto[i2 + 1]) / 3.0;
                }
                tHisto[0] = (iHisto[0] + iHisto[1]) / 3.0;
                tHisto[MAX] = (iHisto[MAX - 1] + iHisto[MAX]) / 3.0;
                System.arraycopy(tHisto, 0, iHisto, 0, iHisto.length);
                if (++iter <= 10000) continue;
                throw new IllegalStateException("Minimum: threshold not found after 10000 iterations.");
            }
            for (i2 = 1; i2 < MAX; ++i2) {
                if (!(iHisto[i2 - 1] > iHisto[i2]) || !(iHisto[i2 + 1] >= iHisto[i2])) continue;
                this.threshold[c] = i2;
            }
        }
        if (channel == 1) {
            this.binary.setThreshold(this.threshold[0] + 1);
        } else {
            this.binary.setThreshold(this.threshold[0] + 1, this.threshold[1] + 1, this.threshold[2] + 1);
        }
        this.binary.Filter(Original, Result, nbCPU);
    }

    boolean bimodalTest(double[] y) {
        int len = y.length;
        boolean b = false;
        int modes = 0;
        for (int k = 1; k < len - 1; ++k) {
            if (!(y[k - 1] < y[k]) || !(y[k + 1] < y[k]) || ++modes <= 2) continue;
            return false;
        }
        if (modes == 2) {
            b = true;
        }
        return b;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    @Override
    public int[] getThresholds() {
        return this.threshold;
    }

    @Override
    public int getThreshold(int channel) {
        return this.threshold[channel];
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public ImageThresholder Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

