/*
 * Decompiled with CFR 0.152.
 */
package processing.thresholding;

import dv.DV;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import measures.histogram.Histogram;
import processing.thresholding.Binary;
import processing.thresholding.ImageThresholder;

public class MinError
implements ImageThresholder {
    private Binary binary = new Binary();
    private Histogram histogram = new Histogram();
    private int[] threshold = null;
    private int ForbiddenValue = -1;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        return this.Filter(source, this.ForbiddenValue, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage source, int ForbiddenValue, int nbCPU) {
        BufferedImage result = ImageNew.SameBinary((BufferedImage)source);
        this.Filter(source, result, ForbiddenValue, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        this.Filter(Original, Result, this.ForbiddenValue, nbCPU);
    }

    @Override
    public void Filter(BufferedImage Original, BufferedImage Result, int ForbiddenValue, int nbCPU) {
        int MAX;
        int channel = Original.getRaster().getNumBands();
        switch (Original.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 10: {
                MAX = 256;
                break;
            }
            case 11: {
                MAX = 65536;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        if (this.threshold == null || this.threshold.length != channel) {
            this.threshold = null;
            this.threshold = new int[channel];
        }
        Arrays.fill(this.threshold, -1);
        this.ForbiddenValue = ForbiddenValue;
        this.histogram.Fill(Original, ForbiddenValue);
        for (int c = 0; c < channel; ++c) {
            int[] data = this.histogram.getValues(c);
            this.threshold[c] = this.Mean(data, MAX);
            int Tprev = -2;
            while (this.threshold[c] != Tprev) {
                double w2;
                double w0;
                double tau2;
                double mu = this.B(data, this.threshold[c]) / this.A(data, this.threshold[c]);
                double nu = (this.B(data, MAX - 1) - this.B(data, this.threshold[c])) / (this.A(data, MAX - 1) - this.A(data, this.threshold[c]));
                double p = this.A(data, this.threshold[c]) / this.A(data, MAX - 1);
                double q = (this.A(data, MAX - 1) - this.A(data, this.threshold[c])) / this.A(data, MAX - 1);
                double sigma2 = this.C(data, this.threshold[c]) / this.A(data, this.threshold[c]) - mu * mu;
                double w1 = mu / sigma2 - nu / (tau2 = (this.C(data, MAX - 1) - this.C(data, this.threshold[c])) / (this.A(data, MAX - 1) - this.A(data, this.threshold[c])) - nu * nu);
                double sqterm = w1 * w1 - (w0 = 1.0 / sigma2 - 1.0 / tau2) * (w2 = mu * mu / sigma2 - nu * nu / tau2 + Math.log10(sigma2 * q * q / (tau2 * p * p)));
                if (sqterm < 0.0) {
                    throw new Error("MinError(I): not converging.");
                }
                Tprev = this.threshold[c];
                double temp = (w1 + Math.sqrt(sqterm)) / w0;
                if (Double.isNaN(temp)) {
                    throw new Error("MinError(I): NaN, not converging.");
                }
                this.threshold[c] = (int)Math.floor(temp);
            }
        }
        if (channel == 1) {
            this.binary.setThreshold(this.threshold[0] + 1);
        } else {
            this.binary.setThreshold(this.threshold[0] + 1, this.threshold[1] + 1, this.threshold[2] + 1);
        }
        this.binary.Filter(Original, Result, nbCPU);
    }

    private int Mean(int[] data, int MAX) {
        double tot = 0.0;
        double sum = 0.0;
        for (int i2 = 0; i2 < MAX; ++i2) {
            tot += (double)data[i2];
            sum += (double)(i2 * data[i2]);
        }
        return (int)Math.floor(sum / tot);
    }

    private double A(int[] y, int j) {
        double x = 0.0;
        for (int i2 = 0; i2 <= j; ++i2) {
            x += (double)y[i2];
        }
        return x;
    }

    private double B(int[] y, int j) {
        double x = 0.0;
        for (int i2 = 0; i2 <= j; ++i2) {
            x += (double)(i2 * y[i2]);
        }
        return x;
    }

    private double C(int[] y, int j) {
        double x = 0.0;
        for (int i2 = 0; i2 <= j; ++i2) {
            x += (double)(i2 * i2 * y[i2]);
        }
        return x;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    @Override
    public int[] getThresholds() {
        return this.threshold;
    }

    @Override
    public int getThreshold(int channel) {
        return this.threshold[channel];
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public ImageThresholder Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

