/*
 * Decompiled with CFR 0.152.
 */
package processing.thresholding;

import arrayTiTi.ArrayFeatures;
import dv.DV;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import measures.histogram.Histogram;
import processing.thresholding.Binary;
import processing.thresholding.ImageThresholder;

public class Li
implements ImageThresholder {
    private final Binary binary = new Binary();
    private final Histogram histogram = new Histogram();
    private int[] threshold = null;
    private int ForbiddenValue = -1;
    private final ArrayFeatures AF = new ArrayFeatures();

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        return this.Filter(source, this.ForbiddenValue, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage source, int ForbiddenValue, int nbCPU) {
        BufferedImage result = ImageNew.SameBinary((BufferedImage)source);
        this.Filter(source, result, ForbiddenValue, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        this.Filter(Original, Result, this.ForbiddenValue, nbCPU);
    }

    @Override
    public void Filter(BufferedImage Original, BufferedImage Result, int ForbiddenValue, int nbCPU) {
        int channel = Original.getRaster().getNumBands();
        double tolerance = 0.5;
        if (this.threshold == null || this.threshold.length != channel) {
            this.threshold = null;
            this.threshold = new int[channel];
        }
        Arrays.fill(this.threshold, -1);
        this.ForbiddenValue = ForbiddenValue;
        this.histogram.Fill(Original, ForbiddenValue);
        switch (Original.getType()) {
            case 5: 
            case 6: 
            case 10: {
                for (int c = 0; c < channel; ++c) {
                    double old_thresh;
                    double mean_obj;
                    double mean_back;
                    double temp;
                    int[] data = this.histogram.getValues(c);
                    int num_pixels = (int)this.AF.Integral(data);
                    double mean = 0.0;
                    for (int ih = 1; ih < data.length; ++ih) {
                        mean += (double)(ih * data[ih]) / (double)num_pixels;
                    }
                    double new_thresh = mean;
                    do {
                        old_thresh = new_thresh;
                        this.threshold[c] = (int)(old_thresh + 0.5);
                        int num_back = (int)this.AF.Integral(data, 0, this.threshold[c] + 1);
                        mean_back = 0.0;
                        for (int ih = 0; ih <= this.threshold[c]; ++ih) {
                            mean_back += (double)(ih * data[ih]) / (double)num_back;
                        }
                        int num_obj = (int)this.AF.Integral(data, this.threshold[c] + 1, data.length);
                        mean_obj = 0.0;
                        for (int ih = this.threshold[c] + 1; ih < data.length; ++ih) {
                            mean_obj += (double)(ih * data[ih]) / (double)num_obj;
                        }
                    } while (Math.abs((new_thresh = (temp = (mean_back - mean_obj) / (Math.log(mean_back) - Math.log(mean_obj))) < 0.0 ? (double)((int)(temp - 0.5)) : (double)((int)(temp + 0.5))) - old_thresh) > tolerance);
                }
                break;
            }
            case 11: {
                for (int c = 0; c < channel; ++c) {
                    double old_thresh;
                    double mean_obj;
                    double mean_back;
                    double temp;
                    int[] data = this.histogram.getValues(c);
                    int num_pixels = (int)this.AF.Integral(data);
                    double mean = 0.0;
                    for (int ih = 1; ih < data.length; ++ih) {
                        mean += (double)((long)ih * (long)data[ih]) / (double)num_pixels;
                    }
                    double new_thresh = mean;
                    do {
                        old_thresh = new_thresh;
                        this.threshold[c] = (int)(old_thresh + 0.5);
                        int num_back = (int)this.AF.Integral(data, 0, this.threshold[c] + 1);
                        mean_back = 0.0;
                        for (int ih = 0; ih <= this.threshold[c]; ++ih) {
                            mean_back += (double)((long)ih * (long)data[ih]) / (double)num_back;
                        }
                        int num_obj = (int)this.AF.Integral(data, this.threshold[c] + 1, data.length);
                        mean_obj = 0.0;
                        for (int ih = this.threshold[c] + 1; ih < data.length; ++ih) {
                            mean_obj += (double)((long)ih * (long)data[ih]) / (double)num_obj;
                        }
                    } while (Math.abs((new_thresh = (temp = (mean_back - mean_obj) / (Math.log(mean_back) - Math.log(mean_obj))) < 0.0 ? (double)((int)(temp - 0.5)) : (double)((int)(temp + 0.5))) - old_thresh) > tolerance);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        if (channel == 1) {
            this.binary.setThreshold(this.threshold[0] + 1);
        } else {
            this.binary.setThreshold(this.threshold[0] + 1, this.threshold[1] + 1, this.threshold[2] + 1);
        }
        this.binary.Filter(Original, Result, nbCPU);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    @Override
    public int[] getThresholds() {
        return this.threshold;
    }

    @Override
    public int getThreshold(int channel) {
        return this.threshold[channel];
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public ImageThresholder Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

