/*
 * Decompiled with CFR 0.152.
 */
package processing.thresholding;

import dv.DV;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import measures.histogram.Histogram;
import processing.thresholding.Binary;
import processing.thresholding.ImageThresholder;

public class Huang
implements ImageThresholder {
    private Binary binary = new Binary();
    private Histogram histogram = new Histogram();
    private int[] threshold = null;
    private double[] mu_0;
    private double[] mu_1;
    private int ForbiddenValue = -1;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        return this.Filter(source, this.ForbiddenValue, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage source, int ForbiddenValue, int nbCPU) {
        BufferedImage result = ImageNew.SameBinary((BufferedImage)source);
        this.Filter(source, result, ForbiddenValue, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        this.Filter(Original, Result, this.ForbiddenValue, nbCPU);
    }

    @Override
    public void Filter(BufferedImage Original, BufferedImage Result, int ForbiddenValue, int nbCPU) {
        int MAX;
        int channel = Original.getRaster().getNumBands();
        switch (Original.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 10: {
                MAX = 256;
                break;
            }
            case 11: {
                MAX = 65536;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        if (this.mu_0 == null || this.mu_0.length != MAX) {
            this.mu_1 = null;
            this.mu_0 = null;
            this.mu_0 = new double[MAX];
            this.mu_1 = new double[MAX];
        }
        if (this.threshold == null || this.threshold.length != channel) {
            this.threshold = null;
            this.threshold = new int[channel];
        }
        Arrays.fill(this.threshold, -1);
        this.ForbiddenValue = ForbiddenValue;
        this.histogram.Fill(Original, ForbiddenValue);
        for (int c = 0; c < channel; ++c) {
            int ih;
            int[] data = this.histogram.getValues(c);
            int first_bin = this.histogram.getMinColors()[c];
            int last_bin = this.histogram.getMaxColors()[c];
            double term = 1.0 / (double)(last_bin - first_bin);
            Arrays.fill(this.mu_0, 0.0);
            double sum_pix = 0.0;
            double num_pix = 0.0;
            for (ih = first_bin; ih < MAX; ++ih) {
                this.mu_0[ih] = (sum_pix += (double)ih * (double)data[ih]) / (num_pix += (double)data[ih]);
            }
            Arrays.fill(this.mu_1, 0.0);
            num_pix = 0.0;
            sum_pix = 0.0;
            for (ih = last_bin; ih > 0; --ih) {
                this.mu_1[ih - 1] = (sum_pix += (double)ih * (double)data[ih]) / (num_pix += (double)data[ih]);
            }
            this.threshold[c] = -1;
            double min_ent = Double.MAX_VALUE;
            for (int it = 0; it < MAX; ++it) {
                double mu_x;
                int ih2;
                double ent = 0.0;
                for (ih2 = 0; ih2 <= it; ++ih2) {
                    if (data[ih2] == 0 || (mu_x = 1.0 / (1.0 + term * Math.abs((double)ih2 - this.mu_0[it]))) < 1.0E-6 || mu_x > 0.999999) continue;
                    ent += (double)data[ih2] * (-mu_x * Math.log(mu_x) - (1.0 - mu_x) * Math.log(1.0 - mu_x));
                }
                for (ih2 = it + 1; ih2 < MAX; ++ih2) {
                    if (data[ih2] == 0 || (mu_x = 1.0 / (1.0 + term * Math.abs((double)ih2 - this.mu_1[it]))) < 1.0E-6 || mu_x > 0.999999) continue;
                    ent += (double)data[ih2] * (-mu_x * Math.log(mu_x) - (1.0 - mu_x) * Math.log(1.0 - mu_x));
                }
                if (!(ent < min_ent)) continue;
                min_ent = ent;
                this.threshold[c] = it;
            }
        }
        if (channel == 1) {
            this.binary.setThreshold(this.threshold[0] + 1);
        } else {
            this.binary.setThreshold(this.threshold[0] + 1, this.threshold[1] + 1, this.threshold[2] + 1);
        }
        this.binary.Filter(Original, Result, nbCPU);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    @Override
    public int[] getThresholds() {
        return this.threshold;
    }

    @Override
    public int getThreshold(int channel) {
        return this.threshold[channel];
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        return params;
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public ImageThresholder Clone() {
        return new Huang();
    }
}

