/*
 * Decompiled with CFR 0.152.
 */
package processing.thresholding;

import dv.DV;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import measures.histogram.Histogram;
import processing.thresholding.Binary;
import processing.thresholding.ImageThresholder;

public class Entropy
implements ImageThresholder {
    protected Histogram histo = new Histogram();
    protected Binary binary = new Binary();
    private int[] threshold = null;
    private int ForbiddenValue = -1;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        return this.Filter(source, this.ForbiddenValue, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage source, int ForbiddenValue, int nbCPU) {
        BufferedImage result = ImageNew.SameBinary((BufferedImage)source);
        this.Filter(source, result, ForbiddenValue, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        this.Filter(Original, Result, this.ForbiddenValue, nbCPU);
    }

    @Override
    public void Filter(BufferedImage Original, BufferedImage Result, int ForbiddenValue, int nbCPU) {
        int channel = Original.getRaster().getNumBands();
        if (this.threshold == null || this.threshold.length != channel) {
            this.threshold = null;
            this.threshold = new int[channel];
        }
        Arrays.fill(this.threshold, -1);
        this.ForbiddenValue = ForbiddenValue;
        this.histo.Fill(Original, ForbiddenValue);
        for (int c = 0; c < channel; ++c) {
            this.threshold[c] = this.ComputeThreshold(this.histo.getValues(c));
        }
        if (channel == 1) {
            this.binary.setThreshold(this.threshold[0]);
        } else {
            this.binary.setThreshold(this.threshold[0], this.threshold[1], this.threshold[2]);
        }
        this.binary.Filter(Original, Result, nbCPU);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public int ComputeThreshold(int[] hist) {
        int t;
        int i2;
        double sum = 0.0;
        for (i2 = 0; i2 < hist.length; ++i2) {
            sum += (double)hist[i2];
        }
        if (sum == 0.0) {
            throw new IllegalArgumentException("Empty histogram: sum of all bins is zero.");
        }
        double[] normalizedHist = new double[hist.length];
        for (i2 = 0; i2 < hist.length; ++i2) {
            normalizedHist[i2] = (double)hist[i2] / sum;
        }
        double[] pT = new double[hist.length];
        pT[0] = normalizedHist[0];
        for (i2 = 1; i2 < hist.length; ++i2) {
            pT[i2] = pT[i2 - 1] + normalizedHist[i2];
        }
        double epsilon = Double.MIN_VALUE;
        double[] hB = new double[hist.length];
        double[] hW = new double[hist.length];
        for (t = 0; t < hist.length; ++t) {
            if (pT[t] > Double.MIN_VALUE) {
                double hhB = 0.0;
                for (i2 = 0; i2 <= t; ++i2) {
                    if (!(normalizedHist[i2] > Double.MIN_VALUE)) continue;
                    hhB -= normalizedHist[i2] / pT[t] * Math.log(normalizedHist[i2] / pT[t]);
                }
                hB[t] = hhB;
            } else {
                hB[t] = 0.0;
            }
            double pTW = 1.0 - pT[t];
            if (pTW > Double.MIN_VALUE) {
                double hhW = 0.0;
                for (i2 = t + 1; i2 < hist.length; ++i2) {
                    if (!(normalizedHist[i2] > Double.MIN_VALUE)) continue;
                    hhW -= normalizedHist[i2] / pTW * Math.log(normalizedHist[i2] / pTW);
                }
                hW[t] = hhW;
                continue;
            }
            hW[t] = 0.0;
        }
        double jMax = hB[0] + hW[0];
        int tMax = 0;
        for (t = 1; t < hist.length; ++t) {
            double j = hB[t] + hW[t];
            if (!(j > jMax)) continue;
            jMax = j;
            tMax = t;
        }
        pT = null;
        normalizedHist = null;
        hB = null;
        hW = null;
        return tMax;
    }

    @Override
    public int[] getThresholds() {
        return this.threshold;
    }

    @Override
    public int getThreshold(int channel) {
        return this.threshold[channel];
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        return null;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public ImageThresholder Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

