/*
 * Decompiled with CFR 0.152.
 */
package processing.thresholding;

import dv.DV;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import mathematics.Maths;
import processing.thresholding.ImageThresholder;

public class BinaryDouble
implements ImageThresholder {
    private int[] Thresholds = null;
    private double[] Thresh = null;

    public BinaryDouble() {
    }

    public BinaryDouble(int min, int max) {
        this.setThresholds(min, max);
    }

    public BinaryDouble(int[] Threshold) {
        this.setThresholds(Threshold);
    }

    public BinaryDouble(double[] Threshold) {
        this.setThresholds(Threshold);
    }

    @Override
    public BufferedImage Filter(BufferedImage Original, int ForbiddenValue, int nbCPU) {
        return this.Filter(Original, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.SameBinary((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    @Override
    public void Filter(BufferedImage Original, BufferedImage Result, int ForbiddenValue, int nbCPU) {
        this.Filter(Original, Result, nbCPU);
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        if (this.Thresholds == null) {
            throw new IllegalStateException("Any threshold(s) defined.");
        }
        if (Result.getType() != 12) {
            throw new IllegalArgumentException("Result image must be binary.");
        }
        int channel = Original.getRaster().getNumBands();
        int width = Original.getWidth();
        int height = Original.getHeight();
        WritableRaster wrr = Result.getRaster();
        switch (Original.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                int min = this.Thresholds[0];
                int max = this.Thresholds[1];
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        int v = bb[pos] & 0xFF;
                        if (min <= v && v <= max) {
                            wrr.setSample(x, y, 0, 1);
                        } else {
                            wrr.setSample(x, y, 0, 0);
                        }
                        ++x;
                        ++pos;
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                int min = this.Thresholds[0];
                int max = this.Thresholds[1];
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        int v = sb[pos] & 0xFFFF;
                        if (min <= v && v <= max) {
                            wrr.setSample(x, y, 0, 1);
                        } else {
                            wrr.setSample(x, y, 0, 0);
                        }
                        ++x;
                        ++pos;
                    }
                }
                sb = null;
                break;
            }
            case 5: 
            case 6: {
                if (this.Thresholds.length < 6) {
                    throw new Error("Less thresholds than channels are defined.");
                }
                byte[] bbbgr = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int res = 1;
                        int t = 0;
                        int c = 0;
                        while (c < channel) {
                            int v = bbbgr[pos] & 0xFF;
                            res = this.Thresholds[t] <= v && v <= this.Thresholds[t + 1] ? (res &= 1) : (res &= 0);
                            ++c;
                            t += 2;
                            ++pos;
                        }
                        wrr.setSample(x, y, 0, res);
                    }
                }
                bbbgr = null;
                break;
            }
            case 1: 
            case 4: {
                if (this.Thresholds.length < 6) {
                    throw new Error("Less thresholds than channels are defined.");
                }
                int[] ib = ((DataBufferInt)Original.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int res = 1;
                        int t = 0;
                        int c = 0;
                        while (c < channel) {
                            int v = ib[pos];
                            res = this.Thresholds[t] <= v && v <= this.Thresholds[t + 1] ? (res &= 1) : (res &= 0);
                            ++c;
                            t += 2;
                            ++pos;
                        }
                        wrr.setSample(x, y, 0, res);
                    }
                }
                ib = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        wrr = null;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Parameters(Object ... parameters) {
        switch (parameters.length) {
            case 1: {
                if (parameters[0] instanceof int[]) {
                    this.setThresholds((int[])parameters[0]);
                    break;
                }
                if (parameters[0] instanceof double[]) {
                    this.setThresholds((double[])parameters[0]);
                    break;
                }
                throw new IllegalArgumentException("The parameter is not an array of int or double.");
            }
            case 2: {
                if (parameters[0] instanceof Integer && parameters[1] instanceof Integer) {
                    this.setThresholds((Integer)parameters[0], (Integer)parameters[1]);
                    break;
                }
                if (parameters[0] instanceof Double && parameters[1] instanceof Double) {
                    this.setThresholds((Double)parameters[0], (Double)parameters[1]);
                    break;
                }
                throw new IllegalArgumentException("The parameters are not int or double.");
            }
            default: {
                throw new IllegalArgumentException("1 or 2 parameter(s) required.");
            }
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.Thresholds);
        params.add(this.Thresh);
        return params;
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public ImageThresholder Clone() {
        BinaryDouble clone = new BinaryDouble();
        if (this.Thresholds != null) {
            clone.setThresholds(this.Thresholds);
        }
        if (this.Thresh != null) {
            clone.setThresholds(this.Thresh);
        }
        return clone;
    }

    public void setThresholds(int[] thresholds) {
        if (Maths.ModuloDyadic((int)thresholds.length, (int)2) != 0) {
            throw new IllegalArgumentException("The array of thresholds has not an even number of values.");
        }
        this.Thresholds = null;
        this.Thresholds = (int[])thresholds.clone();
    }

    public void setThresholds(int min, int max) {
        this.Thresholds = null;
        this.Thresholds = new int[]{min, max};
    }

    @Override
    public int[] getThresholds() {
        return this.Thresholds;
    }

    @Override
    public int getThreshold(int channel) {
        return this.Thresholds[channel];
    }

    public void setThresholds(double[] thresholds) {
        if (Maths.ModuloDyadic((int)thresholds.length, (int)2) != 0) {
            throw new IllegalArgumentException("The array of thresholds has not an even number of values.");
        }
        this.Thresh = null;
        this.Thresh = (double[])thresholds.clone();
    }

    public void setThresholds(double min, double max) {
        this.Thresh = null;
        this.Thresh = new double[]{min, max};
    }

    public double[] getThresholdsDouble() {
        return this.Thresh;
    }
}

