/*
 * Decompiled with CFR 0.152.
 */
package processing.thresholding;

import arrayTiTi.ArrayNew;
import arrayTiTi.ArrayTools;
import dv.DV;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import processing.thresholding.ImageThresholder;

public class Binary
implements ImageThresholder {
    private int ThresholdR = -1;
    private int ThresholdG = -1;
    private int ThresholdB = -1;
    private int ThresholdA = -1;
    private double Threshold = -1.0;

    public Binary() {
    }

    public Binary(int Threshold) {
        this.setThreshold(Threshold);
    }

    public Binary(double Threshold) {
        this.setThreshold(Threshold);
    }

    public Binary(int ThresholdR, int ThresholdG, int ThresholdB) {
        this.setThreshold(ThresholdR, ThresholdG, ThresholdB);
    }

    public Binary(int ThresholdR, int ThresholdG, int ThresholdB, int ThresholdA) {
        this.setThreshold(ThresholdR, ThresholdG, ThresholdB, ThresholdA);
    }

    @Override
    public BufferedImage Filter(BufferedImage Original, int Threshold, int nbCPU) {
        this.setThreshold(Threshold);
        return this.Filter(Original, nbCPU);
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = null;
        switch (source.getType()) {
            case 10: 
            case 11: {
                result = ImageNew.Same((BufferedImage)source);
                break;
            }
            default: {
                result = new BufferedImage(source.getWidth(), source.getHeight(), 12);
            }
        }
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, int Threshold, BufferedImage Result, int nbCPU) {
        this.setThreshold(Threshold);
        this.Filter(Original, Result, nbCPU);
    }

    @Override
    public void Filter(BufferedImage Original, BufferedImage Result, int ForbiddenValue, int nbCPU) {
        this.Filter(Original, Result, nbCPU);
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        if (this.ThresholdR < 0 && this.Threshold < 0.0) {
            throw new IllegalStateException("No threshold(s) defined.");
        }
        int channel = Original.getRaster().getNumBands();
        int width = Original.getWidth();
        int height = Original.getHeight();
        WritableRaster wrr = Result.getRaster();
        block0 : switch (Original.getType()) {
            case 10: {
                if (this.ThresholdR < 0) {
                    throw new IllegalStateException("No threshold(s) defined for gray level images.");
                }
                byte[] data = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                switch (Result.getType()) {
                    case 12: {
                        int pos = 0;
                        for (int i2 = 0; i2 < height; ++i2) {
                            int j = 0;
                            while (j < width) {
                                if ((data[pos] & 0xFF) < this.ThresholdR) {
                                    wrr.setSample(j, i2, 0, 0);
                                } else {
                                    wrr.setSample(j, i2, 0, 1);
                                }
                                ++j;
                                ++pos;
                            }
                        }
                        break;
                    }
                    case 10: {
                        byte[] bbres = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                        for (int pos = 0; pos < bbres.length; ++pos) {
                            bbres[pos] = (data[pos] & 0xFF) < this.ThresholdR ? 0 : -1;
                        }
                        bbres = null;
                        break;
                    }
                    case 11: {
                        short[] sbres = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                        for (int pos = 0; pos < sbres.length; ++pos) {
                            sbres[pos] = (data[pos] & 0xFF) < this.ThresholdR ? 0 : -1;
                        }
                        sbres = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("The resulting image is neither BYTE_BINARY nor BYTE_GRAY.");
                    }
                }
                data = null;
                break;
            }
            case 11: {
                if (this.ThresholdR < 0) {
                    throw new IllegalStateException("No threshold(s) defined for gray level images.");
                }
                short[] datashort = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                switch (Result.getType()) {
                    case 12: {
                        int pos = 0;
                        for (int i3 = 0; i3 < height; ++i3) {
                            int j = 0;
                            while (j < width) {
                                if ((datashort[pos] & 0xFFFF) < this.ThresholdR) {
                                    wrr.setSample(j, i3, 0, 0);
                                } else {
                                    wrr.setSample(j, i3, 0, 1);
                                }
                                ++j;
                                ++pos;
                            }
                        }
                        break;
                    }
                    case 10: {
                        byte[] bbres = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                        for (int pos = 0; pos < bbres.length; ++pos) {
                            bbres[pos] = (datashort[pos] & 0xFFFF) < this.ThresholdR ? 0 : -1;
                        }
                        bbres = null;
                        break;
                    }
                    case 11: {
                        short[] sbres = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                        for (int pos = 0; pos < sbres.length; ++pos) {
                            sbres[pos] = (datashort[pos] & 0xFFFF) < this.ThresholdR ? 0 : -1;
                        }
                        sbres = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("The resulting image is neither BYTE_BINARY nor USHORT_GRAY.");
                    }
                }
                datashort = null;
                break;
            }
            case 5: {
                if (this.ThresholdB < 0 || this.ThresholdG < 0 || this.ThresholdR < 0) {
                    throw new IllegalStateException("No threshold(s) defined for color images.");
                }
                byte[] dbbytebgr = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                switch (Result.getType()) {
                    case 12: {
                        int pos = 0;
                        for (int y = 0; y < height; ++y) {
                            int x = 0;
                            while (x < width) {
                                if ((dbbytebgr[pos] & 0xFF) < this.ThresholdB && (dbbytebgr[pos + 1] & 0xFF) < this.ThresholdG && (dbbytebgr[pos + 2] & 0xFF) < this.ThresholdR) {
                                    wrr.setSample(x, y, 0, 0);
                                } else {
                                    wrr.setSample(x, y, 0, 1);
                                }
                                ++x;
                                pos += channel;
                            }
                        }
                        break;
                    }
                    case 10: {
                        byte[] bbres = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        int x = 0;
                        while (x < bbres.length) {
                            bbres[x] = (dbbytebgr[pos] & 0xFF) < this.ThresholdB && (dbbytebgr[pos + 1] & 0xFF) < this.ThresholdG && (dbbytebgr[pos + 2] & 0xFF) < this.ThresholdR ? 0 : -1;
                            ++x;
                            pos += channel;
                        }
                        bbres = null;
                        break;
                    }
                    case 11: {
                        short[] sbres = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        int x = 0;
                        while (x < sbres.length) {
                            sbres[x] = (dbbytebgr[pos] & 0xFF) < this.ThresholdB && (dbbytebgr[pos + 1] & 0xFF) < this.ThresholdG && (dbbytebgr[pos + 2] & 0xFF) < this.ThresholdR ? 0 : -1;
                            ++x;
                            pos += channel;
                        }
                        Object bbres = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("The resulting image is neither BYTE_BINARY nor BYTE_GRAY.");
                    }
                }
                dbbytebgr = null;
                break;
            }
            case 6: {
                if (this.ThresholdB < 0 || this.ThresholdG < 0 || this.ThresholdR < 0 || this.ThresholdA < 0) {
                    throw new IllegalStateException("No threshold(s) defined for color images.");
                }
                byte[] dbbyteabgr = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                switch (Result.getType()) {
                    case 12: {
                        int pos = 0;
                        for (int y = 0; y < height; ++y) {
                            int x = 0;
                            while (x < width) {
                                if ((dbbyteabgr[pos] & 0xFF) < this.ThresholdA && (dbbyteabgr[pos + 1] & 0xFF) < this.ThresholdB && (dbbyteabgr[pos + 2] & 0xFF) < this.ThresholdG && (dbbyteabgr[pos + 3] & 0xFF) < this.ThresholdR) {
                                    wrr.setSample(x, y, 0, 0);
                                } else {
                                    wrr.setSample(x, y, 0, 1);
                                }
                                ++x;
                                pos += channel;
                            }
                        }
                        break;
                    }
                    case 10: {
                        byte[] bbres = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        int x = 0;
                        while (x < bbres.length) {
                            bbres[x] = (dbbyteabgr[pos] & 0xFF) < this.ThresholdA && (dbbyteabgr[pos + 1] & 0xFF) < this.ThresholdB && (dbbyteabgr[pos + 2] & 0xFF) < this.ThresholdG && (dbbyteabgr[pos + 3] & 0xFF) < this.ThresholdR ? 0 : -1;
                            ++x;
                            pos += channel;
                        }
                        bbres = null;
                        break;
                    }
                    case 11: {
                        short[] sbres = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        int x = 0;
                        while (x < sbres.length) {
                            sbres[x] = (dbbyteabgr[pos] & 0xFF) < this.ThresholdA && (dbbyteabgr[pos + 1] & 0xFF) < this.ThresholdB && (dbbyteabgr[pos + 2] & 0xFF) < this.ThresholdG && (dbbyteabgr[pos + 3] & 0xFF) < this.ThresholdR ? 0 : -1;
                            ++x;
                            pos += channel;
                        }
                        sbres = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("The resulting image is neither BYTE_BINARY nor BYTE_GRAY.");
                    }
                }
                Object dbbytebgr = null;
                break;
            }
            case 0: {
                switch (Original.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        if (this.Threshold < 0.0) {
                            throw new Error("No threshold(s) defined for images with a DataBufferDouble.");
                        }
                        double[] datadouble = ((DataBufferDouble)Original.getRaster().getDataBuffer()).getData();
                        switch (Result.getType()) {
                            case 12: {
                                int pos = 0;
                                for (int i4 = 0; i4 < height; ++i4) {
                                    int j = 0;
                                    while (j < width) {
                                        if (datadouble[pos] < this.Threshold) {
                                            wrr.setSample(j, i4, 0, 0);
                                        } else {
                                            wrr.setSample(j, i4, 0, 1);
                                        }
                                        ++j;
                                        ++pos;
                                    }
                                }
                                break;
                            }
                            case 0: {
                                if (Result.getRaster().getDataBuffer().getDataType() != 5) {
                                    throw new IllegalArgumentException("The resulting DataBuffer is not Double.");
                                }
                                double[] dbres = ((DataBufferDouble)Result.getRaster().getDataBuffer()).getData();
                                for (int i5 = 0; i5 < dbres.length; ++i5) {
                                    dbres[i5] = datadouble[i5] < this.Threshold ? 0.0 : Double.MAX_VALUE;
                                }
                                dbres = null;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("The resulting image is neither BYTE_BINARY nor CUSTOM.");
                            }
                        }
                        datadouble = null;
                        break block0;
                    }
                    case 4: {
                        if (this.Threshold < 0.0) {
                            throw new Error("No threshold(s) defined for images with a DataBufferDouble.");
                        }
                        float[] datafloat = ((DataBufferFloat)Original.getRaster().getDataBuffer()).getData();
                        switch (Result.getType()) {
                            case 12: {
                                int pos = 0;
                                for (int i6 = 0; i6 < height; ++i6) {
                                    int j = 0;
                                    while (j < width) {
                                        if ((double)datafloat[pos] < this.Threshold) {
                                            wrr.setSample(j, i6, 0, 0);
                                        } else {
                                            wrr.setSample(j, i6, 0, 1);
                                        }
                                        ++j;
                                        ++pos;
                                    }
                                }
                                break;
                            }
                            case 0: {
                                if (Result.getRaster().getDataBuffer().getDataType() != 4) {
                                    throw new IllegalArgumentException("The resulting DataBuffer is not Float.");
                                }
                                float[] fbres = ((DataBufferFloat)Result.getRaster().getDataBuffer()).getData();
                                for (int i7 = 0; i7 < fbres.length; ++i7) {
                                    fbres[i7] = (double)datafloat[i7] < this.Threshold ? 0.0f : Float.MAX_VALUE;
                                }
                                fbres = null;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("The resulting image is neither BYTE_BINARY nor CUSTOM.");
                            }
                        }
                        datafloat = null;
                        break block0;
                    }
                    case 3: {
                        int[] dataint = ((DataBufferInt)Original.getRaster().getDataBuffer()).getData();
                        switch (Result.getType()) {
                            case 12: {
                                int pos = 0;
                                for (int i8 = 0; i8 < height; ++i8) {
                                    int j = 0;
                                    while (j < width) {
                                        if ((double)dataint[pos] < this.Threshold) {
                                            wrr.setSample(j, i8, 0, 0);
                                        } else {
                                            wrr.setSample(j, i8, 0, 1);
                                        }
                                        ++j;
                                        ++pos;
                                    }
                                }
                                break;
                            }
                            case 0: {
                                if (Result.getRaster().getDataBuffer().getDataType() != 3) {
                                    throw new IllegalArgumentException("The resulting DataBuffer is not Int.");
                                }
                                int[] ibres = ((DataBufferInt)Result.getRaster().getDataBuffer()).getData();
                                for (int i9 = 0; i9 < ibres.length; ++i9) {
                                    ibres[i9] = (double)dataint[i9] < this.Threshold ? 0 : Integer.MAX_VALUE;
                                }
                                ibres = null;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("The resulting image is neither BYTE_BINARY nor CUSTOM.");
                            }
                        }
                        dataint = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        wrr = null;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Empty method, not implemented (yet)");
    }

    public double[][] Filter(double[][] Original, double Threshold, int nbCPU) {
        this.setThreshold(Threshold);
        return this.Filter(Original, nbCPU);
    }

    public void Filter(double[][] Original, double Threshold, double[][] Result, int nbCPU) {
        this.setThreshold(Threshold);
        this.Filter(Original, Result, nbCPU);
    }

    public double[][] Filter(double[][] Original, int nbCPU) {
        double[][] Result = ArrayNew.Same((double[][])Original);
        this.Filter(Original, Result, nbCPU);
        return Result;
    }

    public void Filter(double[][] Original, double[][] Result, int nbCPU) {
        if (!ArrayTools.areDimensionsEqual((double[][])Original, (double[][])Result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = Original[0].length;
        int height = Original.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Result[y][x] = Original[y][x] < this.Threshold ? 0.0 : 1.0;
            }
        }
    }

    public void setThreshold(int Threshold) {
        this.setThreshold(Threshold, Threshold, Threshold, Threshold);
    }

    public void setThreshold(int ThresholdR, int ThresholdG, int ThresholdB) {
        if (ThresholdR < 0) {
            throw new IllegalArgumentException("Illegal Threshold value: " + ThresholdR);
        }
        if (ThresholdG < 0) {
            throw new IllegalArgumentException("Illegal Threshold value: " + ThresholdG);
        }
        if (ThresholdB < 0) {
            throw new IllegalArgumentException("Illegal Threshold value: " + ThresholdB);
        }
        this.ThresholdR = ThresholdR;
        this.ThresholdG = ThresholdG;
        this.ThresholdB = ThresholdB;
    }

    public void setThreshold(int ThresholdR, int ThresholdG, int ThresholdB, int ThresholdA) {
        if (ThresholdA < 0) {
            throw new IllegalArgumentException("Illegal Threshold value: " + ThresholdA);
        }
        this.ThresholdA = ThresholdA;
        this.setThreshold(ThresholdR, ThresholdG, ThresholdB);
    }

    public void setThreshold(double Threshold) {
        this.Threshold = Threshold;
    }

    public double getThreshold() {
        return this.Threshold;
    }

    public int getThresholdRed() {
        return this.ThresholdR;
    }

    public int getThresholdGreen() {
        return this.ThresholdG;
    }

    public int getThresholdBlue() {
        return this.ThresholdB;
    }

    public int getThresholdAlpha() {
        return this.ThresholdA;
    }

    public void Parameters(Object ... parameters) {
        switch (parameters.length) {
            case 1: {
                this.ThresholdG = this.ThresholdB = ((Integer)parameters[0]).intValue();
                this.ThresholdR = this.ThresholdB;
                break;
            }
            case 4: {
                this.ThresholdA = (Integer)parameters[3];
            }
            case 3: {
                this.ThresholdR = (Integer)parameters[0];
                this.ThresholdG = (Integer)parameters[1];
                this.ThresholdB = (Integer)parameters[2];
                break;
            }
            default: {
                throw new IllegalArgumentException("1, 3 or 4 parameter(s) required.");
            }
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(4);
        params.add(this.ThresholdR);
        params.add(this.ThresholdG);
        params.add(this.ThresholdB);
        params.add(this.ThresholdA);
        return params;
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public ImageThresholder Clone() {
        return new Binary(this.ThresholdR, this.ThresholdG, this.ThresholdB, this.ThresholdA);
    }

    @Override
    public int[] getThresholds() {
        return new int[]{this.ThresholdR, this.ThresholdG, this.ThresholdB, this.ThresholdA};
    }

    @Override
    public int getThreshold(int channel) {
        switch (channel) {
            case 0: {
                return this.ThresholdR;
            }
            case 1: {
                return this.ThresholdG;
            }
            case 2: {
                return this.ThresholdB;
            }
            case 3: {
                return this.ThresholdA;
            }
        }
        throw new IllegalArgumentException("Channel not supported.");
    }
}

