/*
 * Decompiled with CFR 0.152.
 */
package processing.reducer;

import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import processing.filters.DynamicExpansion;
import processing.reducer.ColorReducer;
import processing.reducer.LinearGLR;

public class MinMaxLinearGLR
implements ColorReducer {
    private DynamicExpansion dynexp = new DynamicExpansion();
    private LinearGLR glr = new LinearGLR();

    @Override
    public BufferedImage Reduce(BufferedImage source, int nbGrayLevel, int ForbiddenValue) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Reduce(source, result, nbGrayLevel, ForbiddenValue);
        return result;
    }

    @Override
    public void Reduce(BufferedImage source, BufferedImage result, int nbGrayLevel, int ForbiddenValue) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images have different type or dimensions.");
        }
        switch (source.getType()) {
            case 10: {
                this.dynexp.Filter(source, 0, 255, result, 1);
                break;
            }
            case 11: {
                this.dynexp.Filter(source, 0, 65535, result, 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Images type not supported.");
            }
        }
        if (0 <= ForbiddenValue) {
            ForbiddenValue = (int)(this.dynexp.A() * (double)ForbiddenValue + this.dynexp.B());
        }
        this.glr.Reduce(result, result, nbGrayLevel, ForbiddenValue);
    }

    @Override
    public DV Reduce(DV source, int nbGrayLevel, int ForbiddenValue) {
        DV result = DvNew.Same((DV)source);
        this.Reduce(source, result, nbGrayLevel, ForbiddenValue);
        return result;
    }

    @Override
    public void Reduce(DV source, DV result, int nbGrayLevel, int ForbiddenValue) {
        if (!DvTools.areDimensionsAndTypeEqual((DV)source, (DV)result)) {
            throw new IllegalArgumentException("Images have different type or dimensions.");
        }
        if (source.Channel != 1) {
            throw new IllegalArgumentException("Only 1 channel required");
        }
        switch (source.Type) {
            case 8: {
                this.dynexp.Filter(source, result, 0, 0, 255, 1);
                break;
            }
            case 16: {
                this.dynexp.Filter(source, result, 0, 0, 65535, 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Images type not supported.");
            }
        }
        if (0 <= ForbiddenValue) {
            ForbiddenValue = (int)(this.dynexp.A() * (double)ForbiddenValue + this.dynexp.B());
        }
        this.glr.Reduce(result, result, nbGrayLevel, ForbiddenValue);
    }

    @Override
    public int Bins() {
        return this.glr.Bins();
    }

    @Override
    public String ID() {
        return this.getClass().getSimpleName() + "_" + this.Bins();
    }
}

