/*
 * Decompiled with CFR 0.152.
 */
package processing.reducer;

import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import mathematics.Maths;
import processing.reducer.ColorReducer;

public class LinearGLR
implements ColorReducer {
    private int nbGrayLevel = -1;

    public LinearGLR() {
    }

    public LinearGLR(int nbGrayLevel) {
        this.nbGrayLevel = nbGrayLevel;
    }

    @Override
    public BufferedImage Reduce(BufferedImage source, int nbGrayLevel, int ForbiddenValue) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Reduce(source, result, nbGrayLevel, ForbiddenValue);
        return result;
    }

    @Override
    public void Reduce(BufferedImage source, BufferedImage result, int nbGrayLevel, int ForbiddenValue) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images have different type or dimensions.");
        }
        this.nbGrayLevel = nbGrayLevel;
        int pow = Maths.isDyadic((int)nbGrayLevel);
        block0 : switch (source.getType()) {
            case 5: 
            case 6: 
            case 10: {
                byte[] bytebufferin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] bytebufferout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                if (0 <= pow) {
                    pow = 8 - pow;
                    for (int x = 0; x < bytebufferin.length; ++x) {
                        int v = bytebufferin[x] & 0xFF;
                        bytebufferout[x] = v == ForbiddenValue ? (byte)0 : (byte)((v >> pow) + 1);
                    }
                } else {
                    double ratio = (double)nbGrayLevel / 256.0;
                    for (int x = 0; x < bytebufferin.length; ++x) {
                        int v = bytebufferin[x] & 0xFF;
                        bytebufferout[x] = v == ForbiddenValue ? (byte)0 : (byte)((double)v * ratio + 1.0);
                    }
                }
                bytebufferout = null;
                bytebufferin = null;
                break;
            }
            case 11: {
                short[] shortbufferin = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] shortbufferout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                if (0 <= pow) {
                    pow = 16 - pow;
                    for (int x = 0; x < shortbufferin.length; ++x) {
                        int v = shortbufferin[x] & 0xFFFF;
                        shortbufferout[x] = v == ForbiddenValue ? (short)0 : (short)((v >> pow) + 1);
                    }
                } else {
                    double ratio = (double)nbGrayLevel / 65536.0;
                    for (int x = 0; x < shortbufferin.length; ++x) {
                        int v = shortbufferin[x] & 0xFFFF;
                        shortbufferout[x] = v == ForbiddenValue ? (short)0 : (short)((double)v * ratio + 1.0);
                    }
                }
                shortbufferout = null;
                shortbufferin = null;
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        double ratio = (double)nbGrayLevel / -2.147483648E9;
                        int[] intbufferin = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                        int[] intbufferout = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
                        for (int x = 0; x < intbufferin.length; ++x) {
                            int v = intbufferin[x];
                            intbufferout[x] = v == ForbiddenValue ? 0 : (int)((double)v * ratio + 1.0);
                        }
                        intbufferout = null;
                        intbufferin = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not (yet) supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    @Override
    public DV Reduce(DV source, int nbGrayLevel, int ForbiddenValue) {
        DV result = DvNew.Same((DV)source);
        this.Reduce(source, result, nbGrayLevel, ForbiddenValue);
        return result;
    }

    @Override
    public void Reduce(DV source, DV result, int nbGrayLevel, int ForbiddenValue) {
        if (!DvTools.areDimensionsAndTypeEqual((DV)source, (DV)result)) {
            throw new IllegalArgumentException("Images have different type or dimensions.");
        }
        if (source.Channel != 1) {
            throw new IllegalArgumentException("Only 1 channel required");
        }
        this.nbGrayLevel = nbGrayLevel;
        int pow = Maths.isDyadic((int)nbGrayLevel);
        switch (source.Type) {
            case 8: {
                byte[] bytebufferin = source.getDataBufferByte(0);
                byte[] bytebufferout = result.getDataBufferByte(0);
                if (0 <= pow) {
                    pow = 8 - pow;
                    for (int x = 0; x < bytebufferin.length; ++x) {
                        int v = bytebufferin[x] & 0xFF;
                        bytebufferout[x] = v == ForbiddenValue ? (byte)0 : (byte)((v >> pow) + 1);
                    }
                } else {
                    double ratio = (double)nbGrayLevel / 256.0;
                    for (int x = 0; x < bytebufferin.length; ++x) {
                        int v = bytebufferin[x] & 0xFF;
                        bytebufferout[x] = v == ForbiddenValue ? (byte)0 : (byte)((double)v * ratio + 1.0);
                    }
                }
                bytebufferout = null;
                bytebufferin = null;
                break;
            }
            case 16: {
                short[] shortbufferin = source.getDataBufferShort(0);
                short[] shortbufferout = result.getDataBufferShort(0);
                if (0 <= pow) {
                    pow = 16 - pow;
                    for (int x = 0; x < shortbufferin.length; ++x) {
                        int v = shortbufferin[x] & 0xFFFF;
                        shortbufferout[x] = v == ForbiddenValue ? (short)0 : (short)((v >> pow) + 1);
                    }
                } else {
                    double ratio = (double)nbGrayLevel / 65536.0;
                    for (int x = 0; x < shortbufferin.length; ++x) {
                        int v = shortbufferin[x] & 0xFFFF;
                        shortbufferout[x] = v == ForbiddenValue ? (short)0 : (short)((double)v * ratio + 1.0);
                    }
                }
                shortbufferout = null;
                shortbufferin = null;
                break;
            }
            case 32: {
                double ratio = (double)nbGrayLevel / -2.147483648E9;
                int[] intbufferin = source.getDataBufferInt(0);
                int[] intbufferout = result.getDataBufferInt(0);
                for (int x = 0; x < intbufferin.length; ++x) {
                    int v = intbufferin[x];
                    intbufferout[x] = v == ForbiddenValue ? 0 : (int)((double)v * ratio + 1.0);
                }
                intbufferout = null;
                intbufferin = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
    }

    @Override
    public int Bins() {
        return this.nbGrayLevel;
    }

    @Override
    public String ID() {
        return this.getClass().getSimpleName() + "_" + this.Bins();
    }
}

