/*
 * Decompiled with CFR 0.152.
 */
package processing.reducer;

import dataMining.clustering.Cluster;
import dataMining.clustering.KMeans;
import dv.DV;
import dv.DvNew;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import processing.reducer.ColorReducer;
import utils.sorts.QuickSort;

public class KMeansGLR
implements ColorReducer {
    private KMeans kmeans = new KMeans((Metric)new Euclidian());
    private int nbGrayLevel = -1;

    @Override
    public BufferedImage Reduce(BufferedImage source, int nbGrayLevel, int ForbiddenValue) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Reduce(source, result, nbGrayLevel, ForbiddenValue);
        return result;
    }

    @Override
    public void Reduce(BufferedImage source, BufferedImage result, int nbGrayLevel, int ForbiddenValue) {
        if (source.getType() != 10) {
            throw new IllegalArgumentException("TYPE_BYTE_GRAY image required.");
        }
        this.nbGrayLevel = nbGrayLevel;
        int width = source.getWidth();
        int height = source.getHeight();
        int[] EquivalentNdg = null;
        WritableRaster wr = source.getRaster();
        WritableRaster wrres = result.getRaster();
        EquivalentNdg = this.FindClusters(source, nbGrayLevel);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (wr.getSample(x, y, 0) == ForbiddenValue) {
                    wrres.setSample(x, y, 0, 0);
                    continue;
                }
                wrres.setSample(x, y, 0, EquivalentNdg[wr.getSample(x, y, 0)] + 1);
            }
        }
    }

    @Override
    public DV Reduce(DV source, int nbGrayLevel, int ForbiddenValue) {
        DV result = DvNew.Same((DV)source);
        this.Reduce(source, result, nbGrayLevel, ForbiddenValue);
        return result;
    }

    @Override
    public void Reduce(DV source, DV result, int nbGrayLevel, int ForbiddenValue) {
        throw new Error("Method not implemented (yet).");
    }

    private int[] FindClusters(BufferedImage image, int nbGrayLevel) {
        int x;
        int largeur = image.getWidth();
        int hauteur = image.getHeight();
        int Taille = largeur * hauteur;
        double[][] Tableau = new double[Taille][1];
        int[] EquivalentNdg = new int[256];
        WritableRaster wr = image.getRaster();
        int nb = 0;
        for (int y = 0; y < hauteur; ++y) {
            for (x = 0; x < largeur; ++x) {
                Tableau[nb++][0] = wr.getSample(x, y, 0);
            }
        }
        this.kmeans.Compute(Tableau, nbGrayLevel, 0.5, true, false, null);
        int[] Clusters = new int[nbGrayLevel];
        double[] BaryClusters = new double[nbGrayLevel];
        for (x = 0; x < nbGrayLevel; ++x) {
            Clusters[x] = x;
        }
        Cluster[] clust = this.kmeans.getClusters();
        for (x = 0; x < nbGrayLevel; ++x) {
            BaryClusters[x] = clust[x].getBarycenter().get(0);
        }
        QuickSort.Sort(BaryClusters, Clusters, 0, nbGrayLevel - 1);
        Arrays.fill(EquivalentNdg, -1);
        int[] ClusterResultat = this.kmeans.getClustersNumbers();
        for (x = 0; x < Taille; ++x) {
            EquivalentNdg[(int)Tableau[x][0]] = ClusterResultat[x];
        }
        int[] NewClusters = new int[256];
        for (x = 0; x < 256; ++x) {
            NewClusters[x] = -1;
        }
        for (x = 0; x < nbGrayLevel; ++x) {
            NewClusters[Clusters[x]] = x;
        }
        for (x = 0; x < 256; ++x) {
            if (EquivalentNdg[x] < 0) continue;
            EquivalentNdg[x] = NewClusters[EquivalentNdg[x]];
        }
        Tableau = null;
        Clusters = null;
        BaryClusters = null;
        clust = null;
        ClusterResultat = null;
        NewClusters = null;
        return EquivalentNdg;
    }

    @Override
    public int Bins() {
        return this.nbGrayLevel;
    }

    @Override
    public String ID() {
        return this.getClass().getSimpleName() + "_" + this.Bins();
    }
}

