/*
 * Decompiled with CFR 0.152.
 */
package processing.reducer;

import dv.DV;
import dv.DvFeatures;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.Arrays;
import measures.histogram.Histogram;
import processing.reducer.ColorReducer;

public class HistogramGLR
implements ColorReducer {
    private final Histogram histogram = new Histogram();
    private int[] Lut = null;
    private int nbGrayLevel = -1;
    private final DvFeatures DF = new DvFeatures();
    private final ImageFeatures IF = new ImageFeatures();

    @Override
    public BufferedImage Reduce(BufferedImage source, int nbGrayLevel, int ForbiddenValue) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Reduce(source, result, nbGrayLevel, ForbiddenValue);
        return result;
    }

    @Override
    public void Reduce(BufferedImage source, BufferedImage result, int nbGrayLevel, int ForbiddenValue) {
        if (!ImageTools.isGrayLevel((BufferedImage)source)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions and types.");
        }
        this.nbGrayLevel = nbGrayLevel;
        this.histogram.Fill(source);
        int[] Values2 = this.histogram.getValues(0);
        int MaxGray = source.getType() == 10 ? 256 : 65636;
        int Seuil = (int)this.IF.Counter(source, 0, ForbiddenValue) / nbGrayLevel;
        if (this.Lut == null || this.Lut.length != MaxGray) {
            this.Lut = new int[MaxGray];
        } else {
            Arrays.fill(this.Lut, 0);
        }
        int sum = 0;
        int nb = 1;
        for (int x = 0; x < MaxGray; ++x) {
            if (x != ForbiddenValue) {
                this.Lut[x] = nb;
                if ((sum += Values2[x]) < Seuil) continue;
                if (nb < nbGrayLevel) {
                    ++nb;
                }
                sum = 0;
                continue;
            }
            this.Lut[x] = 0;
        }
        switch (source.getType()) {
            case 10: {
                byte[] bbin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] bbout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bbin.length; ++x) {
                    bbout[x] = (byte)this.Lut[bbin[x] & 0xFF];
                }
                bbout = null;
                bbin = null;
                break;
            }
            case 11: {
                short[] sbin = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] sbout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < sbin.length; ++x) {
                    sbout[x] = (short)this.Lut[sbin[x] & 0xFFFF];
                }
                sbout = null;
                sbin = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        Values2 = null;
    }

    @Override
    public DV Reduce(DV source, int nbGrayLevel, int ForbiddenValue) {
        DV result = DvNew.Same((DV)source);
        this.Reduce(source, result, nbGrayLevel, ForbiddenValue);
        return result;
    }

    @Override
    public void Reduce(DV source, DV result, int nbGrayLevel, int ForbiddenValue) {
        int MaxGray;
        if (!DvTools.areDimensionsAndTypeEqual((DV)source, (DV)result)) {
            throw new IllegalArgumentException("DVs source and result must have equal dimensions and types.");
        }
        if (source.Channel != 1) {
            throw new IllegalArgumentException("Only 1 channel required");
        }
        this.nbGrayLevel = nbGrayLevel;
        this.histogram.Fill(source);
        int[] Values2 = this.histogram.getValues(0);
        switch (source.Type) {
            case 8: {
                MaxGray = 256;
                break;
            }
            case 16: {
                MaxGray = 65636;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        int Seuil = this.DF.Counter(source, 0, ForbiddenValue) / nbGrayLevel;
        if (this.Lut == null || this.Lut.length != MaxGray) {
            this.Lut = new int[MaxGray];
        } else {
            Arrays.fill(this.Lut, 0);
        }
        int sum = 0;
        int nb = 1;
        for (int x = 0; x < MaxGray; ++x) {
            if (x != ForbiddenValue) {
                this.Lut[x] = nb;
                if ((sum += Values2[x]) < Seuil) continue;
                if (nb < nbGrayLevel) {
                    ++nb;
                }
                sum = 0;
                continue;
            }
            this.Lut[x] = 0;
        }
        switch (source.Type) {
            case 8: {
                byte[] bbin = source.getDataBufferByte(0);
                byte[] bbout = result.getDataBufferByte(0);
                for (int x = 0; x < bbin.length; ++x) {
                    bbout[x] = (byte)this.Lut[bbin[x] & 0xFF];
                }
                bbout = null;
                bbin = null;
                break;
            }
            case 16: {
                short[] sbin = source.getDataBufferShort(0);
                short[] sbout = result.getDataBufferShort(0);
                for (int x = 0; x < sbin.length; ++x) {
                    sbout[x] = (short)this.Lut[sbin[x] & 0xFFFF];
                }
                sbout = null;
                sbin = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        Values2 = null;
    }

    @Override
    public int Bins() {
        return this.nbGrayLevel;
    }

    @Override
    public String ID() {
        return this.getClass().getSimpleName() + "_" + this.Bins();
    }
}

