/*
 * Decompiled with CFR 0.152.
 */
package processing.reducer;

import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayTools;
import characterization.textures.statisticalmatrices.FuzzyZone;
import characterization.textures.statisticalmatrices.FuzzyZone3D;
import characterization.textures.statisticalmatrices.FuzzyZone3DComparator;
import characterization.textures.statisticalmatrices.FuzzyZoneComparator;
import dv.DV;
import dv.DvNew;
import imageTiTi.ImageConverter;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import listTiTi.ListOperations;
import listTiTi.Queue;
import mathematics.functions.AbsConcave;
import mathematics.functions.AbsConvex;
import mathematics.functions.Function1D;
import mathematics.functions.LinearFunction;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import processing.reducer.ColorReducer;
import utils.memory.MemoryInfo;

public class FuzzyGLR
implements ColorReducer {
    public static final int FV = -1;
    private final int ToProcess = 0;
    private FuzzyGLRthread[] threads = null;
    private FuzzyGLR_3Dbyte_Thread[] threads3dbyte = null;
    private int nbFreeThreads = 0;
    private int fuzzy = -1;
    private int neighborhood = 4;
    private List<FuzzyZone> finallist = null;
    private List<FuzzyZone> listmp = null;
    private List<FuzzyZone3D> finallist3d = null;
    private List<FuzzyZone3D> listmp3d = null;
    private FuzzyZoneComparator comparator = null;
    private FuzzyZone3DComparator comparator3d = null;
    private int[] processmap = null;
    private double[] probabilities = null;
    private double probability = -1.0;
    private int counter = -1;
    private ListOperations<FuzzyZone> listop = null;
    private ListOperations<FuzzyZone3D> listop3d = null;
    public boolean FullZoneComputation = false;
    public boolean AggressiveMemoryRelease = false;
    public boolean MemorySafety = false;
    private MemoryInfo meminfo = null;
    private final String fid;

    public FuzzyGLR(int fuzzy, int neighborhood, Function1D function) {
        this.fuzzy = fuzzy;
        switch (neighborhood) {
            case 4: 
            case 6: 
            case 8: 
            case 26: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Incorrect neighborhood value.");
            }
        }
        this.neighborhood = neighborhood;
        this.probabilities = new double[fuzzy + 1];
        for (int x = 0; x < this.probabilities.length; ++x) {
            this.probabilities[x] = function.Compute((double)x);
        }
        if (function.getClass() == LinearFunction.class) {
            this.fid = "LinearFunction_" + fuzzy;
        } else if (function.getClass() == AbsConvex.class) {
            this.fid = "AbsConvex_" + fuzzy + "_" + (int)function.Coefficient(0, (double[])null);
        } else if (function.getClass() == AbsConcave.class) {
            this.fid = "AbsConcave" + fuzzy + "_" + (int)function.Coefficient(0, (double[])null);
        } else {
            throw new IllegalArgumentException("Function not supported (yet).");
        }
    }

    @Override
    public BufferedImage Reduce(BufferedImage source, int ForbiddenValue, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Reduce(source, result, ForbiddenValue, nbCPU);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void Reduce(BufferedImage source, BufferedImage result, int ForbiddenValue, int nbCPU) {
        int i2;
        int width = source.getWidth();
        int height = source.getHeight();
        int length = width * height;
        if (this.processmap == null || this.processmap.length != length) {
            this.processmap = null;
            this.processmap = new int[length];
        }
        if (this.listop == null) {
            this.comparator = new FuzzyZoneComparator();
            this.finallist = new LinkedList<FuzzyZone>();
            this.listmp = new LinkedList<FuzzyZone>();
            this.listop = new ListOperations();
        }
        this.finallist.clear();
        if (this.AggressiveMemoryRelease && this.threads != null) {
            for (i2 = 0; i2 < this.threads.length; ++i2) {
                for (FuzzyZone fz : this.threads[i2].list) {
                    fz.Zone.flush();
                    fz.Zone = null;
                    fz = null;
                }
                this.threads[i2].list.clear();
            }
            System.runFinalization();
            System.gc();
        }
        this.counter = 1;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.KillThreads();
            this.threads = new FuzzyGLRthread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new FuzzyGLRthread();
                this.threads[i2].start();
            }
            FuzzyGLR iter = this;
            // MONITORENTER : iter
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            // MONITOREXIT : iter
        }
        int step = source.getHeight() / nbCPU;
        if (result == null) {
            Object bbin;
            this.nbFreeThreads = 0;
            switch (source.getType()) {
                case 10: {
                    bbin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                    ArrayComparator.CompareUnsigned((byte[])bbin, (String)"==", (int)ForbiddenValue, (int)-1, (int)0, (int[])this.processmap);
                    bbin = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Image type not supported (yet).");
                }
            }
            for (i2 = 0; i2 < nbCPU - 1; ++i2) {
                this.threads[i2].setConditions(source, this.processmap, i2 * step, (i2 + 1) * step);
                Object object = this.threads[i2].lock;
                bbin = object;
                // MONITORENTER : object
                this.threads[i2].lock.notify();
                // MONITOREXIT : bbin
            }
            this.threads[i2].setConditions(source, this.processmap, i2 * step, source.getHeight());
            Object object = this.threads[i2].lock;
            bbin = object;
            // MONITORENTER : object
            this.threads[i2].lock.notify();
            // MONITOREXIT : bbin
            FuzzyGLR fuzzyGLR = this;
            bbin = fuzzyGLR;
            // MONITORENTER : fuzzyGLR
        } else {
            if (this.MemorySafety && this.meminfo == null) {
                this.meminfo = new MemoryInfo();
            }
            int surface = 0;
            Queue<CoordinatesWeighted> queue = new Queue<CoordinatesWeighted>();
            Queue<CoordinatesWeighted> zone = new Queue<CoordinatesWeighted>();
            this.probability = 0.0;
            switch (source.getType()) {
                case 10: {
                    byte[] bbin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                    byte[] bbout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                    ArrayComparator.CompareUnsigned((byte[])bbin, (String)"==", (int)ForbiddenValue, (int)-1, (int)0, (int[])this.processmap);
                    do {
                        Object object;
                        this.nbFreeThreads = 0;
                        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
                            this.threads[i2].setConditions(source, this.processmap, i2 * step, (i2 + 1) * step);
                            object = this.threads[i2].lock;
                            // MONITORENTER : object
                            this.threads[i2].lock.notify();
                            // MONITOREXIT : object
                        }
                        this.threads[i2].setConditions(source, this.processmap, i2 * step, source.getHeight());
                        object = this.threads[i2].lock;
                        // MONITORENTER : object
                        this.threads[i2].lock.notify();
                        // MONITOREXIT : object
                        object = this;
                        // MONITORENTER : object
                        while (this.nbFreeThreads != nbCPU) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        // MONITOREXIT : object
                        if (this.MemorySafety && 83.0 < this.meminfo.Percentage()) {
                            System.gc();
                        }
                        this.listmp.clear();
                        for (i2 = 0; i2 < nbCPU; ++i2) {
                            this.listmp.addAll(this.threads[i2].list);
                        }
                        FuzzyZone[] fza = this.listmp.toArray(new FuzzyZone[this.listmp.size()]);
                        Arrays.sort(fza, this.comparator);
                        FuzzyGLRthread thread = this.threads[0];
                        System.arraycopy(this.processmap, 0, thread.processed, 0, this.processmap.length);
                        for (int x = 0; x < fza.length; ++x) {
                            FuzzyZone fz = fza[x];
                            if (thread.processed[fz.Pos] != 0) continue;
                            queue.Push(new CoordinatesWeighted(fz.X, fz.Y, 0, fz.Pos, fz.Color));
                            if (thread.Process(fz.X, fz.Y, fz.Color, bbin, width, height, queue, zone, this.counter) && zone.size() == fz.Size) {
                                this.finallist.add(fz);
                                this.probability += fz.Probability * (double)fz.Size;
                                surface += fz.Size;
                                while (!zone.isEmpty()) {
                                    bbout[zone.FrontPop().Pos] = (byte)fz.Color;
                                }
                                ++this.counter;
                                continue;
                            }
                            while (!zone.isEmpty()) {
                                thread.processed[zone.FrontPop().Pos] = 0;
                            }
                        }
                        System.arraycopy(thread.processed, 0, this.processmap, 0, this.processmap.length);
                    } while (ArrayTools.Contains((int[])this.processmap, (int)0));
                    this.probability /= (double)surface;
                    return;
                }
                case 5: 
                case 6: {
                    int channels = source.getRaster().getNumBands();
                    double proba = 0.0;
                    BufferedImage tmpgray = new BufferedImage(width, height, 10);
                    BufferedImage tmpres = ImageNew.Same((BufferedImage)tmpgray);
                    int c = 0;
                    while (true) {
                        if (c >= channels) {
                            this.probability /= (double)channels;
                            return;
                        }
                        ImageConverter.Channel((BufferedImage)source, (int)c, (BufferedImage)tmpgray);
                        byte[] cbin = ((DataBufferByte)tmpgray.getRaster().getDataBuffer()).getData();
                        byte[] cbout = ((DataBufferByte)tmpres.getRaster().getDataBuffer()).getData();
                        ArrayComparator.CompareUnsigned((byte[])cbin, (String)"==", (int)ForbiddenValue, (int)-1, (int)0, (int[])this.processmap);
                        do {
                            Object object;
                            this.nbFreeThreads = 0;
                            for (i2 = 0; i2 < nbCPU - 1; ++i2) {
                                this.threads[i2].setConditions(tmpgray, this.processmap, i2 * step, (i2 + 1) * step);
                                object = this.threads[i2].lock;
                                // MONITORENTER : object
                                this.threads[i2].lock.notify();
                                // MONITOREXIT : object
                            }
                            this.threads[i2].setConditions(tmpgray, this.processmap, i2 * step, tmpgray.getHeight());
                            object = this.threads[i2].lock;
                            // MONITORENTER : object
                            this.threads[i2].lock.notify();
                            // MONITOREXIT : object
                            object = this;
                            // MONITORENTER : object
                            while (this.nbFreeThreads != nbCPU) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            // MONITOREXIT : object
                            if (this.MemorySafety && 90.0 < this.meminfo.Percentage()) {
                                System.gc();
                            }
                            this.listmp.clear();
                            for (i2 = 0; i2 < nbCPU; ++i2) {
                                this.listmp.addAll(this.threads[i2].list);
                            }
                            FuzzyZone[] fza = this.listmp.toArray(new FuzzyZone[this.listmp.size()]);
                            Arrays.sort(fza, this.comparator);
                            FuzzyGLRthread thread = this.threads[0];
                            System.arraycopy(this.processmap, 0, thread.processed, 0, this.processmap.length);
                            for (int x = 0; x < fza.length; ++x) {
                                FuzzyZone fz = fza[x];
                                if (thread.processed[fz.Pos] != 0) continue;
                                queue.Push(new CoordinatesWeighted(fz.X, fz.Y, 0, fz.Pos, fz.Color));
                                if (thread.Process(fz.X, fz.Y, fz.Color, cbin, width, height, queue, zone, this.counter) && zone.size() == fz.Size) {
                                    this.finallist.add(fz);
                                    proba += fz.Probability * (double)fz.Size;
                                    surface += fz.Size;
                                    while (!zone.isEmpty()) {
                                        cbout[zone.FrontPop().Pos] = (byte)fz.Color;
                                    }
                                    ++this.counter;
                                    continue;
                                }
                                while (!zone.isEmpty()) {
                                    thread.processed[zone.FrontPop().Pos] = 0;
                                }
                            }
                            System.arraycopy(thread.processed, 0, this.processmap, 0, this.processmap.length);
                        } while (ArrayTools.Contains((int[])this.processmap, (int)0));
                        Object bbout = null;
                        Object bbin = null;
                        this.probability += proba / (double)surface;
                        ImageNew.Copy((BufferedImage)tmpres, (BufferedImage)result, (int)c);
                        ++c;
                    }
                }
            }
            throw new IllegalArgumentException("Image type not supported (yet).");
        }
        while (this.nbFreeThreads != nbCPU) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        // MONITOREXIT : bbin
        i2 = 0;
        while (true) {
            if (i2 >= nbCPU) {
                this.probability = -1.0;
                return;
            }
            this.finallist.addAll(this.threads[i2].list);
            ++i2;
        }
    }

    @Override
    public DV Reduce(DV source, int ForbiddenValue, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Reduce(source, result, ForbiddenValue, nbCPU);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Reduce(DV source, DV result, int ForbiddenValue, int nbCPU) {
        int i2;
        int width = source.SizeX;
        int height = source.SizeY;
        int depth = source.SizeZ;
        int length = source.Length;
        if (source.Channel != 1) {
            throw new IllegalArgumentException("Only 1 channel required");
        }
        if (this.processmap == null || this.processmap.length != length) {
            this.processmap = null;
            this.processmap = new int[length];
        }
        if (this.listop3d == null) {
            this.comparator3d = new FuzzyZone3DComparator();
            this.finallist3d = new LinkedList<FuzzyZone3D>();
            this.listmp3d = new LinkedList<FuzzyZone3D>();
            this.listop3d = new ListOperations();
        }
        this.finallist3d.clear();
        if (this.AggressiveMemoryRelease && this.threads3dbyte != null) {
            for (i2 = 0; i2 < this.threads3dbyte.length; ++i2) {
                for (FuzzyZone3D fz : this.threads3dbyte[i2].list) {
                    fz.Zone.Kill();
                    fz.Zone = null;
                    fz = null;
                }
                this.threads3dbyte[i2].list.clear();
                this.threads3dbyte[i2].processed = null;
                this.threads3dbyte[i2].source = null;
            }
            System.runFinalization();
            System.gc();
        }
        this.counter = 1;
        if (this.threads3dbyte == null || this.threads3dbyte.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.KillThreads();
            this.threads3dbyte = new FuzzyGLR_3Dbyte_Thread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads3dbyte[i2] = new FuzzyGLR_3Dbyte_Thread();
                this.threads3dbyte[i2].start();
            }
            FuzzyGLR iter = this;
            synchronized (iter) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        int step = depth / nbCPU;
        if (result == null) {
            Object bbin;
            this.nbFreeThreads = 0;
            switch (source.Type) {
                case 8: {
                    Object object;
                    bbin = source.getDataBufferByte(0);
                    ArrayComparator.CompareUnsigned((byte[])bbin, (String)"==", (int)ForbiddenValue, (int)-1, (int)0, (int[])this.processmap);
                    for (i2 = 0; i2 < nbCPU - 1; ++i2) {
                        this.threads3dbyte[i2].setConditions((byte[])bbin, width, height, depth, this.processmap, i2 * step, (i2 + 1) * step);
                        object = this.threads3dbyte[i2].lock;
                        synchronized (object) {
                            this.threads3dbyte[i2].lock.notify();
                            continue;
                        }
                    }
                    this.threads3dbyte[i2].setConditions((byte[])bbin, width, height, depth, this.processmap, i2 * step, depth);
                    object = this.threads3dbyte[i2].lock;
                    synchronized (object) {
                        this.threads3dbyte[i2].lock.notify();
                    }
                    bbin = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DV type not supported (yet).");
                }
            }
            FuzzyGLR fuzzyGLR = this;
            bbin = fuzzyGLR;
            synchronized (fuzzyGLR) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                // ** MonitorExit[bbin /* !! */ ] (shouldn't be in output)
                switch (source.Type) {
                    case 8: {
                        for (i2 = 0; i2 < nbCPU; ++i2) {
                            this.finallist3d.addAll(this.threads3dbyte[i2].list);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("DV type not supported (yet).");
                    }
                }
                this.probability = -1.0;
                return;
            }
        }
        if (this.MemorySafety && this.meminfo == null) {
            this.meminfo = new MemoryInfo();
        }
        int surface = 0;
        Queue<CoordinatesWeighted> queue = new Queue<CoordinatesWeighted>();
        Queue<CoordinatesWeighted> zone = new Queue<CoordinatesWeighted>();
        this.probability = 0.0;
        switch (source.Type) {
            case 8: {
                byte[] bbin = source.getDataBufferByte(0);
                byte[] bbout = result.getDataBufferByte(0);
                ArrayComparator.CompareUnsigned((byte[])bbin, (String)"==", (int)ForbiddenValue, (int)-1, (int)0, (int[])this.processmap);
                do {
                    Object object;
                    this.nbFreeThreads = 0;
                    for (i2 = 0; i2 < nbCPU - 1; ++i2) {
                        this.threads3dbyte[i2].setConditions(source.getDataBufferByte(0), width, height, depth, this.processmap, i2 * step, (i2 + 1) * step);
                        object = this.threads3dbyte[i2].lock;
                        synchronized (object) {
                            this.threads3dbyte[i2].lock.notify();
                            continue;
                        }
                    }
                    this.threads3dbyte[i2].setConditions(source.getDataBufferByte(0), width, height, depth, this.processmap, i2 * step, depth);
                    object = this.threads3dbyte[i2].lock;
                    synchronized (object) {
                        this.threads3dbyte[i2].lock.notify();
                    }
                    object = this;
                    synchronized (object) {
                        while (this.nbFreeThreads != nbCPU) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (this.MemorySafety && 83.0 < this.meminfo.Percentage()) {
                        System.gc();
                    }
                    this.listmp3d.clear();
                    for (i2 = 0; i2 < nbCPU; ++i2) {
                        this.listmp3d.addAll(this.threads3dbyte[i2].list);
                    }
                    FuzzyZone3D[] fza = this.listmp3d.toArray(new FuzzyZone3D[this.listmp3d.size()]);
                    Arrays.sort(fza, this.comparator3d);
                    FuzzyGLR_3Dbyte_Thread thread = this.threads3dbyte[0];
                    System.arraycopy(this.processmap, 0, thread.processed, 0, this.processmap.length);
                    for (int x = 0; x < fza.length; ++x) {
                        FuzzyZone3D fz;
                        fz = fza[x];
                        if (thread.processed[fz.Pos] != 0) continue;
                        queue.Push(new CoordinatesWeighted(fz.X, fz.Y, fz.Z, fz.Pos, fz.Color));
                        if (thread.Process(fz.X, fz.Y, fz.Z, fz.Color, bbin, width, height, depth, queue, zone, this.counter) && zone.size() == fz.Size) {
                            this.finallist3d.add(fz);
                            this.probability += fz.Probability * (double)fz.Size;
                            surface += fz.Size;
                            while (!zone.isEmpty()) {
                                bbout[zone.FrontPop().Pos] = (byte)fz.Color;
                            }
                            ++this.counter;
                        } else {
                            while (!zone.isEmpty()) {
                                thread.processed[zone.FrontPop().Pos] = 0;
                            }
                        }
                        fz = null;
                    }
                    System.arraycopy(thread.processed, 0, this.processmap, 0, this.processmap.length);
                    fza = null;
                    thread = null;
                    this.listmp3d.clear();
                } while (ArrayTools.Contains((int[])this.processmap, (int)0));
                this.probability /= (double)surface;
                bbout = null;
                bbin = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public void ThreadsKiller() {
        this.KillThreads();
    }

    public void KillThreads() {
        int i2;
        if (this.threads == null && this.threads3dbyte == null) {
            return;
        }
        if (this.threads != null) {
            for (i2 = 0; i2 < this.threads.length; ++i2) {
                this.threads[i2].Kill();
                this.threads[i2] = null;
            }
        }
        if (this.threads3dbyte != null) {
            for (i2 = 0; i2 < this.threads3dbyte.length; ++i2) {
                this.threads3dbyte[i2].Kill();
                this.threads3dbyte[i2] = null;
            }
        }
        this.threads = null;
        this.threads3dbyte = null;
    }

    public void Kill() {
        this.KillThreads();
        if (this.finallist != null) {
            this.finallist.clear();
            this.listmp.clear();
            this.comparator = null;
            this.finallist = null;
            this.listmp = null;
            this.listop = null;
        }
        if (this.finallist3d != null) {
            this.finallist3d.clear();
            this.listmp3d.clear();
            this.comparator3d = null;
            this.finallist3d = null;
            this.listmp3d = null;
            this.listop3d = null;
        }
        this.processmap = null;
        this.probabilities = null;
    }

    public List<FuzzyZone> FuzzyZones() {
        return this.finallist;
    }

    public List<FuzzyZone3D> FuzzyZones3D() {
        return this.finallist3d;
    }

    public double Probability() {
        return this.probability;
    }

    public int[] Zones() {
        return this.processmap;
    }

    @Override
    public int Bins() {
        return this.fuzzy;
    }

    @Override
    public String ID() {
        return this.getClass().getSimpleName() + "_" + this.fid;
    }

    private class FuzzyGLR_3Dbyte_Thread
    extends Thread {
        public int[] processed = null;
        public List<FuzzyZone3D> list = new LinkedList<FuzzyZone3D>();
        public byte[] source;
        private int width;
        private int height;
        private int depth;
        private int layerlength;
        private int wm1;
        private int wp1;
        public double probability = -1.0;
        public int volume = 0;
        private int nbzones = -1;
        private int start;
        private int end;
        public boolean Suicide = false;
        public Object lock = new Object();
        private boolean Kill = false;

        private FuzzyGLR_3Dbyte_Thread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.processed = null;
            this.list.clear();
            this.list = null;
            this.source = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(byte[] source, int width, int height, int depth, int[] processed, int start, int end) {
            this.source = source;
            if (this.processed == null || this.processed.length != processed.length) {
                this.processed = null;
                if (FuzzyGLR.this.AggressiveMemoryRelease) {
                    System.gc();
                }
                this.processed = Arrays.copyOf(processed, processed.length);
            } else {
                System.arraycopy(processed, 0, this.processed, 0, processed.length);
            }
            this.start = start;
            this.end = end;
            this.width = width;
            this.wm1 = width - 1;
            this.wp1 = width + 1;
            this.height = height;
            this.depth = depth;
            this.layerlength = width * height;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Queue<CoordinatesWeighted> queue = new Queue<CoordinatesWeighted>();
            Queue<CoordinatesWeighted> zone = new Queue<CoordinatesWeighted>();
            CoordinatesWeighted coord = null;
            DV fz = null;
            while (true) {
                int z;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        FuzzyGLR.this.addFreeThread();
                        this.lock.wait();
                        if (this.Suicide) {
                            this.list.clear();
                            this.list = null;
                            this.processed = null;
                            queue = null;
                            zone = null;
                            this.interrupt();
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                queue.Clear();
                zone.Clear();
                this.list.clear();
                int pos = z * this.layerlength;
                for (z = this.start; z < this.end; ++z) {
                    for (int y = 0; y < this.height; ++y) {
                        int x = 0;
                        while (x < this.width) {
                            int val = this.source[pos] & 0xFF;
                            if (!(this.processed[pos] != 0 || 0 < x && val == (this.source[pos - 1] & 0xFF) || 0 < y && val == (this.source[pos - this.width] & 0xFF) || 0 < z && val == (this.source[pos - this.layerlength] & 0xFF) || FuzzyGLR.this.neighborhood != 6 && 0 < y && (0 < x && val == (this.source[pos - this.wp1] & 0xFF) || x < this.wm1 && val == (this.source[pos - this.wm1] & 0xFF)) || FuzzyGLR.this.neighborhood != 6 && 0 < z && (0 < y && (0 < x && val == (this.source[pos - this.layerlength - this.wp1] & 0xFF) || x < this.wm1 && val == (this.source[pos - this.layerlength - this.wm1] & 0xFF) || val == (this.source[pos - this.layerlength - this.width] & 0xFF)) || y < this.height - 1 && (0 < x && val == (this.source[pos - this.layerlength + this.wm1] & 0xFF) || val == (this.source[pos - this.layerlength + this.width] & 0xFF) || x < this.wm1 && val == (this.source[pos - this.layerlength + this.wp1] & 0xFF)) || 0 < x && val == (this.source[pos - this.layerlength - 1] & 0xFF) || x < this.wm1 && val == (this.source[pos - this.layerlength + 1] & 0xFF)))) {
                                queue.Push(new CoordinatesWeighted(x, y, z, pos, val));
                                if (this.Process(x, y, z, val, this.source, this.width, this.height, this.depth, queue, zone, FuzzyGLR.this.counter)) {
                                    this.volume = zone.Size();
                                    fz = FuzzyGLR.this.FullZoneComputation ? this.RebuildZone(zone, val, 8) : null;
                                    double proba = 0.0;
                                    while (!zone.isEmpty()) {
                                        coord = zone.FrontPop();
                                        proba += FuzzyGLR.this.probabilities[Math.abs(val - coord.Wi)];
                                        this.processed[coord.Pos] = 0;
                                        coord = null;
                                    }
                                    this.list.add(new FuzzyZone3D(x, y, z, pos, val, this.volume, proba / (double)this.volume, this.nbzones, fz));
                                } else {
                                    while (!zone.isEmpty()) {
                                        coord = zone.FrontPop();
                                        this.processed[coord.Pos] = 0;
                                        coord = null;
                                    }
                                }
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                this.source = null;
                queue.Clear();
                zone.Clear();
                fz = null;
                coord = null;
            }
        }

        public boolean Process(int x, int y, int z, int val, byte[] bbin, int width, int height, int depth, Queue<CoordinatesWeighted> queue, Queue<CoordinatesWeighted> zone, int counter) {
            CoordinatesWeighted coord = null;
            this.nbzones = 0;
            while (!queue.empty()) {
                coord = queue.FrontPop();
                if (this.processed[coord.Pos] != 0) continue;
                if (val == coord.Wi && (coord.Y < y || coord.Y == y && coord.X < x || coord.Z < z || coord.Z == z && (coord.Y < y || coord.X < x))) {
                    queue.clear();
                    return false;
                }
                if (val == coord.Wi) {
                    ++this.nbzones;
                }
                zone.Push(coord);
                this.processed[coord.Pos] = counter;
                int p = coord.Pos - 1;
                if (0 < coord.X && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                    queue.Push(new CoordinatesWeighted(coord.X - 1, coord.Y, coord.Z, p, bbin[p] & 0xFF));
                }
                p = coord.Pos - width;
                if (0 < coord.Y && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                    queue.Push(new CoordinatesWeighted(coord.X, coord.Y - 1, coord.Z, p, bbin[p] & 0xFF));
                }
                p = coord.Pos + 1;
                if (coord.X < this.wm1 && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                    queue.Push(new CoordinatesWeighted(coord.X + 1, coord.Y, coord.Z, p, bbin[p] & 0xFF));
                }
                p = coord.Pos + width;
                if (coord.Y < height - 1 && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                    queue.Push(new CoordinatesWeighted(coord.X, coord.Y + 1, coord.Z, p, bbin[p] & 0xFF));
                }
                p = coord.Pos - this.layerlength;
                if (0 < coord.Z && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                    queue.Push(new CoordinatesWeighted(coord.X, coord.Y, coord.Z - 1, p, bbin[p] & 0xFF));
                }
                p = coord.Pos + this.layerlength;
                if (coord.Z < depth - 1 && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                    queue.Push(new CoordinatesWeighted(coord.X, coord.Y, coord.Z + 1, p, bbin[p] & 0xFF));
                }
                if (FuzzyGLR.this.neighborhood != 6) {
                    p = coord.Pos - this.wp1;
                    if (0 < coord.X && 0 < coord.Y && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                        queue.Push(new CoordinatesWeighted(coord.X - 1, coord.Y - 1, coord.Z, p, bbin[p] & 0xFF));
                    }
                    p = coord.Pos - this.wm1;
                    if (coord.X < this.wm1 && 0 < coord.Y && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                        queue.Push(new CoordinatesWeighted(coord.X + 1, coord.Y - 1, coord.Z, p, bbin[p] & 0xFF));
                    }
                    p = coord.Pos + this.wm1;
                    if (0 < coord.X && coord.Y < height - 1 && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                        queue.Push(new CoordinatesWeighted(coord.X - 1, coord.Y + 1, coord.Z, p, bbin[p] & 0xFF));
                    }
                    p = coord.Pos + this.wp1;
                    if (coord.X < this.wm1 && coord.Y < height - 1 && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                        queue.Push(new CoordinatesWeighted(coord.X + 1, coord.Y + 1, coord.Z, p, bbin[p] & 0xFF));
                    }
                    p = coord.Pos - this.layerlength - this.wp1;
                    if (0 < coord.X && 0 < coord.Y && 0 < coord.Z && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                        queue.Push(new CoordinatesWeighted(coord.X - 1, coord.Y - 1, coord.Z - 1, p, bbin[p] & 0xFF));
                    }
                    p = coord.Pos - this.layerlength - width;
                    if (0 < coord.Y && 0 < coord.Z && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                        queue.Push(new CoordinatesWeighted(coord.X, coord.Y - 1, coord.Z - 1, p, bbin[p] & 0xFF));
                    }
                    p = coord.Pos - this.layerlength - this.wm1;
                    if (coord.X < this.wm1 && 0 < coord.Y && 0 < coord.Z && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                        queue.Push(new CoordinatesWeighted(coord.X + 1, coord.Y - 1, coord.Z - 1, p, bbin[p] & 0xFF));
                    }
                    p = coord.Pos - this.layerlength - 1;
                    if (0 < coord.X && 0 < coord.Z && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                        queue.Push(new CoordinatesWeighted(coord.X - 1, coord.Y, coord.Z - 1, p, bbin[p] & 0xFF));
                    }
                    p = coord.Pos - this.layerlength + 1;
                    if (coord.X < this.wm1 && 0 < coord.Z && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                        queue.Push(new CoordinatesWeighted(coord.X + 1, coord.Y, coord.Z - 1, p, bbin[p] & 0xFF));
                    }
                    p = coord.Pos - this.layerlength + this.wm1;
                    if (0 < coord.X && coord.Y < height - 1 && 0 < coord.Z && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                        queue.Push(new CoordinatesWeighted(coord.X - 1, coord.Y + 1, coord.Z - 1, p, bbin[p] & 0xFF));
                    }
                    p = coord.Pos - this.layerlength + width;
                    if (coord.Y < height - 1 && 0 < coord.Z && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                        queue.Push(new CoordinatesWeighted(coord.X, coord.Y + 1, coord.Z - 1, p, bbin[p] & 0xFF));
                    }
                    p = coord.Pos - this.layerlength + this.wp1;
                    if (coord.X < this.wm1 && coord.Y < height - 1 && 0 < coord.Z && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                        queue.Push(new CoordinatesWeighted(coord.X + 1, coord.Y + 1, coord.Z - 1, p, bbin[p] & 0xFF));
                    }
                }
                coord = null;
            }
            coord = null;
            return true;
        }

        private DV RebuildZone(Queue<CoordinatesWeighted> fz, int val, int type) {
            Iterator<CoordinatesWeighted> iter = fz.get().iterator();
            CoordinatesWeighted voxel = iter.next();
            int minx = voxel.X;
            int maxx = voxel.X;
            int miny = voxel.Y;
            int maxy = voxel.Y;
            int minz = voxel.Z;
            int maxz = voxel.Z;
            while (iter.hasNext()) {
                voxel = iter.next();
                if (voxel.X < minx) {
                    minx = voxel.X;
                }
                if (maxx < voxel.X) {
                    maxx = voxel.X;
                }
                if (voxel.Y < miny) {
                    miny = voxel.Y;
                }
                if (maxy < voxel.Y) {
                    maxy = voxel.Y;
                }
                if (voxel.Z < minz) {
                    minz = voxel.Z;
                }
                if (maxz < voxel.Z) {
                    maxz = voxel.Z;
                }
                voxel = null;
            }
            int sizex = maxx - minx + 3;
            int sizey = maxy - miny + 3;
            int sizez = maxz - minz + 3;
            DV result = new DV(sizex, sizey, sizez, 1, type);
            --minx;
            --miny;
            --minz;
            iter = fz.get().iterator();
            switch (type) {
                case 8: {
                    byte[] bb = result.getDataBufferByte(0);
                    while (iter.hasNext()) {
                        voxel = iter.next();
                        bb[voxel.X - minx + 1 + (voxel.Y - miny + 1) * sizex + (voxel.Z - minz + 1) * sizex * sizey] = (byte)val;
                        voxel = null;
                    }
                    bb = null;
                    break;
                }
                case 16: {
                    short[] sb = result.getDataBufferShort(0);
                    while (iter.hasNext()) {
                        voxel = iter.next();
                        sb[voxel.X - minx + 1 + (voxel.Y - miny + 1) * sizex + (voxel.Z - minz + 1) * sizex * sizey] = (short)val;
                        voxel = null;
                    }
                    sb = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DV type not supported (yet).");
                }
            }
            iter = null;
            voxel = null;
            return result;
        }
    }

    private class FuzzyGLRthread
    extends Thread {
        private int[] processed = null;
        public List<FuzzyZone> list = new LinkedList<FuzzyZone>();
        public List<FuzzyZone3D> list3d = new LinkedList<FuzzyZone3D>();
        private BufferedImage source;
        public double probability = -1.0;
        public int surface = 0;
        private int nbzones = -1;
        private int start;
        private int end;
        private int wm1;
        private int wp1;
        public boolean Suicide = false;
        public Object lock = new Object();
        private boolean Kill = false;

        private FuzzyGLRthread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.processed = null;
            this.list.clear();
            this.list = null;
            this.list3d.clear();
            this.list3d = null;
            this.source = null;
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void setConditions(BufferedImage source, int[] processed, int start, int end) {
            this.source = source;
            if (this.processed == null || this.processed.length != processed.length) {
                this.processed = null;
                if (FuzzyGLR.this.AggressiveMemoryRelease) {
                    System.gc();
                }
                this.processed = Arrays.copyOf(processed, processed.length);
            } else {
                System.arraycopy(processed, 0, this.processed, 0, processed.length);
            }
            this.start = start;
            this.end = end;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Queue<CoordinatesWeighted> queue = new Queue<CoordinatesWeighted>();
            Queue<CoordinatesWeighted> zone = new Queue<CoordinatesWeighted>();
            CoordinatesWeighted coord = null;
            BufferedImage fz = null;
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        FuzzyGLR.this.addFreeThread();
                        this.lock.wait();
                        if (this.Suicide) {
                            this.list.clear();
                            this.list = null;
                            this.processed = null;
                            this.interrupt();
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int width = this.source.getWidth();
                this.wm1 = width - 1;
                this.wp1 = width + 1;
                int height = this.source.getHeight();
                queue.Clear();
                zone.Clear();
                this.list.clear();
                switch (this.source.getType()) {
                    case 10: {
                        int y;
                        byte[] bytebufferin = ((DataBufferByte)this.source.getRaster().getDataBuffer()).getData();
                        int pos = y * width;
                        for (y = this.start; y < this.end; ++y) {
                            int x = 0;
                            while (x < width) {
                                int val = bytebufferin[pos] & 0xFF;
                                if (!(this.processed[pos] != 0 || 0 < x && val == (bytebufferin[pos - 1] & 0xFF) || 0 < y && val == (bytebufferin[pos - width] & 0xFF) || FuzzyGLR.this.neighborhood != 4 && 0 < y && (0 < x && val == (bytebufferin[pos - this.wp1] & 0xFF) || x < width - 1 && val == (bytebufferin[pos - this.wm1] & 0xFF)))) {
                                    queue.Push(new CoordinatesWeighted(x, y, 0, pos, val));
                                    if (this.Process(x, y, val, bytebufferin, width, height, queue, zone, FuzzyGLR.this.counter)) {
                                        this.surface = zone.Size();
                                        fz = FuzzyGLR.this.FullZoneComputation ? this.RebuildZone(zone, val, 10) : null;
                                        double proba = 0.0;
                                        while (!zone.isEmpty()) {
                                            coord = zone.FrontPop();
                                            proba += FuzzyGLR.this.probabilities[Math.abs(val - coord.Wi)];
                                            this.processed[coord.Pos] = 0;
                                        }
                                        this.list.add(new FuzzyZone(x, y, pos, val, this.surface, proba / (double)this.surface, this.nbzones, fz));
                                    } else {
                                        while (!zone.isEmpty()) {
                                            this.processed[zone.FrontPop().Pos] = 0;
                                        }
                                    }
                                }
                                ++x;
                                ++pos;
                            }
                        }
                        bytebufferin = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported (yet).");
                    }
                }
                this.source = null;
                queue.Clear();
                zone.Clear();
                fz = null;
                coord = null;
            }
        }

        public boolean Process(int x, int y, int val, byte[] bbin, int width, int height, Queue<CoordinatesWeighted> queue, Queue<CoordinatesWeighted> zone, int counter) {
            CoordinatesWeighted coord = null;
            this.nbzones = 0;
            while (!queue.empty()) {
                coord = queue.FrontPop();
                if (this.processed[coord.Pos] != 0) continue;
                if (val == coord.Wi && (coord.Y < y || coord.Y == y && coord.X < x)) {
                    queue.clear();
                    return false;
                }
                if (val == coord.Wi) {
                    ++this.nbzones;
                }
                zone.Push(coord);
                this.processed[coord.Pos] = counter;
                int p = coord.Pos - 1;
                if (0 < coord.X && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                    queue.Push(new CoordinatesWeighted(coord.X - 1, coord.Y, 0, p, bbin[p] & 0xFF));
                }
                p = coord.Pos - width;
                if (0 < coord.Y && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                    queue.Push(new CoordinatesWeighted(coord.X, coord.Y - 1, 0, p, bbin[p] & 0xFF));
                }
                p = coord.Pos + 1;
                if (coord.X < this.wm1 && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                    queue.Push(new CoordinatesWeighted(coord.X + 1, coord.Y, 0, p, bbin[p] & 0xFF));
                }
                p = coord.Pos + width;
                if (coord.Y < height - 1 && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                    queue.Push(new CoordinatesWeighted(coord.X, coord.Y + 1, 0, p, bbin[p] & 0xFF));
                }
                if (FuzzyGLR.this.neighborhood == 4) continue;
                p = coord.Pos - this.wp1;
                if (0 < coord.X && 0 < coord.Y && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                    queue.Push(new CoordinatesWeighted(coord.X - 1, coord.Y - 1, 0, p, bbin[p] & 0xFF));
                }
                p = coord.Pos - this.wm1;
                if (coord.X < this.wm1 && 0 < coord.Y && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                    queue.Push(new CoordinatesWeighted(coord.X + 1, coord.Y - 1, 0, p, bbin[p] & 0xFF));
                }
                p = coord.Pos + this.wm1;
                if (0 < coord.X && coord.Y < height - 1 && this.processed[p] == 0 && Math.abs((bbin[p] & 0xFF) - val) <= FuzzyGLR.this.fuzzy) {
                    queue.Push(new CoordinatesWeighted(coord.X - 1, coord.Y + 1, 0, p, bbin[p] & 0xFF));
                }
                p = coord.Pos + this.wp1;
                if (coord.X >= this.wm1 || coord.Y >= height - 1 || this.processed[p] != 0 || Math.abs((bbin[p] & 0xFF) - val) > FuzzyGLR.this.fuzzy) continue;
                queue.Push(new CoordinatesWeighted(coord.X + 1, coord.Y + 1, 0, p, bbin[p] & 0xFF));
            }
            coord = null;
            return true;
        }

        private BufferedImage RebuildZone(Queue<CoordinatesWeighted> fz, int val, int type) {
            Iterator<CoordinatesWeighted> iter = fz.get().iterator();
            CoordinatesWeighted pixel = iter.next();
            int minx = pixel.X;
            int maxx = pixel.X;
            int miny = pixel.Y;
            int maxy = pixel.Y;
            while (iter.hasNext()) {
                pixel = iter.next();
                if (pixel.X < minx) {
                    minx = pixel.X;
                }
                if (maxx < pixel.X) {
                    maxx = pixel.X;
                }
                if (pixel.Y < miny) {
                    miny = pixel.Y;
                }
                if (maxy >= pixel.Y) continue;
                maxy = pixel.Y;
            }
            int width = maxx - minx + 3;
            BufferedImage result = new BufferedImage(width, maxy - miny + 3, type);
            --minx;
            --miny;
            iter = fz.get().iterator();
            switch (type) {
                case 10: {
                    byte[] bb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                    while (iter.hasNext()) {
                        pixel = iter.next();
                        bb[pixel.X - minx + (pixel.Y - miny) * width] = (byte)val;
                        pixel = null;
                    }
                    bb = null;
                    break;
                }
                case 11: {
                    short[] sb = ((DataBufferShort)result.getRaster().getDataBuffer()).getData();
                    while (iter.hasNext()) {
                        pixel = iter.next();
                        sb[pixel.X - minx + (pixel.Y - miny) * width] = (short)val;
                        pixel = null;
                    }
                    sb = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Image type not supported.");
                }
            }
            iter = null;
            return result;
        }
    }
}

