/*
 * Decompiled with CFR 0.152.
 */
package processing.noises;

import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;

public class Impulsionnel {
    public BufferedImage Compute(BufferedImage source, double probability) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Compute(source, probability, result);
        return result;
    }

    public void Compute(BufferedImage source, double probability, BufferedImage result) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Image source and result have different dimension or type.");
        }
        if (probability < 0.0 || 1.0 < probability) {
            throw new IllegalArgumentException("Bad value of probability, [0, 1] required.");
        }
        switch (source.getType()) {
            case 10: {
                byte[] srcb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] resb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int i2 = 0; i2 < srcb.length; ++i2) {
                    resb[i2] = Math.random() < probability ? (byte)(Math.random() * 255.0 + 0.5) : srcb[i2];
                }
                resb = null;
                srcb = null;
                break;
            }
            case 11: {
                short[] srcs = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] ress = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                for (int i3 = 0; i3 < srcs.length; ++i3) {
                    ress[i3] = Math.random() < probability ? (short)(Math.random() * 65535.0 + 0.5) : srcs[i3];
                }
                ress = null;
                srcs = null;
                break;
            }
            case 5: 
            case 6: {
                int channel = source.getRaster().getNumBands();
                byte[] srcbc = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] resbc = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int i4 = 0; i4 < srcbc.length; i4 += channel) {
                    int c;
                    if (Math.random() < probability) {
                        for (c = 0; c < channel; ++c) {
                            resbc[i4 + c] = (byte)(Math.random() * 255.0 + 0.5);
                        }
                        continue;
                    }
                    for (c = 0; c < channel; ++c) {
                        resbc[i4 + c] = srcbc[i4 + c];
                    }
                }
                resbc = null;
                srcbc = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not yet supported.");
            }
        }
    }
}

