/*
 * Decompiled with CFR 0.152.
 */
package processing.noises;

import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.Random;

public class GaussianNoise {
    private Random random = new Random();

    public BufferedImage Compute(BufferedImage source, double StandardDeviation) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Compute(source, StandardDeviation, result);
        return result;
    }

    public void Compute(BufferedImage source, double StandardDeviation, BufferedImage result) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Image source and result have different dimension or type.");
        }
        if (StandardDeviation < 0.0) {
            throw new IllegalArgumentException("Bad value of StandardDeviation (< 0.0).");
        }
        switch (source.getType()) {
            case 5: 
            case 6: 
            case 10: {
                byte[] srcb = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] resb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int i2 = 0; i2 < srcb.length; ++i2) {
                    int v = (srcb[i2] & 0xFF) + (int)(this.random.nextGaussian() * StandardDeviation + 0.5);
                    resb[i2] = v < 0 ? 0 : (255 < v ? -1 : (byte)v);
                }
                resb = null;
                srcb = null;
                break;
            }
            case 11: {
                short[] srcs = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] ress = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                for (int i3 = 0; i3 < srcs.length; ++i3) {
                    int v = (srcs[i3] & 0xFFFF) + (int)(this.random.nextGaussian() * StandardDeviation + 0.5);
                    ress[i3] = v < 0 ? 0 : (65535 < v ? -1 : (short)v);
                }
                ress = null;
                srcs = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not yet supported.");
            }
        }
    }

    public DV Compute(DV source, double StandardDeviation) {
        DV result = DvNew.Same((DV)source);
        this.Compute(source, StandardDeviation, result);
        return result;
    }

    public void Compute(DV source, double StandardDeviation, DV result) {
        if (!DvTools.areDimensionsAndTypeEqual((DV)source, (DV)result)) {
            throw new IllegalArgumentException("Image source and result have different dimension or type.");
        }
        if (StandardDeviation < 0.0) {
            throw new IllegalArgumentException("Bad value of StandardDeviation (< 0.0).");
        }
        switch (source.Type) {
            case 8: {
                for (int c = 0; c < source.Channel; ++c) {
                    byte[] bbsrc = source.getDataBufferByte(c);
                    byte[] bbres = result.getDataBufferByte(c);
                    for (int i2 = 0; i2 < bbsrc.length; ++i2) {
                        int v = (bbsrc[i2] & 0xFF) + (int)(this.random.nextGaussian() * StandardDeviation + 0.5);
                        bbres[i2] = v < 0 ? 0 : (255 < v ? -1 : (byte)v);
                    }
                    bbres = null;
                    bbsrc = null;
                }
                break;
            }
            case 16: {
                for (int c = 0; c < source.Channel; ++c) {
                    short[] sbsrc = source.getDataBufferShort(c);
                    short[] sbres = result.getDataBufferShort(c);
                    for (int i3 = 0; i3 < sbsrc.length; ++i3) {
                        int v = (sbsrc[i3] & 0xFFFF) + (int)(this.random.nextGaussian() * StandardDeviation + 0.5);
                        sbres[i3] = v < 0 ? 0 : (65535 < v ? -1 : (short)v);
                    }
                    sbres = null;
                    sbsrc = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }
}

