/*
 * Decompiled with CFR 0.152.
 */
package processing.noises;

import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class GaussianBlur {
    public BufferedImage Compute(BufferedImage ip, double mean, double variance) {
        BufferedImage res = ImageNew.Same((BufferedImage)ip);
        this.Compute(ip, mean, variance, res);
        return res;
    }

    public void Compute(BufferedImage ip, double mean, double variance, BufferedImage res) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)ip, (BufferedImage)res)) {
            throw new IllegalArgumentException("Image source and result have different dimension or type.");
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        double st_dev = Math.sqrt(variance);
        WritableRaster wrip = ip.getRaster();
        WritableRaster wrr = res.getRaster();
        switch (ip.getType()) {
            case 10: 
            case 12: {
                for (int i2 = 0; i2 < height; ++i2) {
                    for (int j = 0; j < width; ++j) {
                        int fortegn = Math.random() < 0.5 ? -1 : 1;
                        int noise = (int)(0.5 + this.boxMuller(Math.random(), Math.random(), mean, st_dev));
                        int value = wrip.getSample(j, i2, 0);
                        int newValue = Math.max(0, Math.min(255, value + fortegn * noise));
                        wrr.setSample(j, i2, 0, newValue);
                    }
                }
                break;
            }
            case 11: {
                for (int i3 = 0; i3 < height; ++i3) {
                    for (int j = 0; j < width; ++j) {
                        int fortegn = Math.random() < 0.5 ? -1 : 1;
                        int noise = (int)(0.5 + this.boxMuller(Math.random(), Math.random(), mean, st_dev));
                        int value = wrip.getSample(j, i3, 0);
                        int newValue = Math.max(0, Math.min(65535, value + fortegn * noise));
                        wrr.setSample(j, i3, 0, newValue);
                    }
                }
                break;
            }
            case 5: {
                for (int i4 = 0; i4 < height; ++i4) {
                    for (int j = 0; j < width; ++j) {
                        int fortegn = Math.random() < 0.5 ? -1 : 1;
                        int noise = (int)(0.5 + this.boxMuller(Math.random(), Math.random(), mean, st_dev));
                        int valueR = wrip.getSample(j, i4, 0);
                        int newValueR = Math.max(0, Math.min(255, valueR + fortegn * noise));
                        int valueG = wrip.getSample(j, i4, 1);
                        int newValueG = Math.max(0, Math.min(255, valueG + fortegn * noise));
                        int valueB = wrip.getSample(j, i4, 2);
                        int newValueB = Math.max(0, Math.min(255, valueB + fortegn * noise));
                        wrr.setSample(j, i4, 0, newValueR);
                        wrr.setSample(j, i4, 1, newValueG);
                        wrr.setSample(j, i4, 2, newValueB);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("BufferedImage type not supported.");
            }
        }
        wrip = null;
        wrr = null;
    }

    protected double boxMuller(double u1, double u2, double mean, double st_dev) {
        return Math.sqrt(-2.0 * Math.log(u2)) * Math.cos(Math.PI * 2 * u1) * st_dev + mean;
    }
}

