/*
 * Decompiled with CFR 0.152.
 */
package processing.inpainting.patchmatch;

import java.util.Random;
import processing.inpainting.patchmatch.MaskedImage;

public class NNF {
    public MaskedImage input;
    public MaskedImage output;
    public int S;
    public int[][][] field;
    Random random = new Random(0L);

    public NNF(MaskedImage input, MaskedImage output, int patchsize) {
        this.input = input;
        this.output = output;
        this.S = patchsize;
    }

    public void randomize() {
        this.field = new int[this.input.W][this.input.H][3];
        for (int y = 0; y < this.input.H; ++y) {
            for (int x = 0; x < this.input.W; ++x) {
                this.field[x][y][0] = this.random.nextInt(this.output.W);
                this.field[x][y][1] = this.random.nextInt(this.output.H);
                this.field[x][y][2] = 65535;
            }
        }
        this.initialize();
    }

    public void initialize(NNF nnf) {
        this.field = new int[this.input.W][this.input.H][3];
        int fx = this.input.W / nnf.input.W;
        int fy = this.input.H / nnf.input.H;
        for (int y = 0; y < this.input.H; ++y) {
            for (int x = 0; x < this.input.W; ++x) {
                int xlow = Math.min(x / fx, nnf.input.W - 1);
                int ylow = Math.min(y / fy, nnf.input.H - 1);
                this.field[x][y][0] = nnf.field[xlow][ylow][0] * fx;
                this.field[x][y][1] = nnf.field[xlow][ylow][1] * fy;
                this.field[x][y][2] = 65535;
            }
        }
        this.initialize();
    }

    private void initialize() {
        for (int y = 0; y < this.input.H; ++y) {
            for (int x = 0; x < this.input.W; ++x) {
                this.field[x][y][2] = this.distance(x, y, this.field[x][y][0], this.field[x][y][1]);
                int maxretry = 20;
                for (int iter = 0; this.field[x][y][2] == 65535 && iter < maxretry; ++iter) {
                    this.field[x][y][0] = this.random.nextInt(this.output.W);
                    this.field[x][y][1] = this.random.nextInt(this.output.H);
                    this.field[x][y][2] = this.distance(x, y, this.field[x][y][0], this.field[x][y][1]);
                }
            }
        }
    }

    public void minimize(int pass) {
        int min_x = 0;
        int min_y = 0;
        int max_x = this.input.W - 1;
        int max_y = this.input.H - 1;
        for (int i2 = 0; i2 < pass; ++i2) {
            int x;
            int y;
            for (y = min_y; y < max_y; ++y) {
                for (x = min_x; x <= max_x; ++x) {
                    if (this.field[x][y][2] <= 0) continue;
                    this.minimizeLink(x, y, 1);
                }
            }
            for (y = max_y; y >= min_y; --y) {
                for (x = max_x; x >= min_x; --x) {
                    if (this.field[x][y][2] <= 0) continue;
                    this.minimizeLink(x, y, -1);
                }
            }
        }
    }

    public void minimizeLink(int x, int y, int dir) {
        int yp;
        int xp;
        int dp;
        if (x - dir > 0 && x - dir < this.input.W && (dp = this.distance(x, y, xp = this.field[x - dir][y][0] + dir, yp = this.field[x - dir][y][1])) < this.field[x][y][2]) {
            this.field[x][y][0] = xp;
            this.field[x][y][1] = yp;
            this.field[x][y][2] = dp;
        }
        if (y - dir > 0 && y - dir < this.input.H && (dp = this.distance(x, y, xp = this.field[x][y - dir][0], yp = this.field[x][y - dir][1] + dir)) < this.field[x][y][2]) {
            this.field[x][y][0] = xp;
            this.field[x][y][1] = yp;
            this.field[x][y][2] = dp;
        }
        int xpi = this.field[x][y][0];
        int ypi = this.field[x][y][1];
        for (int wi = this.output.W; wi > 0; wi /= 2) {
            xp = xpi + this.random.nextInt(2 * wi) - wi;
            yp = ypi + this.random.nextInt(2 * wi) - wi;
            dp = this.distance(x, y, xp = Math.max(0, Math.min(this.output.W - 1, xp)), yp = Math.max(0, Math.min(this.output.H - 1, yp)));
            if (dp >= this.field[x][y][2]) continue;
            this.field[x][y][0] = xp;
            this.field[x][y][1] = yp;
            this.field[x][y][2] = dp;
        }
    }

    public int distance(int x, int y, int xp, int yp) {
        return MaskedImage.distance(this.input, x, y, this.output, xp, yp, this.S);
    }

    public int[][][] getField() {
        return this.field;
    }
}

