/*
 * Decompiled with CFR 0.152.
 */
package processing.inpainting.patchmatch;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class MaskedImage {
    private boolean[][] mask;
    private BufferedImage image;
    public final int W;
    public final int H;
    public static final int DSCALE = 65535;
    public static final double[] similarity;

    public MaskedImage(BufferedImage image, boolean[][] mask) {
        this.image = image;
        this.W = image.getWidth();
        this.H = image.getHeight();
        this.mask = mask;
    }

    public MaskedImage(int width, int height) {
        this.W = width;
        this.H = height;
        this.image = new BufferedImage(this.W, this.H, 1);
        this.mask = new boolean[this.W][this.H];
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    public int getSample(int x, int y, int band) {
        return this.image.getRaster().getSample(x, y, band);
    }

    public void setSample(int x, int y, int band, int value) {
        this.image.getRaster().setSample(x, y, band, value);
    }

    public boolean isMasked(int x, int y) {
        return this.mask[x][y];
    }

    public void setMask(int x, int y, boolean value) {
        this.mask[x][y] = value;
    }

    public boolean constainsMasked(int x, int y, int S) {
        for (int dy = -S; dy <= S; ++dy) {
            for (int dx = -S; dx <= S; ++dx) {
                int xs = x + dx;
                int ys = y + dy;
                if (xs < 0 || xs >= this.W || ys < 0 || ys >= this.H || !this.mask[xs][ys]) continue;
                return true;
            }
        }
        return false;
    }

    public static int distance(MaskedImage source, int xs, int ys, MaskedImage target, int xt, int yt, int S) {
        long distance = 0L;
        long wsum = 0L;
        long ssdmax = 585225L;
        for (int dy = -S; dy <= S; ++dy) {
            for (int dx = -S; dx <= S; ++dx) {
                wsum += ssdmax;
                int xks = xs + dx;
                int yks = ys + dy;
                if (xks < 1 || xks >= source.W - 1) {
                    distance += ssdmax;
                    continue;
                }
                if (yks < 1 || yks >= source.H - 1) {
                    distance += ssdmax;
                    continue;
                }
                if (source.isMasked(xks, yks)) {
                    distance += ssdmax;
                    continue;
                }
                int xkt = xt + dx;
                int ykt = yt + dy;
                if (xkt < 1 || xkt >= target.W - 1) {
                    distance += ssdmax;
                    continue;
                }
                if (ykt < 1 || ykt >= target.H - 1) {
                    distance += ssdmax;
                    continue;
                }
                if (target.isMasked(xkt, ykt)) {
                    distance += ssdmax;
                    continue;
                }
                long ssd = 0L;
                for (int band = 0; band < 3; ++band) {
                    int s_value = source.getSample(xks, yks, band);
                    int t_value = source.getSample(xkt, ykt, band);
                    int s_gx = 128 + (source.getSample(xks + 1, yks, band) - source.getSample(xks - 1, yks, band)) / 2;
                    int t_gx = 128 + (target.getSample(xkt + 1, ykt, band) - target.getSample(xkt - 1, ykt, band)) / 2;
                    int s_gy = 128 + (source.getSample(xks, yks + 1, band) - source.getSample(xks, yks - 1, band)) / 2;
                    int t_gy = 128 + (target.getSample(xkt, ykt + 1, band) - target.getSample(xkt, ykt - 1, band)) / 2;
                    ssd = (long)((double)ssd + Math.pow(s_value - t_value, 2.0));
                    ssd = (long)((double)ssd + Math.pow(s_gx - t_gx, 2.0));
                    ssd = (long)((double)ssd + Math.pow(s_gy - t_gy, 2.0));
                }
                distance += ssd;
            }
        }
        return (int)(65535L * distance / wsum);
    }

    public static BufferedImage resize(BufferedImage input, int newwidth, int newheight) {
        BufferedImage out = new BufferedImage(newwidth, newheight, 1);
        Graphics2D g = out.createGraphics();
        Image scaled = input.getScaledInstance(newwidth, newheight, 4);
        g.drawImage(scaled, 0, 0, out.getWidth(), out.getHeight(), null);
        g.dispose();
        return out;
    }

    public MaskedImage copy() {
        boolean[][] newmask = new boolean[this.W][this.H];
        BufferedImage newimage = new BufferedImage(this.W, this.H, 1);
        newimage.createGraphics().drawImage((Image)this.image, 0, 0, null);
        for (int y = 0; y < this.H; ++y) {
            for (int x = 0; x < this.W; ++x) {
                newmask[x][y] = this.mask[x][y];
            }
        }
        return new MaskedImage(newimage, newmask);
    }

    public MaskedImage downsample() {
        int newW = this.W / 2;
        int newH = this.H / 2;
        int[] kernel = new int[]{1, 5, 10, 10, 5, 1};
        MaskedImage newimage = new MaskedImage(newW, newH);
        for (int y = 0; y < this.H - 1; y += 2) {
            for (int x = 0; x < this.W - 1; x += 2) {
                int r = 0;
                int g = 0;
                int b = 0;
                int m = 0;
                int ksum = 0;
                for (int dy = -2; dy <= 3; ++dy) {
                    int yk = y + dy;
                    if (yk < 0 || yk >= this.H) continue;
                    int ky = kernel[2 + dy];
                    for (int dx = -2; dx <= 3; ++dx) {
                        int xk = x + dx;
                        if (xk < 0 || xk >= this.W || this.mask[xk][yk]) continue;
                        int k = kernel[2 + dx] * ky;
                        r += k * this.getSample(xk, yk, 0);
                        g += k * this.getSample(xk, yk, 1);
                        b += k * this.getSample(xk, yk, 2);
                        ksum += k;
                        ++m;
                    }
                }
                if (ksum > 0) {
                    r /= ksum;
                    g /= ksum;
                    b /= ksum;
                }
                if (m != 0) {
                    newimage.setSample(x / 2, y / 2, 0, r);
                    newimage.setSample(x / 2, y / 2, 1, g);
                    newimage.setSample(x / 2, y / 2, 2, b);
                    newimage.setMask(x / 2, y / 2, false);
                    continue;
                }
                newimage.setMask(x / 2, y / 2, true);
            }
        }
        return newimage;
    }

    public MaskedImage upscale(int newW, int newH) {
        MaskedImage newimage = new MaskedImage(newW, newH);
        for (int y = 0; y < newH; ++y) {
            for (int x = 0; x < newW; ++x) {
                int xs = x * this.W / newW;
                int ys = y * this.H / newH;
                if (!this.mask[xs][ys]) {
                    newimage.setSample(x, y, 0, this.getSample(xs, ys, 0));
                    newimage.setSample(x, y, 1, this.getSample(xs, ys, 1));
                    newimage.setSample(x, y, 2, this.getSample(xs, ys, 2));
                    newimage.setMask(x, y, false);
                    continue;
                }
                newimage.setMask(x, y, true);
            }
        }
        return newimage;
    }

    static {
        double[] base = new double[]{1.0, 0.99, 0.96, 0.83, 0.38, 0.11, 0.02, 0.005, 6.0E-4, 1.0E-4, 0.0};
        similarity = new double[65536];
        for (int i2 = 0; i2 < similarity.length; ++i2) {
            double v;
            double t = (double)i2 / (double)similarity.length;
            int j = (int)(100.0 * t);
            int k = j + 1;
            double vj = j < base.length ? base[j] : 0.0;
            double vk = k < base.length ? base[k] : 0.0;
            MaskedImage.similarity[i2] = v = vj + (100.0 * t - (double)j) * (vk - vj);
        }
    }
}

