/*
 * Decompiled with CFR 0.152.
 */
package processing.inpainting.patchmatch;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import processing.inpainting.patchmatch.MaskedImage;
import processing.inpainting.patchmatch.NNF;
import utils.times.Chronometer;

public class Inpaint {
    private MaskedImage initial = null;
    private NNF nnf_SourceToTarget = null;
    private NNF nnf_TargetToSource = null;
    private int radius = -1;
    private List<MaskedImage> pyramid = new ArrayList<MaskedImage>(113);

    public BufferedImage inpaint(BufferedImage input, boolean[][] mask, int radius, Chronometer chrono) {
        if (input.getWidth() != mask.length || input.getHeight() != mask[0].length) {
            throw new IllegalArgumentException("Input image and mask have different dimensions.");
        }
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius <= 0.");
        }
        int marker = 0;
        if (chrono != null) {
            marker = chrono.NewMarker();
            System.out.print("Inpainting using patchmatch algorithm... ");
        }
        this.initial = new MaskedImage(input, mask);
        this.radius = radius;
        MaskedImage source = this.initial;
        MaskedImage target = null;
        this.pyramid.clear();
        this.pyramid.add(source);
        while (source.W > radius && source.H > radius) {
            source = source.downsample();
            this.pyramid.add(source);
        }
        int maxlevel = this.pyramid.size();
        for (int level = maxlevel - 1; level >= 0; --level) {
            if (chrono != null) {
                System.out.println("Zoom 1:" + (1 << level));
            }
            source = this.pyramid.get(level);
            if (level == maxlevel - 1) {
                target = source.copy();
                for (int y = 0; y < target.H; ++y) {
                    for (int x = 0; x < target.W; ++x) {
                        target.setMask(x, y, false);
                    }
                }
                this.nnf_SourceToTarget = new NNF(source, target, radius);
                this.nnf_SourceToTarget.randomize();
                this.nnf_TargetToSource = new NNF(target, source, radius);
                this.nnf_TargetToSource.randomize();
            } else {
                NNF new_nnf = new NNF(source, target, radius);
                new_nnf.initialize(this.nnf_SourceToTarget);
                this.nnf_SourceToTarget = new_nnf;
                NNF new_nnf_rev = new NNF(target, source, radius);
                new_nnf_rev.initialize(this.nnf_TargetToSource);
                this.nnf_TargetToSource = new_nnf_rev;
            }
            target = this.ExpectationMaximization(level);
        }
        if (chrono != null) {
            System.out.println(chrono.getTimeSinceMarker(marker) + "s");
            chrono.FreeMarker(marker);
        }
        return target.getBufferedImage();
    }

    private MaskedImage ExpectationMaximization(int level) {
        int iterEM = 1 + 2 * level;
        int iterNNF = Math.min(7, 1 + level);
        MaskedImage source = this.nnf_SourceToTarget.input;
        MaskedImage target = this.nnf_SourceToTarget.output;
        MaskedImage newtarget = null;
        for (int emloop = 1; emloop <= iterEM; ++emloop) {
            MaskedImage newsource;
            int x;
            int y;
            if (newtarget != null) {
                this.nnf_SourceToTarget.output = newtarget;
                this.nnf_TargetToSource.input = newtarget;
                target = newtarget;
                newtarget = null;
            }
            for (y = 0; y < source.H; ++y) {
                for (x = 0; x < source.W; ++x) {
                    if (source.constainsMasked(x, y, this.radius)) continue;
                    this.nnf_SourceToTarget.field[x][y][0] = x;
                    this.nnf_SourceToTarget.field[x][y][1] = y;
                    this.nnf_SourceToTarget.field[x][y][2] = 0;
                }
            }
            for (y = 0; y < target.H; ++y) {
                for (x = 0; x < target.W; ++x) {
                    if (source.constainsMasked(x, y, this.radius)) continue;
                    this.nnf_TargetToSource.field[x][y][0] = x;
                    this.nnf_TargetToSource.field[x][y][1] = y;
                    this.nnf_TargetToSource.field[x][y][2] = 0;
                }
            }
            this.nnf_SourceToTarget.minimize(iterNNF);
            this.nnf_TargetToSource.minimize(iterNNF);
            boolean upscaled = false;
            if (level >= 1 && emloop == iterEM) {
                newsource = this.pyramid.get(level - 1);
                newtarget = target.upscale(newsource.W, newsource.H);
                upscaled = true;
            } else {
                newsource = this.pyramid.get(level);
                newtarget = target.copy();
                upscaled = false;
            }
            double[][][] vote = new double[newtarget.W][newtarget.H][4];
            this.ExpectationStep(this.nnf_SourceToTarget, true, vote, newsource, upscaled);
            this.ExpectationStep(this.nnf_TargetToSource, false, vote, newsource, upscaled);
            this.MaximizationStep(newtarget, vote);
        }
        return newtarget;
    }

    private void ExpectationStep(NNF nnf, boolean sourceToTarget, double[][][] vote, MaskedImage source, boolean upscale) {
        int[][][] field = nnf.getField();
        int R = nnf.S;
        for (int y = 0; y < nnf.input.H; ++y) {
            for (int x = 0; x < nnf.input.W; ++x) {
                int xp = field[x][y][0];
                int yp = field[x][y][1];
                int dp = field[x][y][2];
                double w = MaskedImage.similarity[dp];
                for (int dy = -R; dy <= R; ++dy) {
                    for (int dx = -R; dx <= R; ++dx) {
                        int yt;
                        int xt;
                        int ys;
                        int xs;
                        if (sourceToTarget) {
                            xs = x + dx;
                            ys = y + dy;
                            xt = xp + dx;
                            yt = yp + dy;
                        } else {
                            xs = xp + dx;
                            ys = yp + dy;
                            xt = x + dx;
                            yt = y + dy;
                        }
                        if (xs < 0 || xs >= nnf.input.W || ys < 0 || ys >= nnf.input.H || xt < 0 || xt >= nnf.output.W || yt < 0 || yt >= nnf.output.H) continue;
                        if (upscale) {
                            this.weightedCopy(source, 2 * xs, 2 * ys, vote, 2 * xt, 2 * yt, w);
                            this.weightedCopy(source, 2 * xs + 1, 2 * ys, vote, 2 * xt + 1, 2 * yt, w);
                            this.weightedCopy(source, 2 * xs, 2 * ys + 1, vote, 2 * xt, 2 * yt + 1, w);
                            this.weightedCopy(source, 2 * xs + 1, 2 * ys + 1, vote, 2 * xt + 1, 2 * yt + 1, w);
                            continue;
                        }
                        this.weightedCopy(source, xs, ys, vote, xt, yt, w);
                    }
                }
            }
        }
    }

    private void weightedCopy(MaskedImage src, int xs, int ys, double[][][] vote, int xd, int yd, double w) {
        if (src.isMasked(xs, ys)) {
            return;
        }
        double[] dArray = vote[xd][yd];
        dArray[0] = dArray[0] + w * (double)src.getSample(xs, ys, 0);
        double[] dArray2 = vote[xd][yd];
        dArray2[1] = dArray2[1] + w * (double)src.getSample(xs, ys, 1);
        double[] dArray3 = vote[xd][yd];
        dArray3[2] = dArray3[2] + w * (double)src.getSample(xs, ys, 2);
        double[] dArray4 = vote[xd][yd];
        dArray4[3] = dArray4[3] + w;
    }

    private void MaximizationStep(MaskedImage target, double[][][] vote) {
        for (int y = 0; y < target.H; ++y) {
            for (int x = 0; x < target.W; ++x) {
                if (!(vote[x][y][3] > 0.0)) continue;
                int r = (int)(vote[x][y][0] / vote[x][y][3]);
                int g = (int)(vote[x][y][1] / vote[x][y][3]);
                int b = (int)(vote[x][y][2] / vote[x][y][3]);
                target.setSample(x, y, 0, r);
                target.setSample(x, y, 1, g);
                target.setSample(x, y, 2, b);
                target.setMask(x, y, false);
            }
        }
    }
}

