/*
 * Decompiled with CFR 0.152.
 */
package processing.filters.gradients;

import dv.DV;
import dv.DvNew;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.List;
import morphee.StructuringElement;
import processing.filters.gradients.Gradient;
import processing.filters.gradients.SignalGradient;
import processing.filters.gradients.Sobel;

public class Scharr
implements SignalGradient {
    private int[][] ScharrX = new int[][]{{-1, 0, 1}, {-2, 0, 2}, {-1, 0, 1}};
    private int[][] ScharrY = new int[][]{{1, 2, 1}, {0, 0, 0}, {-1, -2, -1}};
    private int HowCorrect = 2;
    private SignalGradient GX = new Gradient();
    private SignalGradient GY = new Gradient();
    private StructuringElement sex = null;
    private StructuringElement sey = null;
    private BufferedImage gx;
    private BufferedImage gy;

    public void Kill() {
        if (this.sex != null) {
            this.sex.Kill();
        }
        this.sex = null;
        if (this.sey != null) {
            this.sey.Kill();
        }
        this.sey = null;
        if (this.GX != null) {
            this.GX.Kill();
        }
        this.GX = null;
        if (this.GY != null) {
            this.GY.Kill();
        }
        this.GY = null;
        this.gy = null;
        this.gx = null;
        this.ScharrY = null;
        this.ScharrX = null;
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.sex == null) {
            this.sex = new StructuringElement(this.ScharrX);
            this.sey = new StructuringElement(this.ScharrY);
            this.GX.Parameters(new Object[]{this.sex, this.HowCorrect});
            this.GY.Parameters(new Object[]{this.sey, this.HowCorrect});
        }
        if (this.gx == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)this.gx)) {
            this.gy = null;
            this.gx = null;
            this.gx = ImageNew.Same((BufferedImage)source);
            this.gy = ImageNew.Same((BufferedImage)source);
        }
        this.GX.Filter(source, this.gx, nbCPU);
        this.GY.Filter(source, this.gy, nbCPU);
        switch (source.getType()) {
            case 10: {
                byte[] bbinx = ((DataBufferByte)this.gx.getRaster().getDataBuffer()).getData();
                byte[] bbiny = ((DataBufferByte)this.gy.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bbres.length; ++x) {
                    bbres[x] = (byte)Math.sqrt((bbinx[x] & 0xFF) * (bbinx[x] & 0xFF) + (bbiny[x] & 0xFF) * (bbiny[x] & 0xFF));
                }
                bbres = null;
                bbiny = null;
                bbinx = null;
                break;
            }
            case 11: {
                short[] sbinx = ((DataBufferUShort)this.gx.getRaster().getDataBuffer()).getData();
                short[] sbiny = ((DataBufferUShort)this.gy.getRaster().getDataBuffer()).getData();
                short[] sbres = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < sbres.length; ++x) {
                    sbres[x] = (short)Math.sqrt((sbinx[x] & 0xFFFF) * (sbinx[x] & 0xFFFF) + (sbiny[x] & 0xFFFF) * (sbiny[x] & 0xFFFF));
                }
                sbres = null;
                sbiny = null;
                sbinx = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new UnsupportedOperationException("Method not implemented (yet)");
    }

    public void HowCorrect(int howcorrect) {
        this.HowCorrect = howcorrect;
        if (this.sex != null) {
            this.GX.Parameters(new Object[]{this.sex, this.HowCorrect});
            this.GY.Parameters(new Object[]{this.sey, this.HowCorrect});
        }
    }

    public int HowCorrect() {
        return this.HowCorrect;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.HowCorrect((Integer)parameters[0]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(this.sex);
        params.add(this.sey);
        params.add(this.HowCorrect);
        return params;
    }

    public int BorderEffectSizeX() {
        return 1;
    }

    public int BorderEffectSizeY() {
        return 1;
    }

    public int BorderEffectSizeZ() {
        return 1;
    }

    public SignalGradient Clone() {
        Sobel clone = new Sobel();
        clone.HowCorrect(this.HowCorrect);
        return clone;
    }
}

