/*
 * Decompiled with CFR 0.152.
 */
package processing.filters.gradients;

import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.List;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.filters.gradients.Gradient;
import processing.filters.gradients.SignalGradient;

public class Prewitt
implements SignalGradient {
    private int[][] PrewittX = new int[][]{{-1, 0, 1}, {-1, 0, 1}, {-1, 0, 1}};
    private int[][] PrewittY = new int[][]{{1, 1, 1}, {0, 0, 0}, {-1, -1, -1}};
    private int[][][] Prewitt3X = new int[][][]{new int[][]{{-1, 0, 1}, {-1, 0, 1}, {-1, 0, 1}}, new int[][]{{-1, 0, 1}, {-1, 0, 1}, {-1, 0, 1}}, new int[][]{{-1, 0, 1}, {-1, 0, 1}, {-1, 0, 1}}};
    private int[][][] Prewitt3Y = new int[][][]{new int[][]{{1, 1, 1}, {0, 0, 0}, {-1, -1, -1}}, new int[][]{{1, 1, 1}, {0, 0, 0}, {-1, -1, -1}}, new int[][]{{1, 1, 1}, {0, 0, 0}, {-1, -1, -1}}};
    private int[][][] Prewitt3Z = new int[][][]{new int[][]{{-1, -1, -1}, {-1, -1, -1}, {-1, -1, -1}}, new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, new int[][]{{1, 1, 1}, {1, 1, 1}, {1, 1, 1}}};
    private int HowCorrect = 2;
    private SignalGradient GX = new Gradient();
    private SignalGradient GY = new Gradient();
    private SignalGradient GZ = new Gradient();
    private StructuringElement sex = null;
    private StructuringElement sey = null;
    private BufferedImage gx;
    private BufferedImage gy;
    private StructuringElement3D se3x = null;
    private StructuringElement3D se3y = null;
    private StructuringElement3D se3z = null;
    private DV g3x;
    private DV g3y;
    private DV g3z;

    public void Kill() {
        if (this.sex != null) {
            this.sex.Kill();
        }
        this.sex = null;
        if (this.sey != null) {
            this.sey.Kill();
        }
        this.sey = null;
        if (this.se3x != null) {
            this.se3x.Kill();
        }
        this.se3x = null;
        if (this.se3y != null) {
            this.se3y.Kill();
        }
        this.se3y = null;
        if (this.se3z != null) {
            this.se3z.Kill();
        }
        this.se3z = null;
        if (this.GX != null) {
            this.GX.Kill();
        }
        this.GX = null;
        if (this.GY != null) {
            this.GY.Kill();
        }
        this.GY = null;
        if (this.GZ != null) {
            this.GZ.Kill();
        }
        this.GZ = null;
        this.gy = null;
        this.gx = null;
        if (this.g3x != null) {
            this.g3x.Kill();
        }
        if (this.g3y != null) {
            this.g3y.Kill();
        }
        if (this.g3z != null) {
            this.g3z.Kill();
        }
        this.g3z = null;
        this.g3y = null;
        this.g3x = null;
        this.PrewittY = null;
        this.PrewittX = null;
        this.Prewitt3Z = null;
        this.Prewitt3Y = null;
        this.Prewitt3X = null;
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.sex == null) {
            this.sex = new StructuringElement(this.PrewittX);
            this.sey = new StructuringElement(this.PrewittY);
            this.GX.Parameters(new Object[]{this.sex, this.HowCorrect});
            this.GY.Parameters(new Object[]{this.sey, this.HowCorrect});
        }
        if (this.gx == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)this.gx)) {
            this.gy = null;
            this.gx = null;
            this.gx = ImageNew.Same((BufferedImage)source);
            this.gy = ImageNew.Same((BufferedImage)source);
        }
        this.GX.Filter(source, this.gx, nbCPU);
        this.GY.Filter(source, this.gy, nbCPU);
        switch (source.getType()) {
            case 10: {
                byte[] bbinx = ((DataBufferByte)this.gx.getRaster().getDataBuffer()).getData();
                byte[] bbiny = ((DataBufferByte)this.gy.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bbres.length; ++x) {
                    bbres[x] = (byte)Math.sqrt(Math.pow(bbinx[x] & 0xFF, 2.0) + Math.pow(bbiny[x] & 0xFF, 2.0));
                }
                bbres = null;
                bbiny = null;
                bbinx = null;
                break;
            }
            case 11: {
                short[] sbinx = ((DataBufferUShort)this.gx.getRaster().getDataBuffer()).getData();
                short[] sbiny = ((DataBufferUShort)this.gy.getRaster().getDataBuffer()).getData();
                short[] sbres = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < sbres.length; ++x) {
                    sbres[x] = (byte)Math.sqrt(Math.pow(sbinx[x] & 0xFF, 2.0) + Math.pow(sbiny[x] & 0xFF, 2.0));
                }
                sbres = null;
                sbiny = null;
                sbinx = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        if (this.se3x == null) {
            this.se3x = new StructuringElement3D(this.Prewitt3X);
            this.se3y = new StructuringElement3D(this.Prewitt3Y);
            this.se3z = new StructuringElement3D(this.Prewitt3Z);
            this.GX.Parameters(new Object[]{this.se3x, this.HowCorrect});
            this.GY.Parameters(new Object[]{this.se3y, this.HowCorrect});
            this.GZ.Parameters(new Object[]{this.se3z, this.HowCorrect});
        }
        if (this.g3x == null || !DvTools.areDimensionsAndTypeEqual((DV)source, (DV)this.g3x)) {
            this.g3z = null;
            this.g3y = null;
            this.g3x = null;
            this.g3x = DvNew.Same((DV)source);
            this.g3y = DvNew.Same((DV)source);
            this.g3z = DvNew.Same((DV)source);
        }
        this.GX.Filter(source, this.g3x, nbCPU);
        this.GY.Filter(source, this.g3y, nbCPU);
        this.GZ.Filter(source, this.g3z, nbCPU);
        switch (source.Type) {
            case 8: {
                for (int c = 0; c < source.Channel; ++c) {
                    byte[] bbinx = this.g3x.getDataBufferByte(c);
                    byte[] bbiny = this.g3y.getDataBufferByte(c);
                    byte[] bbinz = this.g3z.getDataBufferByte(c);
                    byte[] bbres = result.getDataBufferByte(c);
                    for (int x = 0; x < bbres.length; ++x) {
                        bbres[x] = (byte)Math.sqrt((bbinx[x] & 0xFF) * (bbinx[x] & 0xFF) + (bbiny[x] & 0xFF) * (bbiny[x] & 0xFF) + (bbinz[x] & 0xFF) * (bbinz[x] & 0xFF));
                    }
                    bbres = null;
                    bbinz = null;
                    bbiny = null;
                    bbinx = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
    }

    public void HowCorrect(int howcorrect) {
        this.HowCorrect = howcorrect;
        if (this.sex != null) {
            this.GX.Parameters(new Object[]{this.sex, this.HowCorrect});
            this.GY.Parameters(new Object[]{this.sey, this.HowCorrect});
        }
        if (this.se3x != null) {
            this.GX.Parameters(new Object[]{this.se3x, this.HowCorrect});
            this.GY.Parameters(new Object[]{this.se3y, this.HowCorrect});
            this.GZ.Parameters(new Object[]{this.se3z, this.HowCorrect});
        }
    }

    public int HowCorrect() {
        return this.HowCorrect;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.HowCorrect((Integer)parameters[0]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(this.sex);
        params.add(this.sey);
        params.add(this.HowCorrect);
        return params;
    }

    public int BorderEffectSizeX() {
        return 1;
    }

    public int BorderEffectSizeY() {
        return 1;
    }

    public int BorderEffectSizeZ() {
        return 1;
    }

    public SignalGradient Clone() {
        Prewitt clone = new Prewitt();
        clone.HowCorrect(this.HowCorrect);
        return clone;
    }
}

