/*
 * Decompiled with CFR 0.152.
 */
package processing.filters.gradients;

import dv.DV;
import dv.DvNew;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.filters.gradients.Gradient;
import processing.filters.gradients.SignalGradient;

public class Laplacian4
implements SignalGradient {
    private int[][] Laplacian = new int[][]{{0, 1, 0}, {1, -4, 1}, {0, 1, 0}};
    private int[][][] Laplacian3 = new int[][][]{new int[][]{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {1, -6, 1}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}};
    private int HowCorrect = 2;
    private SignalGradient gradient = new Gradient();
    private StructuringElement se = null;
    private StructuringElement3D se3d = null;

    public void Kill() {
        if (this.se != null) {
            this.se.Kill();
        }
        this.se = null;
        if (this.se3d != null) {
            this.se3d.Kill();
        }
        this.se3d = null;
        if (this.gradient != null) {
            this.gradient.Kill();
        }
        this.gradient = null;
        this.Laplacian = null;
        this.Laplacian3 = null;
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.se == null) {
            this.se = new StructuringElement(this.Laplacian);
            this.gradient.Parameters(new Object[]{this.se, this.HowCorrect});
        }
        this.gradient.Filter(source, result, nbCPU);
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        if (this.se3d == null) {
            this.se3d = new StructuringElement3D(this.Laplacian3);
            this.gradient.Parameters(new Object[]{this.se3d, this.HowCorrect});
        }
        this.gradient.Filter(source, result, nbCPU);
    }

    public void HowCorrect(int howcorrect) {
        this.HowCorrect = howcorrect;
    }

    public int HowCorrect() {
        return this.HowCorrect;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.HowCorrect = (Integer)parameters[0];
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.se);
        params.add(this.HowCorrect);
        return params;
    }

    public int BorderEffectSizeX() {
        return 1;
    }

    public int BorderEffectSizeY() {
        return 1;
    }

    public int BorderEffectSizeZ() {
        return 1;
    }

    public SignalGradient Clone() {
        Laplacian4 clone = new Laplacian4();
        clone.HowCorrect(this.HowCorrect);
        return clone;
    }
}

