/*
 * Decompiled with CFR 0.152.
 */
package processing.filters.gradients;

import dv.DV;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import processing.filters.SignalFilter;
import processing.filters.gradients.SignalGradient;

public class GaussianDerivative
implements SignalFilter {
    private int[] logscale = new int[256];
    private int Order = 0;
    private double Sigma = 0.0;
    private double LogPower = 0.0;
    private boolean ShowIntensity = true;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.Order < 1) {
            throw new IllegalArgumentException("Parameters not defined.");
        }
        this.Filter(source, this.Order, this.Sigma, this.LogPower, this.ShowIntensity, result);
    }

    public void Filter(BufferedImage input, int order, double sigma, double logpower, boolean showintensity, BufferedImage output) {
        int x;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)input, (BufferedImage)output)) {
            throw new IllegalArgumentException("Images input and output must have identic dimensions and types.");
        }
        int width = input.getWidth();
        int height = input.getHeight();
        WritableRaster wrin = input.getRaster();
        WritableRaster wrout = output.getRaster();
        switch (input.getType()) {
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        double normalizer = 0.0;
        int radius = 0;
        double[][] kernel = null;
        switch (order) {
            case 1: {
                radius = (int)(1.0 + 2.0 * sigma);
                kernel = new double[2 * radius + 1][2 * radius + 1];
                normalizer = this.buildFirstOrderKernel(radius, sigma, kernel);
                break;
            }
            case 2: {
                radius = (int)(1.0 + 4.0 * sigma);
                kernel = new double[2 * radius + 1][2 * radius + 1];
                normalizer = this.buildSecondOrderKernel(radius, sigma, kernel);
            }
        }
        for (x = 0; x < 256; ++x) {
            this.logscale[x] = (int)(255.0 * Math.pow((double)x / 255.0, logpower));
        }
        for (int y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                double gn;
                double gy = 0.0;
                double gx = 0.0;
                for (int dy = -radius; dy <= radius; ++dy) {
                    for (int dx = -radius; dx <= radius; ++dx) {
                        int xk = x + dx;
                        int yk = y + dy;
                        if (xk < 0) {
                            xk = 0;
                        }
                        if (xk >= width) {
                            xk = width - 1;
                        }
                        if (yk < 0) {
                            yk = 0;
                        }
                        if (yk >= height) {
                            yk = height - 1;
                        }
                        double vk = wrin.getSampleDouble(xk, yk, 0);
                        gx += kernel[radius - dy][radius - dx] * vk;
                        gy += kernel[radius - dx][radius - dy] * vk;
                    }
                }
                double v = gn = Math.sqrt((gx /= normalizer) * gx + (gy /= normalizer) * gy);
                if (showintensity) {
                    int gray = wrin.getSample(x, y, 0);
                    v = gn * (double)gray / 255.0;
                }
                if (v < 0.0) {
                    v = 0.0;
                }
                if (v > 255.0) {
                    v = 255.0;
                }
                int iv = this.logscale[(int)v];
                wrout.setSample(x, y, 0, iv);
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    private double buildFirstOrderKernel(int radius, double sigma, double[][] kernel) {
        double sigma2 = Math.pow(sigma, 2.0);
        double normalizer = 0.0;
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                double e;
                double t = (double)(x * x + y * y) / (2.0 * sigma2);
                double dt = (double)(-x) / sigma2;
                kernel[radius + x][radius + y] = e = dt * Math.exp(-t);
                normalizer += Math.abs(e);
            }
        }
        return normalizer;
    }

    private double buildSecondOrderKernel(int radius, double sigma, double[][] kernel) {
        double sigma2 = Math.pow(sigma, 2.0);
        double sigma4 = Math.pow(sigma, 4.0);
        double normalizer = 0.0;
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                double e;
                double t = (double)(x * x + y * y) / (2.0 * sigma2);
                double d2t = ((double)(x * x) - sigma2) / sigma4;
                kernel[radius + x][radius + y] = e = d2t * Math.exp(-t);
                normalizer += Math.abs(e);
            }
        }
        return normalizer;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 4) {
            throw new IllegalArgumentException("Exactly 4 parameters required.");
        }
        this.Order = (Integer)parameters[0];
        this.Sigma = (Double)parameters[1];
        this.LogPower = (Double)parameters[2];
        this.ShowIntensity = (Boolean)parameters[3];
        if (this.Order < 1) {
            throw new IllegalArgumentException("Order < 1");
        }
        if (this.Sigma <= 0.0) {
            throw new IllegalArgumentException("Sigma <= 0.0");
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(4);
        params.add(this.Order);
        params.add(this.Sigma);
        params.add(this.LogPower);
        params.add(this.ShowIntensity);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalGradient Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

