/*
 * Decompiled with CFR 0.152.
 */
package processing.filters.gradients;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.List;
import morphee.StructuringElement;
import processing.filters.gradients.Gradient;
import processing.filters.gradients.SignalGradient;

public class Directionnal
implements SignalGradient {
    private double[][] DirX = new double[][]{{-1.0, 0.0, 1.0}, {-1.0, 0.0, 1.0}, {-1.0, 0.0, 1.0}};
    private double[][] DirY = new double[][]{{1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}, {-1.0, -1.0, -1.0}};
    private double[][] DirXY = new double[][]{{0.0, 1.0, 1.0}, {-1.0, 0.0, 1.0}, {-1.0, -1.0, 0.0}};
    private int HowCorrect = 1;
    private SignalGradient GX = new Gradient();
    private SignalGradient GY = new Gradient();
    private SignalGradient GXY = new Gradient();
    private StructuringElement sex = new StructuringElement(this.DirX);
    private StructuringElement sey = new StructuringElement(this.DirY);
    private StructuringElement sexy = new StructuringElement(this.DirXY);
    private BufferedImage gx;
    private BufferedImage gy;
    private BufferedImage gxy;

    public Directionnal() {
        this.GX.Parameters(new Object[]{this.sex, this.HowCorrect});
        this.GY.Parameters(new Object[]{this.sey, this.HowCorrect});
        this.GXY.Parameters(new Object[]{this.sexy, this.HowCorrect});
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.gx == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)this.gx)) {
            this.gxy = null;
            this.gy = null;
            this.gx = null;
            this.gx = ImageNew.Same((BufferedImage)source);
            this.gy = ImageNew.Same((BufferedImage)source);
            this.gxy = ImageNew.Same((BufferedImage)source);
        }
        this.GX.Filter(source, this.gx, nbCPU);
        this.GY.Filter(source, this.gy, nbCPU);
        this.GXY.Filter(source, this.gxy, nbCPU);
        switch (source.getType()) {
            case 10: {
                byte[] bbinx = ((DataBufferByte)this.gx.getRaster().getDataBuffer()).getData();
                byte[] bbiny = ((DataBufferByte)this.gy.getRaster().getDataBuffer()).getData();
                byte[] bbinxy = ((DataBufferByte)this.gxy.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bbres.length; ++x) {
                    bbres[x] = (byte)((double)((bbinx[x] & 0xFF) + (bbiny[x] & 0xFF) + (bbinxy[x] & 0xFF)) / 3.0 + 0.5);
                }
                bbres = null;
                bbinxy = null;
                bbiny = null;
                bbinx = null;
                break;
            }
            case 11: {
                short[] sbinx = ((DataBufferUShort)this.gx.getRaster().getDataBuffer()).getData();
                short[] sbiny = ((DataBufferUShort)this.gy.getRaster().getDataBuffer()).getData();
                short[] sbinxy = ((DataBufferUShort)this.gxy.getRaster().getDataBuffer()).getData();
                short[] sbres = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < sbres.length; ++x) {
                    sbres[x] = (short)((double)((sbinx[x] & 0xFFFF) + (sbiny[x] & 0xFFFF) + (sbinxy[x] & 0xFFFF)) / 3.0 + 0.5);
                }
                sbres = null;
                sbiny = null;
                sbinx = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void HowCorrect(int howcorrect) {
        this.HowCorrect = howcorrect;
        this.GX.Parameters(new Object[]{this.sex, this.HowCorrect});
        this.GY.Parameters(new Object[]{this.sey, this.HowCorrect});
        this.GXY.Parameters(new Object[]{this.sexy, this.HowCorrect});
    }

    public int HowCorrect() {
        return this.HowCorrect;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.HowCorrect((Integer)parameters[0]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(4);
        params.add(this.sex);
        params.add(this.sey);
        params.add(this.sexy);
        params.add(this.HowCorrect);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalGradient Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

