/*
 * Decompiled with CFR 0.152.
 */
package processing.filters.gradients;

import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.List;
import java.util.Vector;

public class DifferentialsIJ {
    public static final int GRADIENT_MAGNITUDE = 1;
    public static final int GRADIENT_DIRECTION = 2;
    public static final int LAPLACIAN = 3;
    public static final int LARGEST_HESSIAN = 4;
    public static final int SMALLEST_HESSIAN = 5;
    public static final int HESSIAN_ORIENTATION = 6;
    private final double FLT_EPSILON = Float.intBitsToFloat(0x33FFFFFF);
    protected int operation = -1;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        throw new Error("Bug in class! Do not use.");
    }

    public BufferedImage FilterX(BufferedImage source, int nbCPU) {
        switch (this.operation) {
            case 1: {
                this.getHorizontalGradient(source, this.FLT_EPSILON);
                break;
            }
            case 2: {
                this.getHorizontalGradient(source, this.FLT_EPSILON);
                break;
            }
            case 3: {
                this.getHorizontalHessian(source, this.FLT_EPSILON);
                break;
            }
            case 4: {
                this.getHorizontalHessian(source, this.FLT_EPSILON);
                break;
            }
            case 5: {
                this.getHorizontalHessian(source, this.FLT_EPSILON);
                break;
            }
            case 6: {
                this.getHorizontalHessian(source, this.FLT_EPSILON);
                break;
            }
            default: {
                throw new IllegalArgumentException("Default, Invalid operation: " + this.operation);
            }
        }
        return source;
    }

    public BufferedImage FilterY(BufferedImage source, int nbCPU) {
        switch (this.operation) {
            case 1: {
                this.getVerticalGradient(source, this.FLT_EPSILON);
                break;
            }
            case 2: {
                this.getVerticalGradient(source, this.FLT_EPSILON);
                break;
            }
            case 3: {
                this.getVerticalHessian(source, this.FLT_EPSILON);
                break;
            }
            case 4: {
                this.getVerticalHessian(source, this.FLT_EPSILON);
                break;
            }
            case 5: {
                this.getVerticalHessian(source, this.FLT_EPSILON);
                break;
            }
            case 6: {
                this.getVerticalHessian(source, this.FLT_EPSILON);
                break;
            }
            default: {
                throw new IllegalArgumentException("Default, Invalid operation: " + this.operation);
            }
        }
        return source;
    }

    public BufferedImage Compute(BufferedImage ip, int operation, int nbCPU) {
        this.operation = operation;
        return this.Filter(ip, nbCPU);
    }

    public int[][] FilterX(int[][] source) {
        return null;
    }

    public int[][] FilterY(int[][] source) {
        return null;
    }

    public int[][] Filter(int[][] source) {
        return null;
    }

    public void getCrossHessian(BufferedImage ip, double tolerance) {
        this.getHorizontalGradient(ip, tolerance);
        this.getVerticalGradient(ip, tolerance);
    }

    public void getHorizontalGradient(BufferedImage ip, double tolerance) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        double[] line = new double[width];
        for (int y = 0; y < height; ++y) {
            this.getRow(ip, y, line);
            this.getSplineInterpolationCoefficients(line, tolerance);
            this.getGradient(line);
            this.putRow(ip, y, line);
        }
    }

    public void getHorizontalHessian(BufferedImage ip, double tolerance) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        double[] line = new double[width];
        for (int y = 0; y < height; ++y) {
            this.getRow(ip, y, line);
            this.getSplineInterpolationCoefficients(line, tolerance);
            this.getHessian(line);
            this.putRow(ip, y, line);
        }
    }

    public void getVerticalGradient(BufferedImage ip, double tolerance) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        double[] line = new double[height];
        for (int x = 0; x < width; ++x) {
            this.getColumn(ip, x, line);
            this.getSplineInterpolationCoefficients(line, tolerance);
            this.getGradient(line);
            this.putColumn(ip, x, line);
        }
    }

    public void getVerticalHessian(BufferedImage ip, double tolerance) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        double[] line = new double[height];
        for (int x = 0; x < width; ++x) {
            this.getColumn(ip, x, line);
            this.getSplineInterpolationCoefficients(line, tolerance);
            this.getHessian(line);
            this.putColumn(ip, x, line);
        }
    }

    private void antiSymmetricFirMirrorOnBounds(double[] h, double[] c, double[] s) {
        if (h.length != 2) {
            throw new IndexOutOfBoundsException("The half-length filter size should be 2");
        }
        if (h[0] != 0.0) {
            throw new IllegalArgumentException("Antisymmetry violation (should have h[0]=0.0)");
        }
        if (c.length != s.length) {
            throw new IndexOutOfBoundsException("Incompatible size");
        }
        if (2 <= c.length) {
            s[0] = 0.0;
            for (int i2 = 1; i2 < s.length - 1; ++i2) {
                s[i2] = h[1] * (c[i2 + 1] - c[i2 - 1]);
            }
            s[s.length - 1] = 0.0;
        } else if (c.length == 1) {
            s[0] = 0.0;
        } else {
            throw new NegativeArraySizeException("Invalid length of data");
        }
    }

    private void getColumn(BufferedImage ip, int x, double[] column) {
        if (ip.getHeight() != column.length) {
            throw new IndexOutOfBoundsException("Incoherent array sizes");
        }
        WritableRaster wrip = ip.getRaster();
        for (int i2 = 0; i2 < column.length; ++i2) {
            column[i2] = wrip.getSampleDouble(x, i2, 0) / 255.0;
        }
        wrip = null;
    }

    private void getGradient(double[] c) {
        double[] h = new double[]{0.0, -0.5};
        double[] s = new double[c.length];
        this.antiSymmetricFirMirrorOnBounds(h, c, s);
        System.arraycopy(s, 0, c, 0, s.length);
    }

    private void getHessian(double[] c) {
        double[] h = new double[]{-2.0, 1.0};
        double[] s = new double[c.length];
        this.symmetricFirMirrorOnBounds(h, c, s);
        System.arraycopy(s, 0, c, 0, s.length);
    }

    private double getInitialAntiCausalCoefficientMirrorOnBounds(double[] c, double z, double tolerance) {
        return (z * c[c.length - 2] + c[c.length - 1]) * z / (z * z - 1.0);
    }

    private double getInitialCausalCoefficientMirrorOnBounds(double[] c, double z, double tolerance) {
        double z1 = z;
        double zn = Math.pow(z, c.length - 1);
        double sum = c[0] + zn * c[c.length - 1];
        int horizon = c.length;
        if (0.0 < tolerance) {
            horizon = 2 + (int)(Math.log(tolerance) / Math.log(Math.abs(z)));
            horizon = horizon < c.length ? horizon : c.length;
        }
        zn *= zn;
        for (int n = 1; n < horizon - 1; ++n) {
            sum += (z1 + (zn /= z)) * c[n];
            z1 *= z;
        }
        return sum / (1.0 - Math.pow(z, 2 * c.length - 2));
    }

    private void getRow(BufferedImage ip, int y, double[] row) {
        int rowLength = ip.getWidth();
        if (rowLength != row.length) {
            throw new IndexOutOfBoundsException("Incoherent array sizes");
        }
        WritableRaster wrip = ip.getRaster();
        for (int i2 = 0; i2 < rowLength; ++i2) {
            row[i2] = wrip.getSampleDouble(i2, y, 0) / 255.0;
        }
        wrip = null;
    }

    private void getSplineInterpolationCoefficients(double[] c, double tolerance) {
        int k;
        double[] z = new double[]{Math.sqrt(3.0) - 2.0};
        double lambda = 1.0;
        if (c.length == 1) {
            return;
        }
        for (k = 0; k < z.length; ++k) {
            lambda = lambda * (1.0 - z[k]) * (1.0 - 1.0 / z[k]);
        }
        int n = 0;
        while (n < c.length) {
            int n2 = n++;
            c[n2] = c[n2] * lambda;
        }
        for (k = 0; k < z.length; ++k) {
            int n3;
            c[0] = this.getInitialCausalCoefficientMirrorOnBounds(c, z[k], tolerance);
            for (n3 = 1; n3 < c.length; ++n3) {
                int n4 = n3;
                c[n4] = c[n4] + z[k] * c[n3 - 1];
            }
            c[c.length - 1] = this.getInitialAntiCausalCoefficientMirrorOnBounds(c, z[k], tolerance);
            for (n3 = c.length - 2; 0 <= n3; --n3) {
                c[n3] = z[k] * (c[n3 + 1] - c[n3]);
            }
        }
    }

    private void putColumn(BufferedImage ip, int x, double[] column) {
        if (ip.getHeight() != column.length) {
            throw new IndexOutOfBoundsException("Incoherent array sizes");
        }
        WritableRaster wrip = ip.getRaster();
        for (int i2 = 0; i2 < column.length; ++i2) {
            wrip.setSample(x, i2, 0, (short)(column[i2] * 255.0));
        }
        wrip = null;
    }

    private void putRow(BufferedImage ip, int y, double[] row) {
        int rowLength = ip.getWidth();
        WritableRaster wrip = ip.getRaster();
        if (rowLength != row.length) {
            throw new IndexOutOfBoundsException("Incoherent array sizes");
        }
        for (int i2 = 0; i2 < rowLength; ++i2) {
            wrip.setSample(i2, y, 0, (short)(row[i2] * 255.0));
        }
        wrip = null;
    }

    private void symmetricFirMirrorOnBounds(double[] h, double[] c, double[] s) {
        if (h.length != 2) {
            throw new IndexOutOfBoundsException("The half-length filter size should be 2");
        }
        if (c.length != s.length) {
            throw new IndexOutOfBoundsException("Incompatible size");
        }
        if (2 <= c.length) {
            s[0] = h[0] * c[0] + 2.0 * h[1] * c[1];
            for (int i2 = 1; i2 < s.length - 1; ++i2) {
                s[i2] = h[0] * c[i2] + h[1] * (c[i2 - 1] + c[i2 + 1]);
            }
            s[s.length - 1] = h[0] * c[c.length - 1] + 2.0 * h[1] * c[c.length - 2];
        } else {
            switch (c.length) {
                case 1: {
                    s[0] = (h[0] + 2.0 * h[1]) * c[0];
                    break;
                }
                default: {
                    throw new NegativeArraySizeException("Invalid length of data");
                }
            }
        }
    }

    public void ValuesCorrection(int Value) {
    }

    public int ValuesCorrection() {
        return -1;
    }

    public void Mask(double[][] mask) {
    }

    public double[][] Mask() {
        return null;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public int getOperation() {
        return this.operation;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required.");
        }
        this.operation = (Integer)parameters[0];
    }

    public List<Object> Parameters() {
        Vector<Object> params = new Vector<Object>(1);
        params.add(this.operation);
        return params;
    }
}

