/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import dv.DvArithmetic;
import dv.DvConverter;
import dv.DvDrawer;
import dv.DvFeatures;
import dv.DvNew;
import dv.DvTools;
import filesAndFolders.FileNameFilters;
import filesAndFolders.FilesFolders;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import mathematics.Maths;
import processing.filters.Gabor;
import processing.filters.Invert;
import processing.filters.SignalFilter;
import stackTiTi.StackArithmetic;
import stackTiTi.StackDrawer;
import stackTiTi.StackFeatures;
import stackTiTi.StackIO;
import stackTiTi.StackNew;
import stackTiTi.StackTools;
import utils.strings.StringToolsImageDV;

public class StructureEnhancer
implements SignalFilter {
    private final Gabor gabor = new Gabor();
    private final Invert invert = new Invert();
    private BufferedImage imbright = null;
    private BufferedImage imdark = null;
    private DV dvbright = null;
    private DV dvdark = null;
    private BufferedImage[] stackbright = null;
    private BufferedImage[] stackdark = null;
    private double coefficient = 0.9;
    private boolean globalaverage = false;
    private final DvFeatures DF = new DvFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    private final StackFeatures SF = new StackFeatures();

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public BufferedImage Filter(BufferedImage source, double coefficient, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, coefficient, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        this.Filter(source, this.coefficient, result, nbCPU);
    }

    public void Filter(BufferedImage source, double coefficient, BufferedImage result, int nbCPU) {
        if (this.gabor.IgnoreBorders()) {
            throw new IllegalArgumentException("IgnoreBorders not supported (yet).");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images must have identical type and dimensions.");
        }
        if (coefficient <= 0.0 || 1.0 < coefficient) {
            throw new IllegalArgumentException("The coefficient must be into the range ]0, 1].");
        }
        this.coefficient = coefficient;
        int width = source.getWidth();
        int height = source.getHeight();
        if (this.imbright == null || !ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)this.imbright)) {
            this.imbright = new BufferedImage(width, height, 11);
            this.imdark = new BufferedImage(width, height, 11);
        }
        ImageNew.Copy((BufferedImage)source, (BufferedImage)result);
        this.gabor.Filter(source, this.imbright, nbCPU);
        this.invert.Filter(source, source, nbCPU);
        this.gabor.Filter(source, this.imdark, nbCPU);
        this.invert.Filter(source, source, nbCPU);
        double maxbright = this.IF.Maximum(this.imbright);
        double maxdark = this.IF.Maximum(this.imdark);
        switch (source.getType()) {
            case 10: {
                byte[] bbsrc = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                short[] sbbright = ((DataBufferUShort)this.imbright.getRaster().getDataBuffer()).getData();
                short[] sbdark = ((DataBufferUShort)this.imdark.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int pos = 0; pos < bbsrc.length; ++pos) {
                    if ((sbdark[pos] & 0xFFFF) <= (sbbright[pos] & 0xFFFF)) continue;
                    double c = 1.0 - (double)(sbdark[pos] & 0xFFFF) / maxdark * coefficient;
                    bbres[pos] = (byte)((double)(bbsrc[pos] & 0xFF) * c);
                }
                bbres = null;
                bbsrc = null;
                sbdark = null;
                sbbright = null;
                break;
            }
            default: {
                WritableRaster wrsrc = source.getRaster();
                WritableRaster wrdark = this.imdark.getRaster();
                WritableRaster wrbright = this.imbright.getRaster();
                WritableRaster wrres = result.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (wrdark.getSample(x, y, 0) <= wrbright.getSample(x, y, 0)) continue;
                        double c = 1.0 - wrdark.getSampleDouble(x, y, 0) / maxdark * coefficient;
                        wrres.setSample(x, y, 0, (int)(wrsrc.getSampleDouble(x, y, 0) * c));
                    }
                }
                wrres = null;
                wrbright = null;
                wrdark = null;
                wrsrc = null;
            }
        }
        double average = this.IF.Average(this.imbright);
        ImageArithmetic.Subtract(this.imbright, (int)average, this.imbright, 0, 0);
        average = this.IF.Average(this.imdark);
        ImageArithmetic.Subtract(this.imdark, (int)average, this.imdark, 0, 0);
        maxbright = this.IF.Maximum(this.imbright);
        maxdark = this.IF.Maximum(this.imdark);
        switch (source.getType()) {
            case 10: {
                byte[] bbsrc = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                short[] sbbright = ((DataBufferUShort)this.imbright.getRaster().getDataBuffer()).getData();
                short[] sbdark = ((DataBufferUShort)this.imdark.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int pos = 0; pos < bbsrc.length; ++pos) {
                    if ((sbdark[pos] & 0xFFFF) >= (sbbright[pos] & 0xFFFF)) continue;
                    double c = 1.0 + (double)(sbbright[pos] & 0xFFFF) / maxbright * coefficient;
                    int val = (int)((double)(bbsrc[pos] & 0xFF) * c);
                    if (255 < val) {
                        val = 255;
                    }
                    bbres[pos] = (byte)val;
                }
                bbres = null;
                bbsrc = null;
                sbdark = null;
                sbbright = null;
                break;
            }
            default: {
                WritableRaster wrsrc = source.getRaster();
                WritableRaster wrdark = this.imdark.getRaster();
                WritableRaster wrbright = this.imbright.getRaster();
                WritableRaster wrres = result.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (wrdark.getSample(x, y, 0) >= wrbright.getSample(x, y, 0)) continue;
                        double c = 1.0 + wrbright.getSampleDouble(x, y, 0) / maxbright * coefficient;
                        wrres.setSample(x, y, 0, (int)(wrsrc.getSampleDouble(x, y, 0) * c));
                    }
                }
                wrres = null;
                wrbright = null;
                wrdark = null;
                wrsrc = null;
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        double c;
        int pos;
        byte[] bbres;
        if (!DvTools.areDimensionsAndTypeEqual((DV)source, (DV)result)) {
            throw new IllegalArgumentException("Images must have identical type and dimensions.");
        }
        int width = source.SizeX;
        int height = source.SizeY;
        int depth = source.SizeZ;
        int bex = 0;
        int bey = 0;
        int bez = 0;
        DvNew.Copy((DV)source, (DV)result);
        if (this.gabor.IgnoreBorders()) {
            bex = this.gabor.BorderEffectSizeX();
            bey = this.gabor.BorderEffectSizeY();
            bez = this.gabor.BorderEffectSizeZ();
            DvDrawer.Borders(result, 0, bex, bex, bey, bey, bez, bez);
        }
        if (this.dvbright == null || !DvTools.areDimensionsEqual((DV)source, (DV)this.dvbright)) {
            if (this.dvbright != null) {
                this.dvbright.Kill();
            }
            if (this.dvdark != null) {
                this.dvdark.Kill();
            }
            this.dvbright = null;
            this.dvdark = null;
            this.dvbright = new DV(width, height, depth, 1, 16);
            this.dvdark = new DV(width, height, depth, 1, 16);
        }
        this.gabor.BasicProcessing(false);
        this.gabor.Filter(source, this.dvbright, nbCPU);
        this.invert.Filter(source, source, nbCPU);
        this.gabor.Filter(source, this.dvdark, nbCPU);
        this.invert.Filter(source, source, nbCPU);
        double maxbright = this.DF.Maximum(this.dvbright, 0);
        double maxdark = this.DF.Maximum(this.dvdark, 0);
        switch (source.Type) {
            case 8: {
                byte[] bbsrc = source.getDataBufferByte(0);
                short[] sbbright = this.dvbright.getDataBufferShort(0);
                short[] sbdark = this.dvdark.getDataBufferShort(0);
                bbres = result.getDataBufferByte(0);
                for (pos = 0; pos < bbsrc.length; ++pos) {
                    if ((sbdark[pos] & 0xFFFF) <= (sbbright[pos] & 0xFFFF)) continue;
                    c = 1.0 - (double)(sbdark[pos] & 0xFFFF) / maxdark * this.coefficient;
                    bbres[pos] = (byte)((double)(bbsrc[pos] & 0xFF) * c);
                }
                bbres = null;
                bbsrc = null;
                sbdark = null;
                sbbright = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        if (this.globalaverage) {
            if (this.gabor.IgnoreBorders()) {
                double average = this.DF.Average(this.dvbright, 0, bex, this.dvbright.SizeX - bex, bey, this.dvbright.SizeY - bey, bez, this.dvbright.SizeZ - bez);
                DvArithmetic.Subtract(this.dvbright, (int)average, this.dvbright, 0, 0);
                average = this.DF.Average(this.dvdark, 0, bex, this.dvdark.SizeX - bex, bey, this.dvdark.SizeY - bey, bez, this.dvdark.SizeZ - bez);
                DvArithmetic.Subtract(this.dvdark, (int)average, this.dvdark, 0, 0);
            } else {
                double average = this.DF.Average(this.dvbright, 0);
                DvArithmetic.Subtract(this.dvbright, (int)average, this.dvbright, 0, 0);
                average = this.DF.Average(this.dvdark, 0);
                DvArithmetic.Subtract(this.dvdark, (int)average, this.dvdark, 0, 0);
            }
        } else {
            int pos2;
            int z;
            BufferedImage tmp = new BufferedImage(this.dvbright.SizeX, this.dvbright.SizeY, 11);
            if (this.gabor.IgnoreBorders()) {
                z = bez;
                pos2 = z * this.dvbright.LayerSize;
                while (z < this.dvbright.SizeZ - bez) {
                    DvConverter.DVtoBufferedImage(this.dvbright, 0, z, tmp);
                    double average = this.IF.Average(tmp, bex, tmp.getWidth() - bex, bey, tmp.getHeight() - bey);
                    ImageArithmetic.Subtract(tmp, (int)average, tmp, 0, 0);
                    DvConverter.BufferedImageToDV(tmp, this.dvbright, 0, z);
                    DvConverter.DVtoBufferedImage(this.dvdark, 0, z, tmp);
                    average = this.IF.Average(tmp, bex, tmp.getWidth() - bex, bey, tmp.getHeight() - bey);
                    ImageArithmetic.Subtract(tmp, (int)average, tmp, 0, 0);
                    DvConverter.BufferedImageToDV(tmp, this.dvdark, 0, z);
                    ++z;
                    pos2 += this.dvbright.LayerSize;
                }
            } else {
                z = bez;
                pos2 = z * this.dvbright.LayerSize;
                while (z < this.dvbright.SizeZ - bez) {
                    DvConverter.DVtoBufferedImage(this.dvbright, 0, z, tmp);
                    double average = this.IF.Average(tmp);
                    ImageArithmetic.Subtract(tmp, (int)average, tmp, 0, 0);
                    DvConverter.BufferedImageToDV(tmp, this.dvbright, 0, z);
                    DvConverter.DVtoBufferedImage(this.dvdark, 0, z, tmp);
                    average = this.IF.Average(tmp);
                    ImageArithmetic.Subtract(tmp, (int)average, tmp, 0, 0);
                    DvConverter.BufferedImageToDV(tmp, this.dvdark, 0, z);
                    ++z;
                    pos2 += this.dvbright.LayerSize;
                }
            }
            tmp = null;
        }
        maxbright = this.DF.Maximum(this.dvbright, 0);
        maxdark = this.DF.Maximum(this.dvdark, 0);
        switch (source.Type) {
            case 8: {
                byte[] bbsrc = source.getDataBufferByte(0);
                short[] sbbright = this.dvbright.getDataBufferShort(0);
                short[] sbdark = this.dvdark.getDataBufferShort(0);
                bbres = result.getDataBufferByte(0);
                for (pos = 0; pos < bbsrc.length; ++pos) {
                    if ((sbdark[pos] & 0xFFFF) >= (sbbright[pos] & 0xFFFF)) continue;
                    c = 1.0 + (double)(sbbright[pos] & 0xFFFF) / maxbright * this.coefficient;
                    int val = (int)((double)(bbsrc[pos] & 0xFF) * c);
                    if (255 < val) {
                        val = 255;
                    }
                    bbres[pos] = (byte)val;
                }
                bbres = null;
                bbsrc = null;
                sbdark = null;
                sbbright = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        if (this.gabor.IgnoreBorders()) {
            DvDrawer.Borders(result, 0, bex, bex, bey, bey, bez, bez);
        }
    }

    public BufferedImage[] Filter(BufferedImage[] sources, int maxsize, int nbSubVolumes, int nbCPU) {
        BufferedImage[] results = StackNew.Same(sources);
        this.Filter(sources, maxsize, nbSubVolumes, results, nbCPU);
        return results;
    }

    public void Filter(BufferedImage[] sources, int maxsize, int nbSubVolumes, BufferedImage[] results, int nbCPU) {
        double average;
        double c;
        int pos;
        byte[] bbres;
        short[] sbdark;
        short[] sbbright;
        byte[] bbsrc;
        int i2;
        if (!StackTools.areDimensionsAndTypeEqual(sources, results)) {
            throw new IllegalArgumentException("Images must have identical type and dimensions.");
        }
        if (!Maths.isPowerOf2((int)maxsize)) {
            throw new IllegalArgumentException("The maximum size must be dyadic.");
        }
        int bex = 0;
        int bey = 0;
        int bez = 0;
        StackNew.Copy(sources, results);
        if (this.gabor.IgnoreBorders()) {
            bex = this.gabor.BorderEffectSizeX();
            bey = this.gabor.BorderEffectSizeY();
            bez = this.gabor.BorderEffectSizeZ();
        }
        if (this.stackbright == null || !StackTools.areDimensionsEqual(sources, this.stackbright)) {
            if (this.stackbright != null) {
                Arrays.fill(this.stackbright, null);
            }
            if (this.stackdark != null) {
                Arrays.fill(this.stackdark, null);
            }
            this.stackbright = null;
            this.stackdark = null;
            this.stackbright = StackNew.Same(sources, 11);
            this.stackdark = StackNew.Same(this.stackbright);
        }
        this.gabor.BasicProcessing(false);
        this.gabor.Filter(sources, maxsize, nbSubVolumes, this.stackbright, nbCPU);
        this.invert.Filter(sources, sources, nbCPU);
        this.gabor.Filter(sources, maxsize, nbSubVolumes, this.stackdark, nbCPU);
        this.invert.Filter(sources, sources, nbCPU);
        double maxbright = this.SF.Maximum(this.stackbright);
        double maxdark = this.SF.Maximum(this.stackdark);
        switch (sources[0].getType()) {
            case 10: {
                for (i2 = 0; i2 < sources.length; ++i2) {
                    bbsrc = ((DataBufferByte)sources[i2].getRaster().getDataBuffer()).getData();
                    sbbright = ((DataBufferUShort)this.stackbright[i2].getRaster().getDataBuffer()).getData();
                    sbdark = ((DataBufferUShort)this.stackdark[i2].getRaster().getDataBuffer()).getData();
                    bbres = ((DataBufferByte)results[i2].getRaster().getDataBuffer()).getData();
                    for (pos = 0; pos < bbsrc.length; ++pos) {
                        if ((sbdark[pos] & 0xFFFF) <= (sbbright[pos] & 0xFFFF)) continue;
                        c = 1.0 - (double)(sbdark[pos] & 0xFFFF) / maxdark * this.coefficient;
                        bbres[pos] = (byte)((double)(bbsrc[pos] & 0xFF) * c);
                    }
                    bbres = null;
                    bbsrc = null;
                    sbdark = null;
                    sbbright = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        if (this.globalaverage) {
            if (this.gabor.IgnoreBorders()) {
                average = this.SF.Average(this.stackbright, bex, this.stackbright[0].getWidth() - bex, bey, this.stackbright[0].getHeight() - bey, bez, this.stackbright.length - bey);
                StackArithmetic.Subtract(this.stackbright, (int)average, this.stackbright, 0, 0);
                average = this.SF.Average(this.stackdark, bex, this.stackdark[0].getWidth() - bex, bey, this.stackdark[0].getHeight() - bey, bez, this.stackdark.length - bey);
                StackArithmetic.Subtract(this.stackdark, (int)average, this.stackdark, 0, 0);
            } else {
                average = this.SF.Average(this.stackbright, 0);
                StackArithmetic.Subtract(this.stackbright, (int)average, this.stackbright, 0, 0);
                average = this.SF.Average(this.stackdark, 0);
                StackArithmetic.Subtract(this.stackdark, (int)average, this.stackdark, 0, 0);
            }
        } else if (this.gabor.IgnoreBorders()) {
            for (i2 = bez; i2 < this.stackbright.length - bez; ++i2) {
                average = this.IF.Average(this.stackbright[i2], bex, this.stackbright[0].getWidth() - bex, bey, this.stackbright[0].getHeight() - bey);
                ImageArithmetic.Subtract(this.stackbright[i2], (int)average, this.stackbright[i2], 0, 0);
                average = this.IF.Average(this.stackdark[i2], bex, this.stackdark[0].getWidth() - bex, bey, this.stackdark[0].getHeight() - bey);
                ImageArithmetic.Subtract(this.stackdark[i2], (int)average, this.stackdark[i2], 0, 0);
            }
        } else {
            for (i2 = 0; i2 < this.stackbright.length; ++i2) {
                average = this.IF.Average(this.stackbright[i2]);
                ImageArithmetic.Subtract(this.stackbright[i2], (int)average, this.stackbright[i2], 0, 0);
                average = this.IF.Average(this.stackdark[i2]);
                ImageArithmetic.Subtract(this.stackdark[i2], (int)average, this.stackdark[i2], 0, 0);
            }
        }
        maxbright = this.SF.Maximum(this.stackbright);
        maxdark = this.SF.Maximum(this.stackdark);
        switch (sources[0].getType()) {
            case 10: {
                for (i2 = 0; i2 < sources.length; ++i2) {
                    bbsrc = ((DataBufferByte)sources[i2].getRaster().getDataBuffer()).getData();
                    sbbright = ((DataBufferUShort)this.stackbright[i2].getRaster().getDataBuffer()).getData();
                    sbdark = ((DataBufferUShort)this.stackdark[i2].getRaster().getDataBuffer()).getData();
                    bbres = ((DataBufferByte)results[i2].getRaster().getDataBuffer()).getData();
                    for (pos = 0; pos < bbsrc.length; ++pos) {
                        if ((sbdark[pos] & 0xFFFF) >= (sbbright[pos] & 0xFFFF)) continue;
                        c = 1.0 + (double)(sbbright[pos] & 0xFFFF) / maxbright * this.coefficient;
                        int val = (int)((double)(bbsrc[pos] & 0xFF) * c);
                        if (255 < val) {
                            val = 255;
                        }
                        bbres[pos] = (byte)val;
                    }
                    bbres = null;
                    bbsrc = null;
                    sbdark = null;
                    sbbright = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        if (this.gabor.IgnoreBorders()) {
            StackDrawer.Borders(results, 0, bex, bex, bey, bey, bez, bez);
        }
    }

    public void Filter(File[] sources, int maxsize, int nbSubVolumes, boolean Extreme, String resdir, String prefix, String suffix, String tmpdir, int nbCPU) throws IOException {
        double average;
        BufferedImage imbright;
        BufferedImage imdark;
        BufferedImage imsrc;
        if (!Maths.isPowerOf2((int)maxsize)) {
            throw new IllegalArgumentException("The maximum size must be dyadic.");
        }
        String ext = StringToolsImageDV.FindExtension((String)sources[0].getName());
        File filetmp = new File(tmpdir);
        if (!filetmp.exists()) {
            filetmp.mkdirs();
        }
        int bex = 0;
        int bey = 0;
        int bez = 0;
        if (this.gabor.IgnoreBorders()) {
            bex = this.gabor.BorderEffectSizeX();
            bey = this.gabor.BorderEffectSizeY();
            bez = this.gabor.BorderEffectSizeZ();
        }
        this.gabor.BasicProcessing(false);
        File filebright = new File(tmpdir + "/StructureEnhancer_Bright/");
        if (!filebright.exists()) {
            filebright.mkdirs();
        }
        if (Extreme) {
            this.gabor.FilterExtreme(sources, maxsize, nbSubVolumes, filebright.getAbsolutePath(), "", nbCPU);
        } else {
            this.gabor.Filter(sources, maxsize, nbSubVolumes, filebright.getAbsolutePath(), "", nbCPU);
        }
        File fileinv = new File(tmpdir + "/Inverted/");
        if (!fileinv.exists()) {
            fileinv.mkdirs();
        }
        this.invert.Filter(sources, fileinv.getAbsolutePath());
        Object[] inverted = new File(fileinv.getAbsolutePath()).listFiles(FileNameFilters.ImagesPNG);
        Arrays.sort(inverted);
        fileinv = null;
        File filedark = new File(tmpdir + "/StructureEnhancer_Dark/");
        if (!filedark.exists()) {
            filedark.mkdirs();
        }
        if (Extreme) {
            this.gabor.FilterExtreme((File[])inverted, maxsize, nbSubVolumes, filedark.getAbsolutePath(), "", nbCPU);
        } else {
            this.gabor.Filter((File[])inverted, maxsize, nbSubVolumes, filedark.getAbsolutePath(), "", nbCPU);
        }
        Object[] brights = new File(filebright.getAbsolutePath()).listFiles(FileNameFilters.ImagesPNG);
        Arrays.sort(brights);
        double maxbright = this.SF.Maximum((File[])brights);
        Object[] darks = new File(filedark.getAbsolutePath()).listFiles(FileNameFilters.ImagesPNG);
        Arrays.sort(darks);
        double maxdark = this.SF.Maximum((File[])darks);
        File fileinterres = new File(tmpdir + "/Intermediate_Results/");
        if (!fileinterres.exists()) {
            fileinterres.mkdirs();
        }
        BufferedImage imres = null;
        int Type2 = 10;
        switch (Type2) {
            case 10: {
                for (int i2 = 0; i2 < sources.length; ++i2) {
                    imsrc = ImageIO.Read(sources[i2]);
                    imdark = ImageIO.Read((File)darks[i2]);
                    imbright = ImageIO.Read((File)brights[i2]);
                    if (imres == null) {
                        imres = ImageNew.Same((BufferedImage)imsrc);
                    }
                    byte[] bbsrc = ((DataBufferByte)imsrc.getRaster().getDataBuffer()).getData();
                    short[] sbbright = ((DataBufferUShort)imbright.getRaster().getDataBuffer()).getData();
                    short[] sbdark = ((DataBufferUShort)imdark.getRaster().getDataBuffer()).getData();
                    byte[] bbres = ((DataBufferByte)imres.getRaster().getDataBuffer()).getData();
                    System.arraycopy(bbsrc, 0, bbres, 0, bbres.length);
                    if (this.gabor.IgnoreBorders() && (i2 < bez || sources.length - bez <= i2)) {
                        ImageOperations.Fill((BufferedImage)imres, (int)0);
                    } else {
                        for (int pos = 0; pos < bbsrc.length; ++pos) {
                            if ((sbdark[pos] & 0xFFFF) <= (sbbright[pos] & 0xFFFF)) continue;
                            double c = 1.0 - (double)(sbdark[pos] & 0xFFFF) / maxdark * this.coefficient;
                            bbres[pos] = (byte)((double)(bbsrc[pos] & 0xFF) * c);
                        }
                    }
                    if (this.gabor.IgnoreBorders()) {
                        ImageDrawer.Borders(imres, 0, bex, bex, bey, bey);
                    }
                    ImageIO.Write(imres, fileinterres.getAbsolutePath() + "/" + sources[i2].getName().replace(ext, "png"), 6);
                    bbres = null;
                    bbsrc = null;
                    sbdark = null;
                    sbbright = null;
                    imdark = null;
                    imbright = null;
                    imsrc = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        imres = null;
        File filebrightnew = new File(tmpdir + "/StructureEnhancer_Bright_New/");
        if (!filebrightnew.exists()) {
            filebrightnew.mkdirs();
        }
        this.stackbright = StackIO.ReadImageSequence((File[])brights);
        if (this.globalaverage) {
            if (this.gabor.IgnoreBorders()) {
                average = this.SF.Average(this.stackbright, bex, this.stackbright[0].getWidth() - bex, bey, this.stackbright[0].getHeight() - bey, bez, this.stackbright.length - bez);
                StackArithmetic.Subtract(this.stackbright, (int)average, this.stackbright, 0, 0);
            } else {
                average = this.SF.Average(this.stackbright, 0);
                StackArithmetic.Subtract(this.stackbright, (int)average, this.stackbright, 0, 0);
            }
        } else if (this.gabor.IgnoreBorders()) {
            for (int i3 = bez; i3 < this.stackbright.length - bez; ++i3) {
                average = this.IF.Average(this.stackbright[i3], bex, this.stackbright[0].getWidth() - bex, bey, this.stackbright[0].getHeight() - bey);
                ImageArithmetic.Subtract(this.stackbright[i3], (int)average, this.stackbright[i3], 0, 0);
            }
        } else {
            for (BufferedImage stackbright1 : this.stackbright) {
                average = this.IF.Average(stackbright1);
                ImageArithmetic.Subtract(stackbright1, (int)average, stackbright1, 0, 0);
            }
        }
        maxbright = this.SF.Maximum(this.stackbright);
        StackIO.WriteImageSequence(this.stackbright, (File[])brights, filebrightnew.getAbsolutePath(), "", 6);
        for (int i4 = 0; i4 < this.stackbright.length; ++i4) {
            this.stackbright[i4] = null;
        }
        this.stackbright = null;
        System.gc();
        File filedarknew = new File(tmpdir + "/StructureEnhancer_Dark_New/");
        if (!filedarknew.exists()) {
            filedarknew.mkdirs();
        }
        this.stackdark = StackIO.ReadImageSequence((File[])darks);
        if (this.globalaverage) {
            if (this.gabor.IgnoreBorders()) {
                average = this.SF.Average(this.stackdark, bex, this.stackdark[0].getWidth() - bex, bey, this.stackdark[0].getHeight() - bey, bez, this.stackdark.length - bey);
                StackArithmetic.Subtract(this.stackdark, (int)average, this.stackdark, 0, 0);
            } else {
                average = this.SF.Average(this.stackdark, 0);
                StackArithmetic.Subtract(this.stackdark, (int)average, this.stackdark, 0, 0);
            }
        } else if (this.gabor.IgnoreBorders()) {
            for (int i5 = bez; i5 < this.stackdark.length - bez; ++i5) {
                average = this.IF.Average(this.stackdark[i5], bex, this.stackdark[0].getWidth() - bex, bey, this.stackdark[0].getHeight() - bey);
                ImageArithmetic.Subtract(this.stackdark[i5], (int)average, this.stackdark[i5], 0, 0);
            }
        } else {
            for (BufferedImage stackdark1 : this.stackdark) {
                average = this.IF.Average(stackdark1);
                ImageArithmetic.Subtract(stackdark1, (int)average, stackdark1, 0, 0);
            }
        }
        maxdark = this.SF.Maximum(this.stackdark);
        StackIO.WriteImageSequence(this.stackdark, (File[])darks, filedarknew.getAbsolutePath(), "", 6);
        for (int i6 = 0; i6 < this.stackdark.length; ++i6) {
            this.stackdark[i6] = null;
        }
        this.stackdark = null;
        System.gc();
        Object[] stackbrightnew = new File(filebrightnew.getAbsolutePath()).listFiles(FileNameFilters.ImagesPNG);
        Object[] stackdarknew = new File(filedarknew.getAbsolutePath()).listFiles(FileNameFilters.ImagesPNG);
        Object[] fileres = new File(fileinterres.getAbsolutePath()).listFiles(FileNameFilters.ImagesPNG);
        Arrays.sort(stackbrightnew);
        Arrays.sort(stackdarknew);
        Arrays.sort(fileres);
        switch (Type2) {
            case 10: {
                for (int i7 = 0; i7 < sources.length; ++i7) {
                    imsrc = ImageIO.Read(sources[i7]);
                    imdark = ImageIO.Read((File)stackdarknew[i7]);
                    imbright = ImageIO.Read((File)stackbrightnew[i7]);
                    imres = ImageIO.Read((File)fileres[i7]);
                    byte[] bbsrc = ((DataBufferByte)imsrc.getRaster().getDataBuffer()).getData();
                    short[] sbbright = ((DataBufferUShort)imbright.getRaster().getDataBuffer()).getData();
                    short[] sbdark = ((DataBufferUShort)imdark.getRaster().getDataBuffer()).getData();
                    byte[] bbres = ((DataBufferByte)imres.getRaster().getDataBuffer()).getData();
                    if (this.gabor.IgnoreBorders() && (i7 < bez || sources.length - bez <= i7)) {
                        ImageOperations.Fill((BufferedImage)imres, (int)0);
                    } else {
                        for (int pos = 0; pos < bbsrc.length; ++pos) {
                            if ((sbdark[pos] & 0xFFFF) >= (sbbright[pos] & 0xFFFF)) continue;
                            double c = 1.0 + (double)(sbbright[pos] & 0xFFFF) / maxbright * this.coefficient;
                            int val = (int)((double)(bbsrc[pos] & 0xFF) * c);
                            if (255 < val) {
                                val = 255;
                            }
                            bbres[pos] = (byte)val;
                        }
                    }
                    if (this.gabor.IgnoreBorders()) {
                        ImageDrawer.Borders(imres, 0, bex, bex, bey, bey);
                    }
                    ImageIO.Write(imres, resdir + "/" + prefix + sources[i7].getName().replace("." + ext, suffix + ".png"), 6);
                    imres = null;
                    imbright = null;
                    imdark = null;
                    imsrc = null;
                    bbres = null;
                    bbsrc = null;
                    sbdark = null;
                    sbbright = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        FilesFolders.Delete(new File(tmpdir));
        Arrays.fill(darks, null);
        Arrays.fill(brights, null);
        Arrays.fill(inverted, null);
        inverted = null;
        brights = null;
        darks = null;
    }

    public void Parameters(Object ... parameters) {
        this.gabor.Parameters(parameters);
    }

    public List<Object> Parameters() {
        return this.gabor.Parameters();
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public StructureEnhancer Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    public void Coefficient(double coefficient) {
        if (coefficient <= 0.0 || 1.0 < coefficient) {
            throw new IllegalArgumentException("The coefficient must be into the range ]0, 1].");
        }
        this.coefficient = coefficient;
    }

    public double Coefficient() {
        return this.coefficient;
    }

    public void GlobalAverage(boolean value) {
        this.globalaverage = value;
    }

    public boolean GlobalAverage() {
        return this.globalaverage;
    }
}

