/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import dv.DvNew;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.ArrayList;
import java.util.List;
import processing.filters.SignalFilter;

public class SignalFilterTest
implements SignalFilter {
    public int BorderEffectX = 11;
    public int BorderEffectY = 13;
    public int BorderEffectZ = 17;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source, (int)nbCPU);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        int length = source.getWidth() * source.getHeight();
        switch (source.getRaster().getDataBuffer().getDataType()) {
            case 0: {
                System.arraycopy(((DataBufferByte)source.getRaster().getDataBuffer()).getData(), 0, ((DataBufferByte)source.getRaster().getDataBuffer()).getData(), 0, length);
                break;
            }
            case 2: {
                System.arraycopy(((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), 0, ((DataBufferUShort)source.getRaster().getDataBuffer()).getData(), 0, length);
                break;
            }
            case 3: {
                System.arraycopy(((DataBufferInt)source.getRaster().getDataBuffer()).getData(), 0, ((DataBufferInt)source.getRaster().getDataBuffer()).getData(), 0, length);
                break;
            }
            case 4: {
                System.arraycopy(((DataBufferFloat)source.getRaster().getDataBuffer()).getData(), 0, ((DataBufferFloat)source.getRaster().getDataBuffer()).getData(), 0, length);
                break;
            }
            case 5: {
                System.arraycopy(((DataBufferDouble)source.getRaster().getDataBuffer()).getData(), 0, ((DataBufferDouble)source.getRaster().getDataBuffer()).getData(), 0, length);
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source, (int)nbCPU);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        switch (source.Type) {
            case 8: {
                for (int c = 0; c < source.Channel; ++c) {
                    System.arraycopy(source.getDataBufferByte(c), 0, result.getDataBufferByte(c), 0, source.Length);
                }
                break;
            }
            case 16: {
                for (int c = 0; c < source.Channel; ++c) {
                    System.arraycopy(source.getDataBufferShort(c), 0, result.getDataBufferShort(c), 0, source.Length);
                }
                break;
            }
            case 32: {
                for (int c = 0; c < source.Channel; ++c) {
                    System.arraycopy(source.getDataBufferInt(c), 0, result.getDataBufferInt(c), 0, source.Length);
                }
                break;
            }
            case -32: {
                for (int c = 0; c < source.Channel; ++c) {
                    System.arraycopy(source.getDataBufferFloat(c), 0, result.getDataBufferFloat(c), 0, source.Length);
                }
                break;
            }
            case 64: {
                for (int c = 0; c < source.Channel; ++c) {
                    System.arraycopy(source.getDataBufferDouble(c), 0, result.getDataBufferDouble(c), 0, source.Length);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public int BorderEffectSizeX() {
        return this.BorderEffectX;
    }

    public int BorderEffectSizeY() {
        return this.BorderEffectY;
    }

    public int BorderEffectSizeZ() {
        return this.BorderEffectZ;
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        return new ArrayList<Object>(1);
    }

    public SignalFilter Clone() {
        SignalFilterTest clone = new SignalFilterTest();
        clone.BorderEffectX = this.BorderEffectX;
        clone.BorderEffectY = this.BorderEffectY;
        clone.BorderEffectZ = this.BorderEffectZ;
        return clone;
    }
}

