/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.List;
import processing.filters.SignalFilter;

public class Sepia
implements SignalFilter {
    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage sepia, int nbCPU) {
        if (!ImageTools.isColored((BufferedImage)source)) {
            throw new IllegalArgumentException("Colored image required.");
        }
        if (!ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)sepia)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions.");
        }
        int w = source.getWidth();
        int h = source.getHeight();
        WritableRaster raster = source.getRaster();
        int[] pixels = new int[w * h * 3];
        raster.getPixels(0, 0, w, h, pixels);
        for (int i2 = 0; i2 < pixels.length; i2 += 3) {
            int r = pixels[i2];
            int g = pixels[i2 + 1];
            int b = pixels[i2 + 2];
            int R = (r * 100 >> 8) + (g * 196 >> 8) + (b * 48 >> 8);
            R = R > 255 ? 255 : R;
            int G = (r * 89 >> 8) + (g * 175 >> 8) + (b * 43 >> 8);
            G = G > 255 ? 255 : G;
            int B = (r * 69 >> 8) + (g * 136 >> 8) + (b * 33 >> 8);
            B = B > 255 ? 255 : B;
            pixels[i2] = R;
            pixels[i2 + 1] = G;
            pixels[i2 + 2] = B;
        }
        sepia.getRaster().setPixels(0, 0, w, h, (int[])pixels.clone());
        pixels = null;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        return null;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

