/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.List;
import processing.filters.SignalFilter;

public class SelectedFlow
implements SignalFilter {
    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (!ImageTools.isGrayLevel((BufferedImage)source)) {
            throw new IllegalArgumentException("Only gray level image supported.");
        }
        int largeur = source.getWidth();
        int hauteur = source.getHeight();
        double[][] filter = new double[3][3];
        WritableRaster wr = source.getRaster();
        WritableRaster wrr = result.getRaster();
        for (int vy = 0; vy < hauteur; ++vy) {
            for (int vx = 0; vx < largeur; ++vx) {
                double res;
                int vpix;
                int i2;
                int j;
                double filter_sum = 0.0;
                int cpix = wr.getSample(vx, vy, 0);
                for (j = 0; j < 3; ++j) {
                    for (i2 = 0; i2 < 3; ++i2) {
                        if (j == 1 && i2 == 1) {
                            filter[1][1] = 0.5;
                        } else {
                            vpix = ImageTools.PixelMiror((WritableRaster)wr, (int)(vx - 1 + i2), (int)(vy - 1 + j), (int)0);
                            res = cpix - vpix;
                            if (res < 0.0) {
                                res = -res;
                            }
                            filter[j][i2] = res != 0.0 ? 1.0 / res : 1.0;
                        }
                        filter_sum += filter[j][i2];
                    }
                }
                if (filter_sum != 0.0) {
                    for (j = 0; j < 3; ++j) {
                        i2 = 0;
                        while (i2 < 3) {
                            double[] dArray = filter[j];
                            int n = i2++;
                            dArray[n] = dArray[n] / filter_sum;
                        }
                    }
                }
                res = 0.0;
                for (j = 0; j < 3; ++j) {
                    for (i2 = 0; i2 < 3; ++i2) {
                        vpix = ImageTools.PixelMiror((WritableRaster)wr, (int)(vx - 1 + i2), (int)(vy - 1 + j), (int)0);
                        res += (double)vpix * filter[j][i2];
                    }
                }
                res = (res += 0.5) > 255.0 ? 255.0 : (res < 0.0 ? 0.0 : res);
                wrr.setSample(vx, vy, 0, (int)res);
            }
        }
        filter = null;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        return null;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

