/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class PeronaMalik {
    private double Lambda = 0.25;
    private double dt = 1.0;
    private int Iterations = 10;
    private boolean EightConnex = true;

    public BufferedImage Filter(BufferedImage in, double Lambda, double dt, int Iterations, boolean EightConnex) {
        if (Lambda < 0.0) {
            throw new IllegalArgumentException("Lambda < 0.0.");
        }
        if (dt < 0.0) {
            throw new IllegalArgumentException("dt < 0.0.");
        }
        if (Iterations <= 0) {
            throw new IllegalArgumentException("Iterations < 1.");
        }
        this.Lambda = Lambda;
        this.dt = dt;
        this.Iterations = Iterations;
        this.EightConnex = EightConnex;
        return this.Filter(in);
    }

    public BufferedImage Filter(BufferedImage in) {
        BufferedImage out = ImageNew.Clone((BufferedImage)in);
        BufferedImage itempo = ImageNew.Clone((BufferedImage)in);
        WritableRaster wro = out.getRaster();
        WritableRaster writ = itempo.getRaster();
        switch (in.getType()) {
            case 10: 
            case 11: 
            case 12: {
                for (int n = 0; n < this.Iterations; ++n) {
                    for (int j = 0; j < in.getHeight(); ++j) {
                        for (int i2 = 0; i2 < in.getWidth(); ++i2) {
                            int value = (int)(this.dt * this.ComputeFlow(out, i2, j, 0) + wro.getSampleDouble(i2, j, 0) + 0.5);
                            writ.setSample(i2, j, 0, value);
                        }
                    }
                    ImageNew.Copy((BufferedImage)itempo, (BufferedImage)out);
                }
                break;
            }
            case 5: {
                for (int n = 0; n < this.Iterations; ++n) {
                    for (int canal = 0; canal < 3; ++canal) {
                        for (int j = 0; j < in.getHeight(); ++j) {
                            for (int i3 = 0; i3 < in.getWidth(); ++i3) {
                                int value = (int)(this.dt * this.ComputeFlow(out, i3, j, canal) + wro.getSampleDouble(i3, j, canal) + 0.5);
                                writ.setSample(i3, j, canal, value);
                            }
                        }
                    }
                    ImageNew.Copy((BufferedImage)itempo, (BufferedImage)out);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: image type not supported.");
            }
        }
        wro = null;
        writ = null;
        return out;
    }

    private double ComputeFlow(BufferedImage image, int x, int y, int canal) {
        if (this.EightConnex) {
            return this.ComputeFlow8(image, x, y, canal);
        }
        return this.ComputeFlow4(image, x, y, canal);
    }

    private double ComputeFlow4(BufferedImage image, int x, int y, int canal) {
        WritableRaster wr = image.getRaster();
        double current = wr.getSampleDouble(x, y, canal);
        int width = image.getWidth();
        int height = image.getHeight();
        int px = x - 1;
        int nx = x + 1;
        int py = y - 1;
        int ny = y + 1;
        if (px < 0) {
            px = 0;
        }
        if (nx >= width) {
            nx = width - 1;
        }
        if (py < 0) {
            py = 0;
        }
        if (ny >= height) {
            ny = height - 1;
        }
        double ixp = wr.getSampleDouble(px, y, canal);
        double ixn = wr.getSampleDouble(nx, y, canal);
        double iyp = wr.getSampleDouble(x, ny, canal);
        double iyn = wr.getSampleDouble(x, py, canal);
        double diffxn = this.ComputeDiffusion(current - ixn);
        double diffxp = this.ComputeDiffusion(current - ixp);
        double diffyn = this.ComputeDiffusion(current - iyn);
        double diffyp = this.ComputeDiffusion(current - ixp);
        wr = null;
        return diffxn * (ixn - current) + diffxp * (ixp - current) + diffyp * (iyp - current) + diffyn * (iyn - current);
    }

    private double ComputeFlow8(BufferedImage image, int x, int y, int canal) {
        WritableRaster wr = image.getRaster();
        double current = wr.getSampleDouble(x, y, canal);
        int width = image.getWidth();
        int height = image.getHeight();
        int px = x - 1;
        int nx = x + 1;
        int py = y - 1;
        int ny = y + 1;
        if (px < 0) {
            px = 0;
        }
        if (nx >= width) {
            nx = width - 1;
        }
        if (py < 0) {
            py = 0;
        }
        if (ny >= height) {
            ny = height - 1;
        }
        double ixp = wr.getSampleDouble(px, y, canal);
        double ixn = wr.getSampleDouble(nx, y, canal);
        double iyp = wr.getSampleDouble(x, ny, canal);
        double iyn = wr.getSampleDouble(x, py, canal);
        double diffxn = this.ComputeDiffusion(current - ixn);
        double diffxp = this.ComputeDiffusion(current - ixp);
        double diffyn = this.ComputeDiffusion(current - iyn);
        double diffyp = this.ComputeDiffusion(current - ixp);
        double iNE = wr.getSampleDouble(nx, py, canal);
        double iSW = wr.getSampleDouble(px, ny, canal);
        double iNW = wr.getSampleDouble(px, py, canal);
        double iSE = wr.getSampleDouble(nx, ny, canal);
        double diffNE = this.ComputeDiffusion(current - iNE);
        double diffSW = this.ComputeDiffusion(current - iSW);
        double diffNW = this.ComputeDiffusion(current - iNW);
        double diffSE = this.ComputeDiffusion(current - iSE);
        wr = null;
        return diffxn * (ixn - current) + diffxp * (ixp - current) + diffyp * (iyp - current) + diffyn * (iyn - current) + 0.5 * (diffNE * (iNE - current) + diffSW * (iSW - current) + diffSE * (iSE - current) + diffNW * (iNW - current));
    }

    private double ComputeDiffusion(double v) {
        double Lambda2 = Math.pow(this.Lambda, 2.0);
        return Lambda2 / (Lambda2 + Math.pow(v, 2.0));
    }

    public void Mask(double[][] mask) {
    }

    public double[][] Mask() {
        return null;
    }

    public void Parameters(String parameters) throws IOException {
    }

    public String Parameters() {
        return null;
    }

    public double getDt() {
        return this.dt;
    }

    public double getLambda() {
        return this.Lambda;
    }

    public int getIterations() {
        return this.Iterations;
    }
}

