/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import arrayTiTi.ArrayArithmetic;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.util.List;
import processing.filters.SignalFilter;

public class Opposite
implements SignalFilter {
    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions and types.");
        }
        block0 : switch (source.getType()) {
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        ArrayArithmetic.Opposite((double[])((DataBufferDouble)source.getRaster().getDataBuffer()).getData(), (double[])((DataBufferDouble)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 4: {
                        ArrayArithmetic.Opposite((float[])((DataBufferFloat)source.getRaster().getDataBuffer()).getData(), (float[])((DataBufferFloat)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 3: {
                        ArrayArithmetic.Opposite((int[])((DataBufferInt)source.getRaster().getDataBuffer()).getData(), (int[])((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("BufferedImage type not supported (yet).");
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        if (!DvTools.areDimensionsAndTypeEqual((DV)source, (DV)result)) {
            throw new IllegalArgumentException("DV source and result must have identic dimensions and types.");
        }
        switch (source.Type) {
            case 64: {
                for (int c = 0; c < source.Channel; ++c) {
                    ArrayArithmetic.Opposite((double[])source.getDataBufferDouble(c), (double[])result.getDataBufferDouble(c));
                }
                break;
            }
            case -32: {
                for (int c = 0; c < source.Channel; ++c) {
                    ArrayArithmetic.Opposite((float[])source.getDataBufferFloat(c), (float[])result.getDataBufferFloat(c));
                }
                break;
            }
            case 32: {
                for (int c = 0; c < source.Channel; ++c) {
                    ArrayArithmetic.Opposite((int[])source.getDataBufferInt(c), (int[])result.getDataBufferInt(c));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
        }
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        return null;
    }

    public int BorderEffectSizeX() {
        return 0;
    }

    public int BorderEffectSizeY() {
        return 0;
    }

    public int BorderEffectSizeZ() {
        return 0;
    }

    public SignalFilter Clone() {
        return new Opposite();
    }
}

