/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import processing.filters.SignalFilter;

public class MedianRelax
implements SignalFilter {
    protected final int W_MAX = 3;
    protected int L_opt = -1;
    protected int U_opt = -1;
    protected int Size = -1;
    protected int Iterations = -1;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        int u;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions and types.");
        }
        BufferedImage srcopie = ImageNew.Clone((BufferedImage)source);
        int m = 2 * this.Size * (this.Size + 1);
        int l = this.L_opt == -1 ? m - 1 : this.L_opt;
        int n = u = this.U_opt == -1 ? m + 1 : this.U_opt;
        if (l > m || m > u) {
            throw new Error("l <= m <= u is required!");
        }
        if (this.Iterations <= 0) {
            throw new Error("nbIter must be positive!");
        }
        for (int i2 = 0; i2 < this.Iterations; ++i2) {
            this.rmedian_iter(srcopie, result, l, u, this.Size);
            ImageNew.Copy((BufferedImage)result, (BufferedImage)srcopie);
        }
        srcopie = null;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    protected void SWAP(int a, int b, int t) {
        t = a;
        a = b;
        b = t;
    }

    protected void ssort(int[] d, int n) {
        int t = 0;
        for (int i2 = n - 1; i2 > 0; --i2) {
            int k = i2;
            for (int j = 0; j < i2; ++j) {
                if (d[j] <= d[k]) continue;
                k = j;
            }
            if (k == i2) continue;
            this.SWAP(d[i2], d[k], t);
        }
    }

    protected void rmedian_iter(BufferedImage src, BufferedImage dest, int l, int u, int w) {
        int[] t = new int[49];
        WritableRaster wrs = src.getRaster();
        WritableRaster wrd = dest.getRaster();
        int n = (2 * w + 1) * (2 * w + 1);
        int m = 2 * w * (w + 1);
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int g = wrs.getSample(x, y, 0);
                if (x - w < 0 || x + w >= width || y - w < 0 || y + w >= height) {
                    wrd.setSample(x, y, 0, g);
                    continue;
                }
                int i2 = 0;
                for (int wy = -w; wy <= w; ++wy) {
                    for (int wx = -w; wx <= w; ++wx) {
                        t[i2++] = wrs.getSample(x + wx, y + wy, 0);
                    }
                }
                this.ssort(t, n);
                if (g >= t[l] && g <= t[u]) {
                    wrd.setSample(x, y, 0, g);
                    continue;
                }
                wrd.setSample(x, y, 0, t[m]);
            }
        }
        wrs = null;
        wrd = null;
    }

    public void Parameters(int l_opt, int u_opt, int taille, int nbIter) {
        this.L_opt = l_opt;
        this.U_opt = u_opt;
        this.Size = taille;
        this.Iterations = nbIter;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 4) {
            throw new IllegalArgumentException("Exactly 4 parameter required.");
        }
        this.L_opt = (Integer)parameters[0];
        this.U_opt = (Integer)parameters[1];
        this.Size = (Integer)parameters[2];
        this.Iterations = (Integer)parameters[3];
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(4);
        params.add(this.L_opt);
        params.add(this.U_opt);
        params.add(this.Size);
        params.add(this.Iterations);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

