/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.metrics.Euclidian;
import processing.filters.SignalFilter;

public class MedianOld
implements SignalFilter {
    private int Order = -1;
    private boolean square = true;
    private boolean[][] circular = null;
    private int ForbiddenValue = -1;
    private MedianThread[] threads = null;
    private int nbFreeThreads = 0;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        this.Filter(source, result, nbCPU);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        Object object;
        int i2;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions and types.");
        }
        if (this.Order < 0) {
            throw new IllegalArgumentException("Order not specified (use method Parameters).");
        }
        int width = source.getWidth();
        int height = source.getHeight();
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new MedianThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new MedianThread();
                this.threads[i2].start();
            }
            MedianOld medianOld = this;
            synchronized (medianOld) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        int step = height / nbCPU;
        for (i2 = 0; i2 < nbCPU - 1; ++i2) {
            this.threads[i2].setConditions(source, result, this.Order, this.square, 0, i2 * step, width, (i2 + 1) * step);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(source, result, this.Order, this.square, 0, i2 * step, width, height);
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 3) {
            throw new IllegalArgumentException("Exactly 3 parameters required.");
        }
        this.Order = (Integer)parameters[0];
        this.square = (Boolean)parameters[1];
        this.ForbiddenValue = (Integer)parameters[2];
        if (!this.square) {
            Euclidian metric = new Euclidian();
            double epsilon = 0.001;
            int size = 2 * this.Order + 1;
            this.circular = new boolean[size][size];
            for (int k = 0; k < size; ++k) {
                for (int l = 0; l < size; ++l) {
                    this.circular[k][l] = metric.Distance((double)k, (double)l, 0.0, (double)this.Order, (double)this.Order, 0.0) < (double)this.Order + epsilon;
                }
            }
            Object var2_2 = null;
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(this.Order);
        params.add(this.square);
        params.add(this.ForbiddenValue);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    private class MedianThread
    extends Thread {
        private int order;
        private boolean square;
        private int minx;
        private int maxx;
        private int miny;
        private int maxy;
        private int width;
        private int height;
        private int type;
        private int channel;
        private WritableRaster wr = null;
        private WritableRaster wrr = null;
        private short[] shortbufferin = null;
        private short[] shortbufferout = null;
        private byte[] bytebufferin = null;
        private byte[] bytebufferout = null;
        private int[] buffer = null;
        public Object lock = new Object();

        public void setConditions(BufferedImage Original, BufferedImage Result, int order, boolean square, int minx, int miny, int maxx, int maxy) {
            this.order = order;
            this.square = square;
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
            this.width = Original.getWidth();
            this.height = Original.getHeight();
            this.type = Original.getType();
            switch (Original.getType()) {
                case 1: 
                case 2: 
                case 4: 
                case 12: {
                    this.wr = Original.getRaster();
                    this.wrr = Result.getRaster();
                    break;
                }
                case 5: 
                case 6: 
                case 10: {
                    this.bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                    this.bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                    this.channel = Original.getRaster().getNumBands();
                    break;
                }
                case 11: {
                    this.shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                    this.shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type.");
                }
            }
            if (this.buffer == null || this.buffer.length != (2 * order + 1) * (2 * order + 1)) {
                this.buffer = new int[(2 * MedianOld.this.Order + 1) * (2 * MedianOld.this.Order + 1)];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block11: while (true) {
                var14_14 = this.lock;
                synchronized (var14_14) {
                    try {
                        MedianOld.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                MinX = this.minx < this.order ? this.order : this.minx;
                MinY = this.miny < this.order ? this.order : this.miny;
                MaxX = this.maxx >= this.width - this.order ? this.width - this.order : this.maxx;
                MaxY = this.maxy >= this.height - this.order ? this.height - this.order : this.maxy;
                switch (this.type) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 12: {
                        if (this.square) {
                            for (c = 0; c < this.channel; ++c) {
                                for (y = MinY; y < MaxY; ++y) {
                                    for (x = MinX; x < MaxX; ++x) {
                                        n = 0;
                                        for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                            for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                                this.buffer[n++] = this.wr.getSample(x + k, y + l, c);
                                            }
                                        }
                                        Arrays.sort(this.buffer, 0, n);
                                        this.wrr.setSample(x, y, c, this.buffer[n / 2]);
                                    }
                                }
                            }
                            c = 0;
                            while (true) {
                                if (c >= this.channel) continue block11;
                                for (y = 0; y < this.height; ++y) {
                                    for (x = 0; x < this.width; ++x) {
                                        if (x >= MinX && MaxX > x && y >= MinY && MaxY > y) continue;
                                        n = 0;
                                        for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                            for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                                if (0 > x + k || x + k >= this.width || 0 > y + l || y + l >= this.height) continue;
                                                this.buffer[n++] = this.wr.getSample(x + k, y + l, c);
                                            }
                                        }
                                        Arrays.sort(this.buffer, 0, n);
                                        this.wrr.setSample(x, y, c, this.buffer[n / 2]);
                                    }
                                }
                                ++c;
                            }
                        }
                        for (c = 0; c < this.channel; ++c) {
                            for (y = MinY; y < MaxY; ++y) {
                                for (x = MinX; x < MaxX; ++x) {
                                    n = 0;
                                    for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                        for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                            if (!MedianOld.this.circular[MedianOld.this.Order + k][MedianOld.this.Order + l]) continue;
                                            this.buffer[n++] = this.wr.getSample(x + k, y + l, c);
                                        }
                                    }
                                    Arrays.sort(this.buffer, 0, n);
                                    this.wrr.setSample(x, y, c, this.buffer[n / 2]);
                                }
                            }
                        }
                        c = 0;
                        while (true) {
                            if (c >= this.channel) continue block11;
                            for (y = 0; y < this.height; ++y) {
                                for (x = 0; x < this.width; ++x) {
                                    if (x >= MinX && MaxX > x && y >= MinY && MaxY > y) continue;
                                    n = 0;
                                    for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                        for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                            if (!MedianOld.this.circular[MedianOld.this.Order + k][MedianOld.this.Order + l] || 0 > x + k || x + k >= this.width || 0 > y + l || y + l >= this.height) continue;
                                            this.buffer[n++] = this.wr.getSample(x + k, y + l, c);
                                        }
                                    }
                                    Arrays.sort(this.buffer, 0, n);
                                    this.wrr.setSample(x, y, c, this.buffer[n / 2]);
                                }
                            }
                            ++c;
                        }
                    }
                    case 5: 
                    case 6: {
                        widthchannel = this.width * this.channel;
                        if (this.square) {
                            for (c = 0; c < this.channel; ++c) {
                                y = MinY;
                                posori = MinY * widthchannel + c;
                                while (y < MaxY) {
                                    x = MinX;
                                    pos = posori + MinX * this.channel;
                                    while (x < MaxX) {
                                        n = 0;
                                        for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                            for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                                this.buffer[n++] = this.bytebufferin[pos + l * widthchannel + k * this.channel] & 255;
                                            }
                                        }
                                        Arrays.sort(this.buffer, 0, n);
                                        this.bytebufferout[pos] = (byte)this.buffer[n / 2];
                                        ++x;
                                        pos += this.channel;
                                    }
                                    ++y;
                                    posori += widthchannel;
                                }
                            }
                            c = 0;
                            while (true) {
                                if (c >= this.channel) continue block11;
                                for (y = 0; y < this.height; ++y) {
                                    for (x = 0; x < this.width; ++x) {
                                        if (x >= MinX && MaxX > x && y >= MinY && MaxY > y) continue;
                                        pos = y * widthchannel + x * this.channel + c;
                                        n = 0;
                                        for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                            for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                                if (0 > x + k || x + k >= this.width || 0 > y + l || y + l >= this.height) continue;
                                                this.buffer[n++] = this.bytebufferin[pos + l * widthchannel + k * this.channel] & 255;
                                            }
                                        }
                                        Arrays.sort(this.buffer, 0, n);
                                        this.bytebufferout[pos] = (byte)this.buffer[n / 2];
                                    }
                                }
                                ++c;
                            }
                        }
                        for (c = 0; c < this.channel; ++c) {
                            y = MinY;
                            posori = MinY * widthchannel + c;
                            while (y < MaxY) {
                                x = MinX;
                                pos = posori + MinX * this.channel;
                                while (x < MaxX) {
                                    n = 0;
                                    for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                        for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                            if (!MedianOld.this.circular[MedianOld.this.Order + k][MedianOld.this.Order + l]) continue;
                                            this.buffer[n++] = this.bytebufferin[pos + l * widthchannel + k * this.channel] & 255;
                                        }
                                    }
                                    Arrays.sort(this.buffer, 0, n);
                                    this.bytebufferout[pos] = (byte)this.buffer[n / 2];
                                    ++x;
                                    pos += this.channel;
                                }
                                ++y;
                                posori += widthchannel;
                            }
                        }
                        c = 0;
                        while (true) {
                            if (c >= this.channel) continue block11;
                            for (y = 0; y < this.height; ++y) {
                                for (x = 0; x < this.width; ++x) {
                                    if (x >= MinX && MaxX > x && y >= MinY && MaxY > y) continue;
                                    pos = y * widthchannel + x * this.channel + c;
                                    n = 0;
                                    for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                        for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                            if (!MedianOld.this.circular[MedianOld.this.Order + k][MedianOld.this.Order + l] || 0 > x + k || x + k >= this.width || 0 > y + l || y + l >= this.height) continue;
                                            this.buffer[n++] = this.bytebufferin[pos + l * widthchannel + k * this.channel] & 255;
                                        }
                                    }
                                    Arrays.sort(this.buffer, 0, n);
                                    this.bytebufferout[pos] = (byte)this.buffer[n / 2];
                                }
                            }
                            ++c;
                        }
                    }
                    case 10: {
                        if (MedianOld.this.ForbiddenValue < 0) {
                            if (this.square) {
                                y = MinY;
                                posori = MinY * this.width;
                                while (y < MaxY) {
                                    x = MinX;
                                    pos = posori + MinX;
                                    while (x < MaxX) {
                                        n = 0;
                                        for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                            for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                                this.buffer[n++] = this.bytebufferin[pos + l * this.width + k] & 255;
                                            }
                                        }
                                        Arrays.sort(this.buffer, 0, n);
                                        this.bytebufferout[pos] = (byte)this.buffer[n / 2];
                                        ++x;
                                        ++pos;
                                    }
                                    ++y;
                                    posori += this.width;
                                }
                                y = 0;
                                while (true) {
                                    if (y >= this.height) continue block11;
                                    for (x = 0; x < this.width; ++x) {
                                        if (x >= MinX && MaxX > x && y >= MinY && MaxY > y) continue;
                                        pos = y * this.width + x;
                                        n = 0;
                                        for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                            for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                                if (0 > x + k || x + k >= this.width || 0 > y + l || y + l >= this.height) continue;
                                                this.buffer[n++] = this.bytebufferin[pos + l * this.width + k] & 255;
                                            }
                                        }
                                        Arrays.sort(this.buffer, 0, n);
                                        this.bytebufferout[pos] = (byte)this.buffer[n / 2];
                                    }
                                    ++y;
                                }
                            }
                            y = MinY;
                            posori = MinY * this.width;
                            while (y < MaxY) {
                                x = MinX;
                                pos = posori + MinX;
                                while (x < MaxX) {
                                    n = 0;
                                    for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                        for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                            if (!MedianOld.this.circular[MedianOld.this.Order + k][MedianOld.this.Order + l]) continue;
                                            this.buffer[n++] = this.bytebufferin[pos + l * this.width + k] & 255;
                                        }
                                    }
                                    Arrays.sort(this.buffer, 0, n);
                                    this.bytebufferout[pos] = (byte)this.buffer[n / 2];
                                    ++x;
                                    ++pos;
                                }
                                ++y;
                                posori += this.width;
                            }
                            y = 0;
                            while (true) {
                                if (y >= this.height) continue block11;
                                for (x = 0; x < this.width; ++x) {
                                    if (x >= MinX && MaxX > x && y >= MinY && MaxY > y) continue;
                                    pos = y * this.width + x;
                                    n = 0;
                                    for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                        for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                            if (!MedianOld.this.circular[MedianOld.this.Order + k][MedianOld.this.Order + l] || 0 > x + k || x + k >= this.width || 0 > y + l || y + l >= this.height) continue;
                                            this.buffer[n++] = this.bytebufferin[pos + l * this.width + k] & 255;
                                        }
                                    }
                                    Arrays.sort(this.buffer, 0, n);
                                    this.bytebufferout[pos] = (byte)this.buffer[n / 2];
                                }
                                ++y;
                            }
                        }
                        if (this.square) {
                            y = MinY;
                            posori = MinY * this.width;
                            while (y < MaxY) {
                                x = MinX;
                                pos = posori + MinX;
                                while (x < MaxX) {
                                    if ((this.bytebufferin[pos] & 255) == MedianOld.this.ForbiddenValue) {
                                        this.bytebufferout[pos] = this.bytebufferin[pos];
                                    } else {
                                        n = 0;
                                        for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                            for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                                v = this.bytebufferin[pos + l * this.width + k] & 255;
                                                if (v == MedianOld.this.ForbiddenValue) continue;
                                                this.buffer[n++] = v;
                                            }
                                        }
                                        Arrays.sort(this.buffer, 0, n);
                                        this.bytebufferout[pos] = (byte)this.buffer[n / 2];
                                    }
                                    ++x;
                                    ++pos;
                                }
                                ++y;
                                posori += this.width;
                            }
                            y = 0;
                            while (true) {
                                if (y >= this.height) continue block11;
                                for (x = 0; x < this.width; ++x) {
                                    if (x >= MinX && MaxX > x && y >= MinY && MaxY > y) continue;
                                    pos = y * this.width + x;
                                    if ((this.bytebufferin[pos] & 255) == MedianOld.this.ForbiddenValue) {
                                        this.bytebufferout[pos] = this.bytebufferin[pos];
                                        continue;
                                    }
                                    n = 0;
                                    for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                        for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                            if (0 > x + k || x + k >= this.width || 0 > y + l || y + l >= this.height || (v = this.bytebufferin[pos + l * this.width + k] & 255) == MedianOld.this.ForbiddenValue) continue;
                                            this.buffer[n++] = v;
                                        }
                                    }
                                    Arrays.sort(this.buffer, 0, n);
                                    this.bytebufferout[pos] = (byte)this.buffer[n / 2];
                                }
                                ++y;
                            }
                        }
                        y = MinY;
                        posori = MinY * this.width;
                        while (y < MaxY) {
                            x = MinX;
                            pos = posori + MinX;
                            while (x < MaxX) {
                                if ((this.bytebufferin[pos] & 255) == MedianOld.this.ForbiddenValue) {
                                    this.bytebufferout[pos] = this.bytebufferin[pos];
                                } else {
                                    n = 0;
                                    for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                        for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                            if (!MedianOld.this.circular[MedianOld.this.Order + k][MedianOld.this.Order + l] || (v = this.bytebufferin[pos + l * this.width + k] & 255) == MedianOld.this.ForbiddenValue) continue;
                                            this.buffer[n++] = v;
                                        }
                                    }
                                    Arrays.sort(this.buffer, 0, n);
                                    this.bytebufferout[pos] = (byte)this.buffer[n / 2];
                                }
                                ++x;
                                ++pos;
                            }
                            ++y;
                            posori += this.width;
                        }
                        y = 0;
                        while (true) {
                            if (y >= this.height) continue block11;
                            for (x = 0; x < this.width; ++x) {
                                if (x >= MinX && MaxX > x && y >= MinY && MaxY > y) continue;
                                pos = y * this.width + x;
                                if ((this.bytebufferin[pos] & 255) == MedianOld.this.ForbiddenValue) {
                                    this.bytebufferout[pos] = this.bytebufferin[pos];
                                    continue;
                                }
                                n = 0;
                                for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                    for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                        if (!MedianOld.this.circular[MedianOld.this.Order + k][MedianOld.this.Order + l] || 0 > x + k || x + k >= this.width || 0 > y + l || y + l >= this.height || (v = this.bytebufferin[pos + l * this.width + k] & 255) == MedianOld.this.ForbiddenValue) continue;
                                        this.buffer[n++] = v;
                                    }
                                }
                                Arrays.sort(this.buffer, 0, n);
                                this.bytebufferout[pos] = (byte)this.buffer[n / 2];
                            }
                            ++y;
                        }
                    }
                    case 11: {
                        if (MedianOld.this.ForbiddenValue < 0) {
                            if (this.square) {
                                y = MinY;
                                posori = MinY * this.width;
                                while (y < MaxY) {
                                    x = MinX;
                                    pos = posori + MinX;
                                    while (x < MaxX) {
                                        n = 0;
                                        for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                            for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                                this.buffer[n++] = this.shortbufferin[pos + l * this.width + k] & 65535;
                                            }
                                        }
                                        Arrays.sort(this.buffer, 0, n);
                                        this.shortbufferout[pos] = (short)this.buffer[n / 2];
                                        ++x;
                                        ++pos;
                                    }
                                    ++y;
                                    pos += this.width;
                                }
                                y = 0;
                                while (true) {
                                    if (y >= this.height) continue block11;
                                    for (x = 0; x < this.width; ++x) {
                                        if (x >= MinX && MaxX > x && y >= MinY && MaxY > y) continue;
                                        pos = y * this.width + x;
                                        n = 0;
                                        for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                            for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                                if (0 > x + k || x + k >= this.width || 0 > y + l || y + l >= this.height) continue;
                                                this.buffer[n++] = this.shortbufferin[pos + l * this.width + k] & 65535;
                                            }
                                        }
                                        Arrays.sort(this.buffer, 0, n);
                                        this.shortbufferout[pos] = (short)this.buffer[n / 2];
                                    }
                                    ++y;
                                }
                            }
                            y = MinY;
                            posori = MinY * this.width;
                            while (y < MaxY) {
                                x = MinX;
                                pos = posori + MinX;
                                while (x < MaxX) {
                                    n = 0;
                                    for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                        for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                            if (!MedianOld.this.circular[MedianOld.this.Order + k][MedianOld.this.Order + l]) continue;
                                            this.buffer[n++] = this.shortbufferin[pos + l * this.width + k] & 65535;
                                        }
                                    }
                                    Arrays.sort(this.buffer, 0, n);
                                    this.shortbufferout[pos] = (short)this.buffer[n / 2];
                                    ++x;
                                    ++pos;
                                }
                                ++y;
                                pos += this.width;
                            }
                            y = 0;
                            while (true) {
                                if (y >= this.height) continue block11;
                                for (x = 0; x < this.width; ++x) {
                                    if (x >= MinX && MaxX > x && y >= MinY && MaxY > y) continue;
                                    pos = y * this.width + x;
                                    n = 0;
                                    for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                        for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                            if (!MedianOld.this.circular[MedianOld.this.Order + k][MedianOld.this.Order + l] || 0 > x + k || x + k >= this.width || 0 > y + l || y + l >= this.height) continue;
                                            this.buffer[n++] = this.shortbufferin[pos + l * this.width + k] & 65535;
                                        }
                                    }
                                    Arrays.sort(this.buffer, 0, n);
                                    this.shortbufferout[pos] = (short)this.buffer[n / 2];
                                }
                                ++y;
                            }
                        }
                        if (this.square) {
                            y = MinY;
                            posori = MinY * this.width;
                            while (y < MaxY) {
                                x = MinX;
                                pos = posori + MinX;
                                while (x < MaxX) {
                                    if ((this.shortbufferin[pos] & 65535) == MedianOld.this.ForbiddenValue) {
                                        this.shortbufferout[pos] = this.shortbufferin[pos];
                                    } else {
                                        n = 0;
                                        for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                            for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                                v = this.shortbufferin[pos + l * this.width + k] & 65535;
                                                if (v == MedianOld.this.ForbiddenValue) continue;
                                                this.buffer[n++] = v;
                                            }
                                        }
                                        Arrays.sort(this.buffer, 0, n);
                                        this.shortbufferout[pos] = (short)this.buffer[n / 2];
                                    }
                                    ++x;
                                    ++pos;
                                }
                                ++y;
                                pos += this.width;
                            }
                            y = 0;
                            while (true) {
                                if (y >= this.height) continue block11;
                                for (x = 0; x < this.width; ++x) {
                                    if (x >= MinX && MaxX > x && y >= MinY && MaxY > y) continue;
                                    pos = y * this.width + x;
                                    if ((this.shortbufferin[pos] & 65535) == MedianOld.this.ForbiddenValue) {
                                        this.shortbufferout[pos] = this.shortbufferin[pos];
                                        continue;
                                    }
                                    n = 0;
                                    for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                        for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                            if (0 > x + k || x + k >= this.width || 0 > y + l || y + l >= this.height || (v = this.shortbufferin[pos + l * this.width + k] & 65535) == MedianOld.this.ForbiddenValue) continue;
                                            this.buffer[n++] = v;
                                        }
                                    }
                                    Arrays.sort(this.buffer, 0, n);
                                    this.shortbufferout[pos] = (short)this.buffer[n / 2];
                                }
                                ++y;
                            }
                        }
                        y = MinY;
                        posori = MinY * this.width;
                        while (y < MaxY) {
                            x = MinX;
                            pos = posori + MinX;
                            while (x < MaxX) {
                                if ((this.shortbufferin[pos] & 65535) == MedianOld.this.ForbiddenValue) {
                                    this.shortbufferout[pos] = this.shortbufferin[pos];
                                } else {
                                    n = 0;
                                    for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                        for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                            if (!MedianOld.this.circular[MedianOld.this.Order + k][MedianOld.this.Order + l] || (v = this.shortbufferin[pos + l * this.width + k] & 65535) == MedianOld.this.ForbiddenValue) continue;
                                            this.buffer[n++] = v;
                                        }
                                    }
                                    Arrays.sort(this.buffer, 0, n);
                                    this.shortbufferout[pos] = (short)this.buffer[n / 2];
                                }
                                ++x;
                                ++pos;
                            }
                            ++y;
                            pos += this.width;
                        }
                        y = 0;
                        while (true) {
                            if (y < this.height) ** break;
                            continue block11;
                            for (x = 0; x < this.width; ++x) {
                                if (x >= MinX && MaxX > x && y >= MinY && MaxY > y) continue;
                                pos = y * this.width + x;
                                if ((this.shortbufferin[pos] & 65535) == MedianOld.this.ForbiddenValue) {
                                    this.shortbufferout[pos] = this.shortbufferin[pos];
                                    continue;
                                }
                                n = 0;
                                for (k = -MedianOld.this.Order; k <= MedianOld.this.Order; ++k) {
                                    for (l = -MedianOld.this.Order; l <= MedianOld.this.Order; ++l) {
                                        if (!MedianOld.this.circular[MedianOld.this.Order + k][MedianOld.this.Order + l] || 0 > x + k || x + k >= this.width || 0 > y + l || y + l >= this.height || (v = this.shortbufferin[pos + l * this.width + k] & 65535) == MedianOld.this.ForbiddenValue) continue;
                                        this.buffer[n++] = v;
                                    }
                                }
                                Arrays.sort(this.buffer, 0, n);
                                this.shortbufferout[pos] = (short)this.buffer[n / 2];
                            }
                            ++y;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Color type not yet supported.");
        }
    }
}

