/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import dv.DvNew;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.List;
import morphee.MorphoFilter;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import morphee.rank.Rank;
import morphee.rank.RankFV;
import processing.filters.SignalFilter;

public class Median
implements MorphoFilter {
    private Rank rank = new Rank();
    private RankFV rankfv = new RankFV();
    private boolean usefv = false;
    private StructuringElement se = null;
    private StructuringElement3D se3 = null;

    public void Kill() {
        if (this.se != null) {
            this.se.Kill();
        }
        if (this.se3 != null) {
            this.se3.Kill();
        }
        this.se = null;
        this.se3 = null;
        this.rank.Kill();
        this.rankfv.Kill();
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public BufferedImage Filter(BufferedImage source, StructuringElement se, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, se, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, StructuringElement se, BufferedImage result, int nbCPU) {
        this.setStructuringElement(se);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.usefv) {
            this.rankfv.Filter(source, result, nbCPU);
        } else {
            this.rank.Filter(source, result, nbCPU);
        }
    }

    public StructuringElement getStructuringElement() {
        return this.se;
    }

    public void setStructuringElement(StructuringElement se) {
        this.se = se;
        this.rank.setStructuringElement(se);
        this.rankfv.setStructuringElement(se);
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public DV Filter(DV source, StructuringElement3D se, int nbCPU) {
        this.setStructuringElement3D(se);
        return this.Filter(source, nbCPU);
    }

    public void Filter(DV source, StructuringElement3D se, DV result, int nbCPU) {
        this.setStructuringElement3D(se);
        this.Filter(source, result, nbCPU);
    }

    public void Filter(DV source, DV result, int nbCPU) {
        if (this.usefv) {
            this.rankfv.Filter(source, result, nbCPU);
        } else {
            this.rank.Filter(source, result, nbCPU);
        }
    }

    public StructuringElement3D getStructuringElement3D() {
        return this.se3;
    }

    public void setStructuringElement3D(StructuringElement3D se) {
        this.se3 = se;
        this.rank.setStructuringElement3D(se);
        this.rankfv.setStructuringElement3D(se);
    }

    public void Parameters(Object ... parameters) {
        switch (parameters.length) {
            case 1: {
                this.rank.Parameters(parameters[0], 50);
                this.usefv = false;
                break;
            }
            case 2: {
                this.rankfv.Parameters(parameters[0], 50, parameters[1]);
                this.usefv = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("1 or 2 parameter(s) required: StructuringElement (+ int ForbiddenValue).");
            }
        }
    }

    public List<Object> Parameters() {
        List<Object> parameters = null;
        parameters = this.usefv ? this.rankfv.Parameters() : this.rank.Parameters();
        parameters.remove(1);
        return parameters;
    }

    public int BorderEffectSizeX() {
        if (this.usefv) {
            return this.rankfv.BorderEffectSizeX();
        }
        return this.rank.BorderEffectSizeX();
    }

    public int BorderEffectSizeY() {
        if (this.usefv) {
            return this.rankfv.BorderEffectSizeY();
        }
        return this.rank.BorderEffectSizeY();
    }

    public int BorderEffectSizeZ() {
        if (this.usefv) {
            return this.rankfv.BorderEffectSizeZ();
        }
        return this.rank.BorderEffectSizeZ();
    }

    public SignalFilter Clone() {
        Median clone = new Median();
        clone.Parameters(this.Parameters().toArray());
        return clone;
    }
}

