/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import imageTiTi.ImageConverter;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.List;
import processing.filters.SignalFilter;

public class MaskFilter
implements SignalFilter {
    protected boolean[][] mask = null;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        int largeur = source.getWidth();
        int hauteur = source.getHeight();
        if (this.mask == null) {
            throw new Error("Mask undefined.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions and types.");
        }
        if (largeur != this.mask[0].length || hauteur != this.mask.length) {
            throw new IllegalArgumentException("Dimensions gap between image and mask");
        }
        for (int y = 0; y < hauteur; ++y) {
            for (int x = 0; x < largeur; ++x) {
                if (!this.mask[y][x]) continue;
                result.setRGB(x, y, source.getRGB(x, y));
            }
        }
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU, BufferedImage mask) {
        this.Mask(mask);
        return this.Filter(source, nbCPU);
    }

    public void Filter(BufferedImage source, BufferedImage mask, BufferedImage result, int nbCPU) {
        this.Mask(mask);
        this.Filter(source, result, nbCPU);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Mask(BufferedImage mask) {
        this.mask = ImageConverter.ImageToBoolean((BufferedImage)mask);
    }

    public void Mask(double[][] mask) {
        if (mask == null) {
            throw new NullPointerException("mask=null");
        }
        int largeur = mask[0].length;
        int hauteur = mask.length;
        for (int y = 0; y < hauteur; ++y) {
            for (int x = 0; x < largeur; ++x) {
                this.mask[y][x] = mask[y][x] > 0.0;
            }
        }
    }

    public void Mask(boolean[][] mask) {
        if (mask == null) {
            throw new NullPointerException("mask=null");
        }
        this.mask = (boolean[][])mask.clone();
    }

    public double[][] Mask() {
        return null;
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        return null;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

