/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import arrayTiTi.ArrayNew;
import arrayTiTi.ArrayTools;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.List;
import processing.filters.SignalFilter;
import stackTiTi.StackNew;
import utils.strings.StringToolsImageDV;

public class Invert
implements SignalFilter {
    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions and types.");
        }
        int width = source.getWidth();
        int height = source.getHeight();
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                WritableRaster wrr = result.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        wrr.setSample(x, y, 0, 1 - wr.getSample(x, y, 0));
                    }
                }
                wrr = null;
                wr = null;
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                byte[] bytebufferin = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                byte[] bytebufferout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bytebufferin.length; ++x) {
                    bytebufferout[x] = (byte)(255 - (bytebufferin[x] & 0xFF));
                }
                bytebufferin = null;
                bytebufferout = null;
                break;
            }
            case 11: {
                short[] shortbufferin = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                short[] shortbufferout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < shortbufferin.length; ++x) {
                    shortbufferout[x] = (short)(65535 - (shortbufferin[x] & 0xFFFF));
                }
                shortbufferin = null;
                shortbufferout = null;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                WritableRaster wr = source.getRaster();
                WritableRaster wrr = result.getRaster();
                for (int c = 0; c < wrr.getNumBands(); ++c) {
                    for (int y = 0; y < height; ++y) {
                        for (int x = 0; x < width; ++x) {
                            wrr.setSample(x, y, c, 255 - wr.getSample(x, y, c));
                        }
                    }
                }
                wrr = null;
                wr = null;
                break;
            }
            case 0: {
                WritableRaster wr = source.getRaster();
                WritableRaster wrr = result.getRaster();
                block7 : switch (source.getColorModel().getColorSpace().getType()) {
                    case 7: 
                    case 8: {
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                wrr.setSample(x, y, 0, (wr.getSample(x, y, 0) + 180) % 180);
                                wrr.setSample(x, y, 1, 1.0 - wr.getSampleDouble(x, y, 1));
                                wrr.setSample(x, y, 2, 1.0 - wr.getSampleDouble(x, y, 2));
                            }
                        }
                        break;
                    }
                    case 1: {
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                wrr.setSample(x, y, 0, 100.0 - wr.getSampleDouble(x, y, 0));
                                wrr.setSample(x, y, 1, 174.0 - (wr.getSampleDouble(x, y, 1) + 78.0) - 78.0);
                                wrr.setSample(x, y, 2, 199.0 - (wr.getSampleDouble(x, y, 2) + 96.0) - 96.0);
                            }
                        }
                        break;
                    }
                    default: {
                        switch (source.getRaster().getDataBuffer().getDataType()) {
                            case 3: {
                                int[] intbufferin = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                                int[] intbufferout = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
                                for (int x = 0; x < intbufferin.length; ++x) {
                                    intbufferout[x] = intbufferin[x] == Integer.MIN_VALUE ? Integer.MAX_VALUE : -intbufferin[x];
                                }
                                intbufferin = null;
                                Object bytebufferout = null;
                                break block7;
                            }
                            case 4: {
                                float[] floatbufferin = ((DataBufferFloat)source.getRaster().getDataBuffer()).getData();
                                float[] floatbufferout = ((DataBufferFloat)result.getRaster().getDataBuffer()).getData();
                                for (int x = 0; x < floatbufferin.length; ++x) {
                                    floatbufferout[x] = -floatbufferin[x];
                                }
                                floatbufferin = null;
                                floatbufferout = null;
                                break block7;
                            }
                            case 5: {
                                double[] doublebufferin = ((DataBufferDouble)source.getRaster().getDataBuffer()).getData();
                                double[] doublebufferout = ((DataBufferDouble)result.getRaster().getDataBuffer()).getData();
                                for (int x = 0; x < doublebufferin.length; ++x) {
                                    doublebufferout[x] = -doublebufferin[x];
                                }
                                doublebufferin = null;
                                doublebufferout = null;
                                break block7;
                            }
                        }
                        throw new IllegalArgumentException("DataBuffer type not supported.");
                    }
                }
                wrr = null;
                wr = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("BufferedImage type not supported.");
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        if (!DvTools.areDimensionsAndTypeEqual((DV)source, (DV)result)) {
            throw new IllegalArgumentException("DV have different types or dimensions.");
        }
        switch (source.Type) {
            case 8: {
                for (int c = 0; c < source.Channel; ++c) {
                    byte[] bbin = source.getDataBufferByte(c);
                    byte[] bbout = result.getDataBufferByte(c);
                    for (int i2 = 0; i2 < bbin.length; ++i2) {
                        bbout[i2] = (byte)(255 - (bbin[i2] & 0xFF));
                    }
                    bbout = null;
                    bbin = null;
                }
                break;
            }
            case 16: {
                for (int c = 0; c < source.Channel; ++c) {
                    short[] sbin = source.getDataBufferShort(c);
                    short[] sbout = result.getDataBufferShort(c);
                    for (int i3 = 0; i3 < sbin.length; ++i3) {
                        sbout[i3] = (short)(65535 - (sbin[i3] & 0xFFFF));
                    }
                    sbout = null;
                    sbin = null;
                }
                break;
            }
            case 32: {
                for (int c = 0; c < source.Channel; ++c) {
                    int[] ibin = source.getDataBufferInt(c);
                    int[] ibout = result.getDataBufferInt(c);
                    for (int i4 = 0; i4 < ibin.length; ++i4) {
                        ibout[i4] = ibin[i4] == Integer.MIN_VALUE ? Integer.MAX_VALUE : -ibin[i4];
                    }
                    ibout = null;
                    ibin = null;
                }
                break;
            }
            case -32: {
                for (int c = 0; c < source.Channel; ++c) {
                    float[] fbin = source.getDataBufferFloat(c);
                    float[] fbout = result.getDataBufferFloat(c);
                    for (int i5 = 0; i5 < fbin.length; ++i5) {
                        fbout[i5] = -fbin[i5];
                    }
                    fbout = null;
                    fbin = null;
                }
                break;
            }
            case 64: {
                for (int c = 0; c < source.Channel; ++c) {
                    double[] dbin = source.getDataBufferDouble(c);
                    double[] dbout = result.getDataBufferDouble(c);
                    for (int i6 = 0; i6 < dbin.length; ++i6) {
                        dbout[i6] = -dbin[i6];
                    }
                    dbout = null;
                    dbin = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public BufferedImage[] Filter(BufferedImage[] sources, int nbCPU) {
        BufferedImage[] results = StackNew.Same(sources);
        this.Filter(sources, results, nbCPU);
        return results;
    }

    public void Filter(BufferedImage[] sources, BufferedImage[] results, int nbCPU) {
        if (sources.length != results.length) {
            throw new IllegalArgumentException("Different number of images.");
        }
        for (int i2 = 0; i2 < sources.length; ++i2) {
            this.Filter(sources[i2], results[i2], nbCPU);
        }
    }

    public void Filter(File[] sources, String resdir) throws IOException {
        String ext = StringToolsImageDV.FindExtension((String)sources[0].getName());
        BufferedImage image = ImageIO.Read(sources[0]);
        BufferedImage result = ImageNew.Same((BufferedImage)image);
        this.Filter(image, result, 1);
        ImageIO.Write(result, resdir + "/" + sources[0].getName().replace(ext, "png"), 6);
        image = null;
        for (int i2 = 1; i2 < sources.length; ++i2) {
            image = ImageIO.Read(sources[i2]);
            this.Filter(image, result, 1);
            ImageIO.Write(result, resdir + "/" + sources[i2].getName().replace(ext, "png"), 6);
            image = null;
        }
        result = null;
        ext = null;
    }

    public double[][] Filter(double[][] source, double maxvalue, int nbCPU) {
        double[][] result = ArrayNew.Same((double[][])source);
        this.Filter(source, result, maxvalue, nbCPU);
        return result;
    }

    public void Filter(double[][] source, double[][] result, double maxvalue, int nbCPU) {
        if (!ArrayTools.areDimensionsEqual((double[][])source, (double[][])result)) {
            throw new IllegalArgumentException("Arrays have different dimensions.");
        }
        int width = source[0].length;
        int height = source.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = maxvalue - source[y][x];
            }
        }
    }

    public void Parameters(Object ... parameters) {
    }

    public List<Object> Parameters() {
        return null;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

