/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayIO;
import displays.Display;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import processing.filters.SignalFilter;
import utils.times.Chronometer;

public class ImageFilterPerformances {
    private Chronometer chrono = new Chronometer();
    private Display display = new Display();

    public ImageFilterPerformances() {
        this.display.StartImageJ();
    }

    public void Analyze(SignalFilter filter, int nbIterations, BufferedImage imagetest, BufferedImage result, int nbCPU) {
        System.out.println("ImageFilter performances: " + nbIterations + " iterations.");
        filter.Filter(imagetest, result, nbCPU);
        System.out.print(filter.getClass().getSimpleName() + ": ");
        int marker = this.chrono.NewMarker();
        for (int i2 = 0; i2 < nbIterations; ++i2) {
            filter.Filter(imagetest, result, nbCPU);
        }
        double time = this.chrono.getTimeSinceMarker(marker);
        this.chrono.FreeMarker(marker);
        System.out.println(time + "s => " + time / (double)nbIterations + " s/iter");
        result = null;
    }

    public void Compare(int nbIterations, BufferedImage imagetest, int nbCPU, SignalFilter ... filters) {
        int i2;
        BufferedImage result;
        SignalFilter filter;
        if (filters.length < 2) {
            throw new IllegalArgumentException();
        }
        double[] timeratio = new double[filters.length];
        BufferedImage[] results = new BufferedImage[filters.length];
        System.out.println("ImageFilter performances: " + nbIterations + " iterations.");
        int nb = 0;
        int f = 0;
        while (f < filters.length) {
            double time;
            filter = filters[f];
            results[nb] = filter.Filter(imagetest, nbCPU);
            result = results[nb];
            System.out.print(" - " + f + " - " + filter.getClass().getSimpleName() + ": ");
            int marker = this.chrono.NewMarker();
            for (i2 = 0; i2 < nbIterations; ++i2) {
                filter.Filter(imagetest, result, nbCPU);
            }
            timeratio[nb] = time = this.chrono.getTimeSinceMarker(marker);
            this.chrono.FreeMarker(marker);
            System.out.println(time + "s => " + time / (double)nbIterations + " s/iter");
            ++f;
            ++nb;
        }
        ArrayArithmetic.Divide((double[])timeratio, (double)timeratio[0], (double[])timeratio);
        ArrayIO.Display(timeratio, "Ratios", " ");
        for (i2 = 1; i2 < results.length; ++i2) {
            if (ImageTools.areEqual((BufferedImage)results[0], (BufferedImage)results[i2])) continue;
            this.display.Image(imagetest, "Test image", 1.0);
            for (f = 0; f < results.length; ++f) {
                this.display.Image(results[f], filters[f].getClass().getSimpleName(), 1.0);
                for (int j = f + 1; j < results.length; ++j) {
                    this.display.Image(ImageOperations.Differences((BufferedImage)results[f], (BufferedImage)results[j]), filters[f].getClass().getSimpleName() + " vs " + filters[j].getClass().getSimpleName(), 1.0);
                }
            }
            this.display.StartWindowOrganizer();
            break;
        }
        if (i2 == results.length) {
            System.out.println("Ok");
        }
        results = null;
        result = null;
        filter = null;
    }
}

