/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayNew;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import mathematics.fourier.FastFourierTransform;
import mathematics.functions.GaussianGenerator;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.filters.ConvolutionFilter;
import processing.filters.SignalFilter;
import utils.memory.Allocator;

public class Gaussian
implements SignalFilter {
    private Allocator allocator = Allocator.Instance();
    private int radius = -1;
    private double sigma = -1.0;
    private ConvolutionFilter filter = null;
    private double[][] maskx;
    private double[][] masky;
    private double[][][] mask3x;
    private double[][][] mask3y;
    private double[][][] mask3z;
    private StructuringElement sex;
    private StructuringElement sey;
    private StructuringElement3D se3x;
    private StructuringElement3D se3y;
    private StructuringElement3D se3z;
    private DV tmp = null;
    private FastFourierTransform fft = null;
    private final ArrayFeatures AF = new ArrayFeatures();

    public Gaussian() {
        this.filter = new ConvolutionFilter();
    }

    public Gaussian(int radius, double sigma, int dimension) {
        this.filter = new ConvolutionFilter();
        switch (dimension) {
            case 2: {
                this.CreateMask(radius, sigma);
                break;
            }
            case 3: {
                this.CreateMask3D(radius, sigma);
                break;
            }
            default: {
                throw new IllegalArgumentException("The dimension must be 2 or 3!");
            }
        }
    }

    public void Kill() {
        this.filter.Kill();
        this.filter = null;
        if (this.sex != null) {
            this.sex.Kill();
            this.sey.Kill();
        }
        if (this.se3x != null) {
            this.se3x.Kill();
            this.se3y.Kill();
            this.se3z.Kill();
        }
        if (this.tmp != null) {
            this.tmp.Kill();
        }
        this.masky = null;
        this.maskx = null;
        this.mask3z = null;
        this.mask3y = null;
        this.mask3x = null;
        this.sey = null;
        this.sex = null;
        this.se3z = null;
        this.se3y = null;
        this.se3x = null;
        this.tmp = null;
        this.fft = null;
    }

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        BufferedImage tmp = ImageNew.Same((BufferedImage)source);
        this.filter.Parameters(this.sex, this.fft, -1);
        this.filter.Filter(source, tmp, nbCPU);
        this.filter.Parameters(this.sey, this.fft, -1);
        this.filter.Filter(tmp, result, nbCPU);
        tmp = this.allocator.Release(tmp);
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = DvNew.Same((DV)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        if (this.se3x == null) {
            throw new IllegalArgumentException("Any 3G gaussian mask defined.");
        }
        if (this.tmp == null || !DvTools.areDimensionsAndTypeEqual((DV)this.tmp, (DV)source)) {
            this.tmp = null;
            this.tmp = DvNew.Same((DV)source);
        }
        this.filter.Parameters(this.se3x, this.fft, -1);
        this.filter.Filter(source, result, nbCPU);
        this.filter.Parameters(this.se3y, this.fft, -1);
        this.filter.Filter(result, this.tmp, nbCPU);
        this.filter.Parameters(this.se3z, this.fft, -1);
        this.filter.Filter(this.tmp, result, nbCPU);
    }

    public double[][] Filter(double[][] source, StructuringElement se, int nbCPU) {
        double[][] result = ArrayNew.Same((double[][])source);
        this.Filter(source, se, result, nbCPU);
        return result;
    }

    public void Filter(double[][] source, StructuringElement se, double[][] result, int nbCPU) {
        this.Filter(source, result, nbCPU);
    }

    public double[][] Filter(double[][] source, int nbCPU) {
        double[][] result = ArrayNew.Same((double[][])source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(double[][] source, double[][] result, int nbCPU) {
        this.filter.Filter(source, result, nbCPU);
    }

    public void CreateMask(int radius, double sigma) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Bad value of radius: " + radius);
        }
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("Bad value of sigma: " + sigma);
        }
        this.radius = radius;
        this.sigma = sigma;
        int R = (radius << 1) + 1;
        if (this.maskx == null || this.maskx.length != R) {
            this.maskx = new double[1][R];
            this.masky = new double[R][1];
        }
        GaussianGenerator.Generate1D((double)radius, 1.0, sigma, this.maskx[0]);
        ArrayArithmetic.Divide((double[])this.maskx[0], (double)this.AF.Integral(this.maskx[0]), (double[])this.maskx[0]);
        for (int x = 0; x < R; ++x) {
            this.masky[x][0] = this.maskx[0][x];
        }
        this.sex = new StructuringElement(this.maskx);
        this.sey = new StructuringElement(this.masky);
    }

    public void CreateMask3D(int radius, double sigma) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Bad value of radius: " + radius);
        }
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("Bad value of sigma: " + sigma);
        }
        this.radius = radius;
        this.sigma = sigma;
        int R = (radius << 1) + 1;
        if (this.mask3x == null || this.mask3x.length != R) {
            this.mask3z = null;
            this.mask3y = null;
            this.mask3x = null;
            this.mask3x = new double[1][1][R];
            this.mask3y = new double[1][R][1];
            this.mask3z = new double[R][1][1];
        }
        GaussianGenerator.Generate1D((double)radius, 1.0, sigma, this.mask3x[0][0]);
        ArrayArithmetic.Divide((double[])this.mask3x[0][0], (double)this.AF.Integral(this.mask3x[0][0]), (double[])this.mask3x[0][0]);
        for (int x = 0; x < R; ++x) {
            double d = this.mask3x[0][0][x];
            this.mask3y[0][x][0] = d;
            this.mask3z[x][0][0] = d;
        }
        this.se3x = new StructuringElement3D(this.mask3x);
        this.se3y = new StructuringElement3D(this.mask3y);
        this.se3z = new StructuringElement3D(this.mask3z);
    }

    public int getRadius() {
        return this.radius;
    }

    public double getSigma() {
        return this.sigma;
    }

    public double[][] MaskX() {
        return this.maskx;
    }

    public double[][] MaskY() {
        return this.masky;
    }

    public double[][][] Mask3DX() {
        return this.mask3x;
    }

    public double[][][] Mask3DY() {
        return this.mask3y;
    }

    public double[][][] Mask3DZ() {
        return this.mask3z;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 4) {
            throw new IllegalArgumentException("Exactly 4 parameters required.");
        }
        this.radius = (Integer)parameters[0];
        this.sigma = (Double)parameters[1];
        this.fft = (FastFourierTransform)parameters[2];
        switch ((Integer)parameters[3]) {
            case 2: {
                this.CreateMask(this.radius, this.sigma);
                break;
            }
            case 3: {
                this.CreateMask3D(this.radius, this.sigma);
                break;
            }
            default: {
                throw new IllegalArgumentException("The dimension (last parameter) must be 2 or 3.");
            }
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.radius);
        params.add(this.sigma);
        params.add(this.fft);
        params.add(this.sex != null ? 2 : 3);
        return params;
    }

    public int BorderEffectSizeX() {
        if (this.sex != null) {
            return this.sex.getSizeX() >> 1;
        }
        if (this.se3x != null) {
            return this.se3x.getSizeX() >> 1;
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeY() {
        if (this.sey != null) {
            return this.sey.getSizeY() >> 1;
        }
        if (this.se3y != null) {
            return this.se3y.getSizeY() >> 1;
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeZ() {
        if (this.sex != null) {
            return 0;
        }
        if (this.se3y != null) {
            return this.se3y.getSizeZ() >> 1;
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public SignalFilter Clone() {
        Gaussian clone = new Gaussian();
        clone.Parameters(this.Parameters().toArray());
        return clone;
    }
}

