/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayNew;
import arrayTiTi.ArrayTools;
import dv.DV;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.fourier.FFT;
import mathematics.fourier.FastFourierTransform;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import processing.filters.SignalFilter;

public class GaborCircular
implements SignalFilter {
    public double[][] gabor = null;
    private Object gaborfft = null;
    private Object srcfft = null;
    private Object resultmult = null;
    private FFT fft = null;
    private double[][] resultgabor = null;
    private double[][] tempresult = null;
    private int ForbiddenValue = -1;
    private GaborCircularThread[] threads = null;
    private int nbFreeThreads = 0;
    private double Sigma;
    private double Lambda;
    private double Phase;
    private boolean minimumoscillation = false;
    private final ConnectedComponentLabeling ccl = new UnionFindCcl();
    private final ArrayFeatures AF = new ArrayFeatures();

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), 11);
        this.Filter(source, result, nbCPU);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.gabor == null) {
            throw new IllegalArgumentException("Kernels must be created before.");
        }
        if (!ImageTools.isGrayLevel((BufferedImage)source)) {
            throw new IllegalArgumentException("Image source must be gray level.");
        }
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (!ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions.");
        }
        if (result.getType() != 11) {
            throw new IllegalArgumentException("Result image must be TYPE_USHORT_GRAY.");
        }
        int width = source.getWidth();
        int height = source.getHeight();
        if (this.resultgabor == null || width != this.resultgabor[0].length || height != this.resultgabor.length) {
            this.resultgabor = null;
            this.resultgabor = new double[height][width];
            this.tempresult = null;
            this.tempresult = new double[height][width];
        }
        if (this.fft != null) {
            if (!ImageTools.isGrayLevel((BufferedImage)source)) {
                throw new IllegalArgumentException("Only gray level image supported.");
            }
            if (this.srcfft == null || !this.fft.fft.areDimensionsCorrect(source, this.srcfft)) {
                this.srcfft = null;
                this.srcfft = this.fft.fft.CreateObject(source);
                this.resultmult = null;
                this.resultmult = this.fft.fft.CreateObject(source);
                this.gaborfft = null;
                this.gaborfft = this.fft.fft.CreateObject(source);
                this.fft.fft.Transform(this.gabor, this.gaborfft);
                this.fft.Compute2D(this.gaborfft, -1, nbCPU);
            }
            this.fft.fft.Transform(source, this.srcfft);
            this.fft.Compute2D(this.srcfft, -1, nbCPU);
            this.fft.fft.Multiply2D(this.srcfft, this.gaborfft, this.resultmult);
            this.fft.Compute2D(this.resultmult, 1, nbCPU);
            if (this.fft.fft.ShiftRequired()) {
                this.fft.fft.Shift(this.resultmult);
            }
            this.fft.fft.Transform(this.resultmult, this.tempresult);
        } else {
            Object object;
            int i2;
            if (this.threads == null || this.threads.length != nbCPU) {
                this.nbFreeThreads = 0;
                this.threads = null;
                this.threads = new GaborCircularThread[nbCPU];
                for (i2 = 0; i2 < nbCPU; ++i2) {
                    this.threads[i2] = new GaborCircularThread();
                    this.threads[i2].start();
                }
                GaborCircular gaborCircular = this;
                synchronized (gaborCircular) {
                    while (this.nbFreeThreads != nbCPU) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            this.nbFreeThreads = 0;
            int step = source.getHeight() / nbCPU;
            for (i2 = 0; i2 < nbCPU - 1; ++i2) {
                this.threads[i2].setConditions(source, this.tempresult, this.gabor, 0, i2 * step, source.getWidth(), (i2 + 1) * step);
                object = this.threads[i2].lock;
                synchronized (object) {
                    this.threads[i2].lock.notify();
                    continue;
                }
            }
            this.threads[i2].setConditions(source, this.tempresult, this.gabor, 0, i2 * step, source.getWidth(), source.getHeight());
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
            }
            object = this;
            synchronized (object) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        ArrayNew.Copy((double[][])this.tempresult, (double[][])this.resultgabor);
        double min = this.AF.Minimum(this.resultgabor);
        if (min < 0.0) {
            ArrayArithmetic.Add((double[][])this.resultgabor, (double)(-min), (double[][])this.resultgabor);
        }
        ArrayNew.Copy((double[][])this.resultgabor, (double[][])this.tempresult);
        double max = this.AF.Maximum(this.resultgabor);
        if (max > 65535.0) {
            ArrayArithmetic.Divide((double[][])this.resultgabor, (double)max, (double[][])this.tempresult);
            ArrayArithmetic.Multiply((double[][])this.tempresult, (double)65535.0, (double[][])this.tempresult);
        }
        short[] shortbuffer = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                shortbuffer[pos] = (short)(this.tempresult[y][x] + 0.5);
                ++x;
                ++pos;
            }
        }
        shortbuffer = null;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    private void CreateKernel(double Sigma, double Lambda, double Psi) {
        int x;
        int y;
        int ThetaStart = 0;
        int ThetaEnd = 165;
        int Step = 15;
        this.Sigma = Sigma;
        this.Lambda = Lambda;
        this.Phase = Psi;
        double Sigma2 = Math.pow(Sigma, 2.0);
        int num = 0;
        int nstds = this.minimumoscillation ? 2 : 3;
        int max = (int)Math.max(1.0, Math.ceil(Math.max(Math.abs((double)nstds * Sigma * Math.cos(0.0)), Math.abs((double)nstds * Sigma * Math.sin(0.0)))));
        int dx = 2 * max + 1;
        int dy = 2 * max + 1;
        int size = 2 * max + 1;
        double[][] x_theta = new double[dy][dx];
        double[][] y_theta = new double[dy][dx];
        this.gabor = new double[size][size];
        int Theta = ThetaStart;
        while (Theta <= ThetaEnd) {
            double theta = Math.toRadians(Theta);
            for (y = 0; y < dy; ++y) {
                for (x = 0; x < dx; ++x) {
                    x_theta[y][x] = (double)(x - max) * Math.cos(theta) + (double)(y - max) * Math.sin(theta);
                    y_theta[y][x] = -((double)(x - max)) * Math.sin(theta) + (double)(y - max) * Math.cos(theta);
                }
            }
            for (y = 0; y < dy; ++y) {
                for (x = 0; x < dx; ++x) {
                    double[] dArray = this.gabor[y];
                    int n = x;
                    dArray[n] = dArray[n] + Math.exp(-0.5 * (x_theta[y][x] * x_theta[y][x] / Sigma2 + y_theta[y][x] * y_theta[y][x] / Sigma2)) * Math.cos(Math.PI * 2 / Lambda * x_theta[y][x] + Psi);
                }
            }
            Theta += Step;
            ++num;
        }
        ArrayArithmetic.Divide((double[][])this.gabor, (double)num, (double[][])this.gabor);
        if (this.minimumoscillation) {
            int[] testab = new int[dy * dx];
            int pos = 0;
            for (y = 0; y < dy; ++y) {
                x = 0;
                while (x < dx) {
                    testab[pos] = this.gabor[y][x] > 0.0 ? 1 : (this.gabor[y][x] < 0.0 ? -1 : 0);
                    ++x;
                    ++pos;
                }
            }
            this.ccl.Label(testab, dx, dy, -100, true);
            int[] labels = this.ccl.Labels1D();
            int[] dt = new int[2];
            dt[0] = labels[labels.length >> 1];
            boolean[] lab = new boolean[this.ccl.ConnectedComponentsNumber() + 1];
            Arrays.fill(lab, false);
            for (y = 1; y < dy - 1; ++y) {
                for (x = 1; x < dx - 1; ++x) {
                    if (labels[y * dx + x] != dt[0]) continue;
                    for (int i2 = -1; i2 <= 1; ++i2) {
                        for (int j = -1; j <= 1; ++j) {
                            lab[labels[y * dx + x]] = true;
                            lab[labels[(y + i2) * dx + x + j]] = true;
                        }
                    }
                }
            }
            y = 0;
            for (x = 0; x < lab.length; ++x) {
                if (!lab[x]) continue;
                dt[y++] = x;
            }
            pos = 0;
            for (y = 0; y < dy; ++y) {
                x = 0;
                while (x < dx) {
                    if (labels[pos] != dt[0] && labels[pos] != dt[1]) {
                        this.gabor[y][x] = 0.0;
                    }
                    ++x;
                    ++pos;
                }
            }
            lab = null;
            dt = null;
            labels = null;
            testab = null;
        }
        y_theta = null;
        x_theta = null;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 6) {
            throw new IllegalArgumentException("Exactly 6 parameters required.");
        }
        FastFourierTransform algo = (FastFourierTransform)parameters[3];
        this.fft = algo != null ? new FFT(algo) : null;
        this.ForbiddenValue = (Integer)parameters[4];
        this.minimumoscillation = (Boolean)parameters[5];
        this.CreateKernel((Double)parameters[0], (Double)parameters[1], (Double)parameters[2]);
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(6);
        params.add(this.Sigma);
        params.add(this.Lambda);
        params.add(this.Phase);
        params.add(this.fft);
        params.add(this.ForbiddenValue);
        params.add(this.minimumoscillation);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    public double[][] Result() {
        return this.resultgabor;
    }

    public class GaborCircularThread
    extends Thread {
        private BufferedImage source = null;
        private WritableRaster wr = null;
        private double[][] result = null;
        private int sizex = -1;
        private int sizey = -1;
        private double[][] mask = null;
        private int minx;
        private int miny;
        private int maxx;
        private int maxy;
        public final Object lock = new Object();

        public void setConditions(BufferedImage source, double[][] result, double[][] mask, int minx, int miny, int maxx, int maxy) {
            this.source = source;
            this.wr = this.source.getRaster();
            this.result = result;
            this.mask = mask;
            this.sizex = mask[0].length / 2;
            this.sizey = mask.length / 2;
            this.minx = minx;
            this.miny = miny;
            this.maxx = maxx;
            this.maxy = maxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        GaborCircular.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                int width = this.source.getWidth();
                int height = this.source.getHeight();
                int MinX = this.minx < this.sizex ? this.sizex : this.minx;
                int MinY = this.miny < this.sizey ? this.sizey : this.miny;
                int MaxX = this.maxx >= width - this.sizex ? width - this.sizex : this.maxx;
                int MaxY = this.maxy >= height - this.sizey ? height - this.sizey : this.maxy;
                switch (this.source.getType()) {
                    case 10: 
                    case 11: {
                        int l;
                        int k;
                        double value;
                        int x;
                        int y;
                        for (y = MinY; y < MaxY; ++y) {
                            for (x = MinX; x < MaxX; ++x) {
                                if (this.wr.getSample(x, y, 0) == GaborCircular.this.ForbiddenValue) continue;
                                value = 0.0;
                                for (k = -this.sizey; k <= this.sizey; ++k) {
                                    for (l = -this.sizex; l <= this.sizex; ++l) {
                                        value += this.wr.getSampleDouble(x + l, y + k, 0) * this.mask[k + this.sizey][l + this.sizex];
                                    }
                                }
                                this.result[y][x] = value;
                            }
                        }
                        y = this.miny;
                        while (true) {
                            if (y >= this.maxy) continue block8;
                            for (x = this.minx; x < this.maxx; ++x) {
                                if (y >= this.sizey && x >= this.sizex && y < height - this.sizey && x < width - this.sizex || this.wr.getSample(x, y, 0) == GaborCircular.this.ForbiddenValue) continue;
                                value = 0.0;
                                for (k = -this.sizey; k <= this.sizey; ++k) {
                                    for (l = -this.sizex; l <= this.sizex; ++l) {
                                        value += ImageTools.PixelMirorDouble((WritableRaster)this.wr, (int)(x + l), (int)(y + k), (int)0) * ArrayTools.Miror((double[][])this.mask, (int)(k + this.sizey), (int)(l + this.sizex));
                                    }
                                }
                                this.result[y][x] = value;
                            }
                            ++y;
                        }
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Image type not supported.");
        }
    }
}

