/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayNew;
import arrayTiTi.ArrayOperations;
import arrayTiTi.ArrayTools;
import dv.DV;
import dv.DvArithmetic;
import dv.DvComparator;
import dv.DvDrawer;
import dv.DvFeatures;
import dv.DvNew;
import dv.DvOperations;
import dv.DvTools;
import filesAndFolders.FileNameFilters;
import filesAndFolders.FilesFolders;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferUShort;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.fourier.FFT;
import mathematics.fourier.FastFourierTransform;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.bigdata.BigDataProcessor;
import processing.filters.ConvolutionFilter;
import processing.filters.SignalFilter;
import stackTiTi.StackArithmetic;
import stackTiTi.StackDrawer;
import stackTiTi.StackFeatures;
import stackTiTi.StackNew;
import stackTiTi.StackTools;
import utils.strings.StringToolsImageDV;

public class Gabor
implements SignalFilter {
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int AVERAGE = 2;
    public StructuringElement[] gabormasks = null;
    public StructuringElement3D[] gm3 = null;
    private boolean precomputefft = true;
    private Object[] gaborfft = null;
    private Object srcfft = null;
    private Object resultmult = null;
    private FFT fft = null;
    private double[][] resultgabor = null;
    private double[][] tempresult = null;
    private double[][] image = null;
    private DV resgabor = null;
    private DV tmpres = null;
    private int[][] answer = null;
    private int[] orientations = null;
    private int ForbiddenValue = -1;
    private final ConvolutionFilter cvf = new ConvolutionFilter();
    private final ArrayFeatures AF = new ArrayFeatures();
    private final DvFeatures DF = new DvFeatures();
    private final StackFeatures SF = new StackFeatures();
    private int ThetaStart;
    private int ThetaEnd;
    private int ThetaStep;
    private int PhiStart;
    private int PhiEnd;
    private int PhiStep;
    private int AlphaStart;
    private int AlphaEnd;
    private int AlphaStep;
    private double SigmaX;
    private double SigmaY;
    private double SigmaZ;
    private double Lambda;
    private double Phase;
    private int action;
    private boolean minimumoscillation = false;
    private final ConnectedComponentLabeling ccl = new UnionFindCcl();
    private boolean BasicProcessing = false;
    private boolean IgnoreBorders = true;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), 11);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        if (this.IgnoreBorders) {
            throw new IllegalArgumentException("IgnoreBorders not supported (yet).");
        }
        if (this.gabormasks == null) {
            throw new IllegalArgumentException("Kernels must be created beforehand.");
        }
        if (!ImageTools.isGrayLevel((BufferedImage)source)) {
            throw new IllegalArgumentException("Image source must be gray level.");
        }
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (!ImageTools.areDimensionsEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images source and result must have identic dimensions.");
        }
        if (result.getType() != 11) {
            throw new IllegalArgumentException("Result image must be TYPE_USHORT_GRAY.");
        }
        int width = source.getWidth();
        int height = source.getHeight();
        if (this.resultgabor == null || width != this.resultgabor[0].length || height != this.resultgabor.length) {
            this.resultgabor = null;
            this.resultgabor = new double[height][width];
            this.tempresult = null;
            this.tempresult = new double[height][width];
            this.answer = null;
            this.answer = new int[height][width];
        }
        switch (this.action) {
            case 2: {
                ArrayOperations.Fill((double[][])this.resultgabor, (double)0.0);
                break;
            }
            case 0: {
                ArrayOperations.Fill((double[][])this.resultgabor, (double)Double.MAX_VALUE);
                break;
            }
            case 1: {
                ArrayOperations.Fill((double[][])this.resultgabor, (double)-1.7976931348623157E308);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown action.");
            }
        }
        if (this.fft != null) {
            if (!ImageTools.isGrayLevel((BufferedImage)source)) {
                throw new IllegalArgumentException("Only gray level images supported.");
            }
            if (this.srcfft == null || this.gaborfft[0] == null || !this.fft.fft.areDimensionsCorrect(source, this.srcfft)) {
                this.srcfft = null;
                this.srcfft = this.fft.fft.CreateObject(source);
                this.resultmult = null;
                this.resultmult = this.fft.fft.CreateObject(source);
                if (this.precomputefft) {
                    for (int i2 = 0; i2 < this.gaborfft.length; ++i2) {
                        this.gaborfft[i2] = null;
                        this.gaborfft[i2] = this.fft.fft.CreateObject(source);
                        this.fft.fft.Transform(this.gabormasks[i2], this.gaborfft[i2]);
                        this.fft.Compute2D(this.gaborfft[i2], -1, nbCPU);
                    }
                }
            }
            this.fft.fft.Transform(source, this.srcfft);
            this.fft.Compute2D(this.srcfft, -1, nbCPU);
            block14: for (int g = 0; g < this.gaborfft.length; ++g) {
                if (!this.precomputefft) {
                    this.gaborfft[g] = null;
                    this.gaborfft[g] = this.fft.fft.CreateObject(source);
                    this.fft.fft.Transform(this.gabormasks[g], this.gaborfft[g]);
                    this.fft.Compute2D(this.gaborfft[g], -1, nbCPU);
                }
                this.fft.fft.Multiply2D(this.srcfft, this.gaborfft[g], this.resultmult);
                if (!this.precomputefft) {
                    this.gaborfft[g] = null;
                }
                this.fft.Compute2D(this.resultmult, 1, nbCPU);
                if (this.fft.fft.ShiftRequired()) {
                    this.fft.fft.Shift(this.resultmult);
                }
                this.fft.fft.Transform(this.resultmult, this.tempresult);
                switch (this.action) {
                    case 2: {
                        ArrayArithmetic.Add((double[][])this.resultgabor, (double[][])this.tempresult, (double[][])this.resultgabor);
                        continue block14;
                    }
                    case 0: {
                        int x;
                        int y;
                        for (y = 0; y < height; ++y) {
                            for (x = 0; x < width; ++x) {
                                if (!(this.resultgabor[y][x] > this.tempresult[y][x])) continue;
                                this.resultgabor[y][x] = this.tempresult[y][x];
                                this.answer[y][x] = this.orientations[g];
                            }
                        }
                        continue block14;
                    }
                    case 1: {
                        int x;
                        int y;
                        for (y = 0; y < height; ++y) {
                            for (x = 0; x < width; ++x) {
                                if (!(this.resultgabor[y][x] < this.tempresult[y][x])) continue;
                                this.resultgabor[y][x] = this.tempresult[y][x];
                                this.answer[y][x] = this.orientations[g];
                            }
                        }
                        continue block14;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown action.");
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Use the FFT, bug generating strong border effects without.");
        }
        switch (this.action) {
            case 2: {
                ArrayArithmetic.Divide((double[][])this.resultgabor, (double)this.gabormasks.length, (double[][])this.resultgabor);
            }
        }
        double min = this.AF.Minimum(this.resultgabor);
        if (min < 0.0) {
            ArrayArithmetic.Add((double[][])this.resultgabor, (double)(-min), (double[][])this.resultgabor);
        }
        ArrayNew.Copy((double[][])this.resultgabor, (double[][])this.tempresult);
        double max = this.AF.Maximum(this.resultgabor);
        if (max > 65535.0) {
            ArrayArithmetic.Divide((double[][])this.resultgabor, (double)max, (double[][])this.tempresult);
            ArrayArithmetic.Multiply((double[][])this.tempresult, (double)65535.0, (double[][])this.tempresult);
        }
        short[] shortbuffer = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                shortbuffer[pos] = (short)(this.tempresult[y][x] + 0.5);
                ++x;
                ++pos;
            }
        }
        shortbuffer = null;
    }

    public DV Filter(DV source, int nbCPU) {
        DV result = this.BasicProcessing ? new DV(source.SizeX, source.SizeY, source.SizeZ, source.Channel, -32) : new DV(source.SizeX, source.SizeY, source.SizeZ, source.Channel, 16);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(DV source, DV result, int nbCPU) {
        if (this.gm3 == null) {
            throw new IllegalArgumentException("Kernels must be created beforehand.");
        }
        if (!DvTools.isGrayLevel((DV)source)) {
            throw new IllegalArgumentException("DV source must be gray level.");
        }
        if (source.Channel != 1) {
            throw new IllegalArgumentException("Only one channel required.");
        }
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (!DvTools.areDimensionsEqual((DV)source, (DV)result)) {
            throw new IllegalArgumentException("DV source and result must have identic dimensions.");
        }
        if (this.BasicProcessing) {
            if (result.Type != -32) {
                throw new IllegalArgumentException("Result DV must be TYPE_FLOAT_GRAY.");
            }
        } else if (result.Type != 16) {
            throw new IllegalArgumentException("Result DV must be TYPE_SHORT_GRAY.");
        }
        int width = source.SizeX;
        int height = source.SizeY;
        int depth = source.SizeZ;
        if (this.resgabor == null || !DvTools.areDimensionsEqual((DV)source, (DV)this.resgabor)) {
            if (this.resgabor != null) {
                this.resgabor.Kill();
            }
            this.resgabor = null;
            this.resgabor = new DV(width, height, depth, 1, -32);
            if (this.tmpres != null) {
                this.tmpres.Kill();
            }
            this.tmpres = null;
            this.tmpres = DvNew.Same((DV)this.resgabor);
        }
        switch (this.action) {
            case 2: {
                DvOperations.Fill((DV)this.resgabor, (double)0.0);
                break;
            }
            case 0: {
                DvOperations.Fill((DV)this.resgabor, (float)Float.MAX_VALUE);
                break;
            }
            case 1: {
                DvOperations.Fill((DV)this.resgabor, (float)-3.4028235E38f);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown action.");
            }
        }
        if (this.fft != null) {
            if (!DvTools.isGrayLevel((DV)source)) {
                throw new IllegalArgumentException("Only gray level volumes supported.");
            }
            if (this.srcfft == null || this.gaborfft[0] == null || !this.fft.fft.areDimensionsCorrect(source, this.srcfft)) {
                this.srcfft = null;
                this.srcfft = this.fft.fft.CreateObject(source);
                this.resultmult = null;
                this.resultmult = this.fft.fft.CreateObject(source);
            }
            this.fft.fft.Transform(source, this.srcfft);
            this.fft.Compute3D(this.srcfft, -1, nbCPU);
            block10: for (int g = 0; g < this.gaborfft.length; ++g) {
                if (!this.precomputefft) {
                    this.gaborfft[g] = null;
                    this.gaborfft[g] = this.fft.fft.CreateObject(source);
                    this.fft.fft.Transform(this.gm3[g], this.gaborfft[g]);
                    this.fft.Compute3D(this.gaborfft[g], -1, nbCPU);
                }
                this.fft.fft.Multiply3D(this.srcfft, this.gaborfft[g], this.resultmult);
                if (!this.precomputefft) {
                    this.gaborfft[g] = null;
                }
                this.fft.Compute3D(this.resultmult, 1, nbCPU);
                if (this.fft.fft.ShiftRequired()) {
                    this.fft.fft.Shift(this.resultmult);
                }
                this.fft.fft.Transform(this.resultmult, this.tmpres);
                switch (this.action) {
                    case 2: {
                        DvArithmetic.Add(this.resgabor, this.tmpres, this.resgabor);
                        continue block10;
                    }
                    case 0: {
                        DvComparator.Compare((DV)this.tmpres, (String)"<", (DV)this.resgabor, (DV)this.tmpres, (DV)this.resgabor, (DV)this.resgabor);
                        continue block10;
                    }
                    case 1: {
                        DvComparator.Compare((DV)this.tmpres, (String)">", (DV)this.resgabor, (DV)this.tmpres, (DV)this.resgabor, (DV)this.resgabor);
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown action.");
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Please use the FFT, else a bug generates strong border effects.");
        }
        if (this.action == 2) {
            DvArithmetic.Multiply(this.resgabor, 1.0f / (float)this.gm3.length, this.resgabor);
        }
        if (this.BasicProcessing) {
            DvNew.Copy((DV)this.resgabor, (DV)result);
            return;
        }
        if (this.IgnoreBorders) {
            int bex = this.BorderEffectSizeX();
            int bey = this.BorderEffectSizeY();
            int bez = this.BorderEffectSizeZ();
            DvDrawer.Borders(this.resgabor, 3.4028234663852886E38, bex, bex, bey, bey, bez, bez);
            float min = (float)this.DF.Minimum(this.resgabor, 0);
            if (min < 0.0f) {
                DvArithmetic.Add(this.resgabor, -min, this.resgabor);
            }
            DvDrawer.Borders(this.resgabor, -3.4028234663852886E38, bex, bex, bey, bey, bez, bez);
            float max = (float)this.DF.Maximum(this.resgabor, 0);
            if ((double)max > 65535.0) {
                DvArithmetic.Multiply(this.resgabor, 65535.0f / max, this.tmpres);
            }
            DvDrawer.Borders(this.resgabor, 0.0, bex, bex, bey, bey, bez, bez);
        } else {
            float max;
            float min = (float)this.DF.Minimum(this.resgabor, 0);
            if (min < 0.0f) {
                DvArithmetic.Add(this.resgabor, -min, this.resgabor);
            }
            if ((double)(max = (float)this.DF.Maximum(this.resgabor, 0)) > 65535.0) {
                DvArithmetic.Multiply(this.resgabor, 65535.0f / max, this.resgabor);
            }
        }
        short[] shortbuffer = result.getDataBufferShort(0);
        float[] floatbuffer = this.resgabor.getDataBufferFloat(0);
        for (int x = 0; x < shortbuffer.length; ++x) {
            shortbuffer[x] = (short)((double)floatbuffer[x] + 0.5);
        }
        shortbuffer = null;
        floatbuffer = null;
    }

    public BufferedImage[] Filter(BufferedImage[] images, int maxsize, int nbSubVolumes, int nbCPU) {
        BufferedImage[] results = this.BasicProcessing ? StackNew.SameFloat(images) : StackNew.Same(images, 11);
        this.Filter(images, maxsize, nbSubVolumes, results, nbCPU);
        return results;
    }

    public void Filter(BufferedImage[] images, int maxsize, int nbSubVolumes, BufferedImage[] results, int nbCPU) {
        if (this.gm3 == null) {
            throw new IllegalArgumentException("Kernels must be created beforehand.");
        }
        if (!ImageTools.isGrayLevel((BufferedImage)images[0])) {
            throw new IllegalArgumentException("DV source must be gray level.");
        }
        if (images[0].getRaster().getNumBands() != 1) {
            throw new IllegalArgumentException("Only one channel/band required.");
        }
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        if (!StackTools.areDimensionsEqual(images, results)) {
            throw new IllegalArgumentException("Images and results must have identic dimensions.");
        }
        if (results[0].getType() != 11) {
            throw new IllegalArgumentException("Result images must be TYPE_USHORT_GRAY.");
        }
        BufferedImage[] tmps = this.BasicProcessing ? results : StackNew.SameFloat(images);
        boolean oldbasic = this.BasicProcessing;
        this.BasicProcessing = true;
        BigDataProcessor bdp = new BigDataProcessor();
        bdp.Process(images, this, maxsize, tmps, nbSubVolumes, nbCPU);
        this.BasicProcessing = oldbasic;
        if (this.BasicProcessing) {
            for (int i2 = 0; i2 < tmps.length; ++i2) {
                tmps[i2] = null;
            }
            tmps = null;
            return;
        }
        if (this.IgnoreBorders) {
            int bex = this.BorderEffectSizeX();
            int bey = this.BorderEffectSizeY();
            int bez = this.BorderEffectSizeZ();
            StackDrawer.Borders(tmps, Float.MAX_VALUE, bex, bex, bey, bey, bez, bez);
            float min = (float)this.SF.Minimum(tmps);
            if (min < 0.0f) {
                StackArithmetic.Add(tmps, (double)(-min), tmps);
            }
            StackDrawer.Borders(tmps, -3.4028235E38f, bex, bex, bey, bey, bez, bez);
            float max = (float)this.SF.Maximum(tmps);
            if ((double)max > 65535.0) {
                StackArithmetic.Multiply(tmps, (double)(65535.0f / max), tmps);
            }
            StackDrawer.Borders(tmps, 0.0f, bex, bex, bey, bey, bez, bez);
        } else {
            float max;
            float min = (float)this.SF.Minimum(tmps);
            if (min < 0.0f) {
                StackArithmetic.Add(tmps, (double)(-min), tmps);
            }
            if ((double)(max = (float)this.SF.Maximum(tmps)) > 65535.0) {
                StackArithmetic.Multiply(tmps, (double)(65535.0f / max), tmps);
            }
        }
        for (int i3 = 0; i3 < images.length; ++i3) {
            short[] shortbuffer = ((DataBufferUShort)results[i3].getRaster().getDataBuffer()).getData();
            float[] floatbuffer = ((DataBufferFloat)tmps[i3].getRaster().getDataBuffer()).getData();
            for (int x = 0; x < shortbuffer.length; ++x) {
                shortbuffer[x] = (short)((double)floatbuffer[x] + 0.5);
            }
            shortbuffer = null;
            floatbuffer = null;
            tmps[i3] = null;
        }
        tmps = null;
        bdp.Kill();
        bdp = null;
        System.gc();
    }

    public void Filter(File[] images, int maxsize, int nbSubVolumes, String resdirectory, String suffix, int nbCPU) throws IOException {
        if (this.gm3 == null) {
            throw new IllegalArgumentException("Kernels must be created beforehand.");
        }
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        boolean oldbasic = this.BasicProcessing;
        this.BasicProcessing = true;
        BufferedImage im0 = ImageIO.Read(images[0]);
        BufferedImage sample = ImageNew.SameFloat((BufferedImage)im0);
        im0 = null;
        BigDataProcessor bdp = new BigDataProcessor();
        BufferedImage[] results = bdp.Process(images, this, maxsize, nbSubVolumes, sample, false, null, null, nbCPU);
        bdp.Kill();
        bdp = null;
        this.BasicProcessing = oldbasic;
        String ext = StringToolsImageDV.FindExtension((String)images[0].getName());
        if (this.BasicProcessing) {
            for (int i2 = 0; i2 < images.length; ++i2) {
                ImageIO.Write(results[i2], resdirectory + "/" + images[i2].getName().replace("." + ext, suffix) + ".png", 6);
                results[i2] = null;
            }
            results = null;
            sample = null;
            System.gc();
            return;
        }
        if (this.IgnoreBorders) {
            int bex = this.BorderEffectSizeX();
            int bey = this.BorderEffectSizeY();
            int bez = this.BorderEffectSizeZ();
            StackDrawer.Borders(results, Float.MAX_VALUE, bex, bex, bey, bey, bez, bez);
            float min = (float)this.SF.Minimum(results);
            if (min < 0.0f) {
                StackArithmetic.Add(results, (double)(-min), results);
            }
            StackDrawer.Borders(results, -3.4028235E38f, bex, bex, bey, bey, bez, bez);
            float max = (float)this.SF.Maximum(results, 0);
            if ((double)max > 65535.0) {
                StackArithmetic.Multiply(results, (double)(65535.0f / max), results);
            }
            StackDrawer.Borders(results, 0.0f, bex, bex, bey, bey, bez, bez);
        } else {
            float max;
            float min = (float)this.SF.Minimum(results);
            if (min < 0.0f) {
                StackArithmetic.Add(results, (double)(-min), results);
            }
            if ((double)(max = (float)this.SF.Maximum(results, 0)) > 65535.0) {
                StackArithmetic.Multiply(results, (double)(65535.0f / max), results);
            }
        }
        File resdir = new File(resdirectory);
        if (!resdir.exists()) {
            resdir.mkdirs();
        }
        BufferedImage res = ImageNew.Same((BufferedImage)sample, (int)11);
        short[] sbout = ((DataBufferUShort)res.getRaster().getDataBuffer()).getData();
        for (int i3 = 0; i3 < images.length; ++i3) {
            float[] fb = ((DataBufferFloat)results[i3].getRaster().getDataBuffer()).getData();
            for (int x = 0; x < sbout.length; ++x) {
                sbout[x] = (short)((double)fb[x] + 0.5);
            }
            ImageIO.Write(res, resdir.getAbsolutePath() + "/" + images[i3].getName().replace("." + ext, suffix) + ".png", 6);
            fb = null;
            results[i3] = null;
        }
        sbout = null;
        results = null;
        System.gc();
    }

    public void FilterExtreme(File[] images, int maxsize, int nbSubVolumes, String resdirectory, String suffix, int nbCPU) throws IOException {
        if (this.gm3 == null) {
            throw new IllegalArgumentException("Kernels must be created beforehand.");
        }
        if (nbCPU < 1) {
            throw new IllegalArgumentException("nbCPU < 1.");
        }
        boolean oldbasic = this.BasicProcessing;
        this.BasicProcessing = true;
        BufferedImage im0 = ImageIO.Read(images[0]);
        BufferedImage sample = ImageNew.SameFloat((BufferedImage)im0);
        im0 = null;
        BigDataProcessor bdp = new BigDataProcessor();
        bdp.Process(images, this, maxsize, nbSubVolumes, sample, true, resdirectory, suffix, nbCPU);
        bdp.Kill();
        bdp = null;
        this.BasicProcessing = oldbasic;
        String ext = StringToolsImageDV.FindExtension((String)images[0].getName());
        if (this.BasicProcessing) {
            sample = null;
            System.gc();
            return;
        }
        Object[] results = new File(resdirectory).listFiles(FileNameFilters.ImagesTIF);
        if (this.IgnoreBorders) {
            int bex = this.BorderEffectSizeX();
            int bey = this.BorderEffectSizeY();
            int bez = this.BorderEffectSizeZ();
            StackDrawer.Borders((File[])results, Float.MAX_VALUE, bex, bex, bey, bey, bez, bez);
            float min = (float)this.SF.Minimum((File[])results);
            if (min < 0.0f) {
                StackArithmetic.Add((File[])results, (double)(-min), (File[])results);
            }
            StackDrawer.Borders((File[])results, -3.4028235E38f, bex, bex, bey, bey, bez, bez);
            float max = (float)this.SF.Maximum((File[])results);
            if (65535.0 < (double)max) {
                StackArithmetic.Multiply((File[])results, (double)(65535.0f / max), (File[])results);
            }
            StackDrawer.Borders((File[])results, 0.0f, bex, bex, bey, bey, bez, bez);
        } else {
            this.SF.MinMaximum((File[])results);
            float min = (float)this.SF.Minimum();
            float max = (float)this.SF.Maximum();
            if (min < 0.0f) {
                StackArithmetic.Add((File[])results, (double)(-min), (File[])results);
            }
            if (65535.0 < (double)max) {
                StackArithmetic.Multiply((File[])results, (double)(65535.0f / max), (File[])results);
            }
        }
        File resdir = new File(resdirectory);
        if (!resdir.exists()) {
            resdir.mkdirs();
        }
        BufferedImage res = ImageNew.Same((BufferedImage)sample, (int)11);
        sample = null;
        short[] sbout = ((DataBufferUShort)res.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < images.length; ++i2) {
            im0 = ImageIO.Read(results[i2]);
            float[] fb = ((DataBufferFloat)im0.getRaster().getDataBuffer()).getData();
            for (int x = 0; x < sbout.length; ++x) {
                sbout[x] = (short)((double)fb[x] + 0.5);
            }
            ImageIO.Write(res, resdir.getAbsolutePath() + "/" + images[i2].getName().replace("." + ext, suffix) + ".png", 6);
            FilesFolders.Delete((File)results[i2]);
            fb = null;
            im0 = null;
        }
        sbout = null;
        Arrays.fill(results, null);
        results = null;
        System.gc();
    }

    public void CreateKernels(int ThetaStart, int ThetaEnd, int ThetaStep, double SigmaX, double SigmaY, double Lambda, double Psi, boolean MinimumOscillation, int Action2) {
        this.ThetaStart = ThetaStart;
        this.ThetaEnd = ThetaEnd;
        this.ThetaStep = ThetaStep;
        this.SigmaX = SigmaX;
        this.SigmaY = SigmaY;
        this.Lambda = Lambda;
        this.Phase = Psi;
        this.minimumoscillation = MinimumOscillation;
        this.action = Action2;
        switch (this.action) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown value of action.");
            }
        }
        int num = 0;
        int size = (ThetaEnd - ThetaStart) / ThetaStep + 1;
        this.gabormasks = new StructuringElement[size];
        this.gaborfft = new Object[size];
        this.orientations = new int[size];
        int theta = ThetaStart;
        while (theta <= ThetaEnd) {
            this.orientations[num] = theta;
            this.CreateKernel(num, SigmaX, SigmaY, Lambda, Psi, (double)theta * Math.PI / 180.0);
            theta += ThetaStep;
            ++num;
        }
    }

    private void CreateKernel(int num, double SigmaX, double SigmaY, double Lambda, double Psi, double Theta) {
        int x;
        int y;
        int nstds = this.minimumoscillation ? 2 : 3;
        double SigmaX2 = SigmaX * SigmaX;
        double SigmaY2 = SigmaY * SigmaY;
        double dXmax = Math.max(Math.abs((double)nstds * SigmaX * Math.cos(Theta)), Math.abs((double)nstds * SigmaY * Math.sin(Theta)));
        double dYmax = Math.max(Math.abs((double)nstds * SigmaX * Math.sin(Theta)), Math.abs((double)nstds * SigmaY * Math.cos(Theta)));
        int Xmax = (int)Math.max(1.0, Math.ceil(dXmax));
        int Ymax = (int)Math.max(1.0, Math.ceil(dYmax));
        int dx = 2 * Xmax + 1;
        int dy = 2 * Ymax + 1;
        double[][] gabor = new double[dy][dx];
        double[][] x_theta = new double[dy][dx];
        double[][] y_theta = new double[dy][dx];
        double cos = Math.cos(Theta);
        double sin = Math.sin(Theta);
        for (y = 0; y < dy; ++y) {
            for (x = 0; x < dx; ++x) {
                x_theta[y][x] = (double)(x - Xmax) * cos + (double)(y - Ymax) * sin;
                y_theta[y][x] = -((double)(x - Xmax)) * sin + (double)(y - Ymax) * cos;
            }
        }
        for (y = 0; y < dy; ++y) {
            for (x = 0; x < dx; ++x) {
                gabor[y][x] = Math.exp(-0.5 * (x_theta[y][x] * x_theta[y][x] / SigmaX2 + y_theta[y][x] * y_theta[y][x] / SigmaY2)) * Math.cos(Math.PI * 2 / Lambda * x_theta[y][x] + Psi);
            }
        }
        if (this.minimumoscillation) {
            int y2;
            int[] testab = new int[dy * dx];
            int pos = 0;
            for (int y3 = 0; y3 < dy; ++y3) {
                int x2 = 0;
                while (x2 < dx) {
                    testab[pos] = gabor[y3][x2] > 0.0 ? 1 : (gabor[y3][x2] < 0.0 ? -1 : 0);
                    ++x2;
                    ++pos;
                }
            }
            this.ccl.Label(testab, dx, dy, -100, true);
            int[] labels = this.ccl.Labels1D();
            int[] dt = new int[3];
            dt[0] = labels[labels.length >> 1];
            boolean[] lab = new boolean[this.ccl.ConnectedComponentsNumber() + 1];
            Arrays.fill(lab, false);
            for (y2 = 1; y2 < dy - 1; ++y2) {
                for (int x3 = 1; x3 < dx - 1; ++x3) {
                    if (labels[x3 + y2 * dx] != dt[0]) continue;
                    for (int i2 = -1; i2 <= 1; ++i2) {
                        for (int j = -1; j <= 1; ++j) {
                            lab[labels[x3 + y2 * dx]] = true;
                            lab[labels[dx * (y2 + i2) + x3 + j]] = true;
                        }
                    }
                }
            }
            int y4 = 0;
            for (int x4 = 0; x4 < lab.length; ++x4) {
                if (!lab[x4]) continue;
                dt[y4++] = x4;
            }
            int pos2 = 0;
            for (y2 = 0; y2 < dy; ++y2) {
                int x5 = 0;
                while (x5 < dx) {
                    if (labels[pos2] != dt[0] && labels[pos2] != dt[1] && labels[pos2] != dt[2]) {
                        gabor[y2][x5] = 0.0;
                    }
                    ++x5;
                    ++pos2;
                }
            }
            lab = null;
            dt = null;
            labels = null;
            testab = null;
        }
        this.gabormasks[num] = new StructuringElement(gabor);
        y_theta = null;
        x_theta = null;
    }

    public void CreateKernels3D_3Axes(int ThetaStart, int ThetaEnd, int ThetaStep, int PhiStart, int PhiEnd, int PhiStep, int AlphaStart, int AlphaEnd, int AlphaStep, double SigmaX, double SigmaY, double SigmaZ, double Lambda, double Phase2, boolean MinimumOscillation, int Action2) {
        this.ThetaStart = ThetaStart;
        this.ThetaEnd = ThetaEnd;
        this.ThetaStep = ThetaStep;
        this.PhiStart = PhiStart;
        this.PhiEnd = PhiEnd;
        this.PhiStep = PhiStep;
        this.AlphaStart = AlphaStart;
        this.AlphaEnd = AlphaEnd;
        this.AlphaStep = AlphaStep;
        this.SigmaX = SigmaX;
        this.SigmaY = SigmaY;
        this.SigmaZ = SigmaZ;
        this.Lambda = Lambda;
        this.Phase = Phase2;
        this.minimumoscillation = MinimumOscillation;
        this.action = Action2;
        switch (this.action) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown value of action.");
            }
        }
        if (ThetaStep == 0) {
            ThetaStep = 1;
        }
        if (PhiStep == 0) {
            PhiStep = 1;
        }
        if (AlphaStep == 0) {
            AlphaStep = 1;
        }
        int num = 0;
        int size = ((ThetaEnd - ThetaStart) / ThetaStep + 1) * ((PhiEnd - PhiStart) / PhiStep + 1) * ((AlphaEnd - AlphaStart) / AlphaStep + 1);
        this.gm3 = new StructuringElement3D[size];
        this.gaborfft = new Object[size];
        for (int alpha = AlphaStart; alpha <= AlphaEnd; alpha += AlphaStep) {
            for (int phi = PhiStart; phi <= PhiEnd; phi += PhiStep) {
                int theta = ThetaStart;
                while (theta <= ThetaEnd) {
                    this.CreateKernel3D_3Axes(num, SigmaX, SigmaY, SigmaZ, Lambda, Phase2, (double)theta * Math.PI / 180.0, (double)phi * Math.PI / 180.0, (double)alpha * Math.PI / 180.0);
                    theta += ThetaStep;
                    ++num;
                }
            }
        }
    }

    private void CreateKernel3D_3Axes(int num, double SigmaX, double SigmaY, double SigmaZ, double Lambda, double Phase2, double Theta, double Phi, double Alpha) {
        int x;
        int y;
        int z;
        int nstds = this.minimumoscillation ? 3 : 4;
        double SigmaX2 = SigmaX * SigmaX;
        double SigmaY2 = SigmaY * SigmaY;
        double SigmaZ2 = SigmaZ * SigmaZ;
        double costheta = Math.cos(Theta);
        double sintheta = Math.sin(Theta);
        double cosphi = Math.cos(Phi);
        double sinphi = Math.sin(Phi);
        double cosalpha = Math.cos(Alpha);
        double sinalpha = Math.sin(Alpha);
        double c0 = cosalpha * costheta;
        double c1 = -sinalpha * sinphi * costheta + cosalpha * sintheta;
        double c2 = cosalpha * sinphi * costheta + sinalpha * sintheta;
        double c3 = cosphi * sintheta;
        double c4 = sinalpha * sinphi * sintheta + cosalpha * costheta;
        double c5 = -cosalpha * sinphi * costheta + sinalpha * costheta;
        double c6 = sinphi;
        double c7 = sinalpha * cosphi;
        double c8 = cosalpha * cosphi;
        double[] max = new double[]{Math.abs(SigmaX * cosalpha * costheta), Math.abs(SigmaY * sinalpha * sinphi * costheta), Math.abs(SigmaY * cosalpha * sintheta), Math.abs(SigmaZ * cosalpha * sinphi * costheta), Math.abs(SigmaZ * sinalpha * sintheta)};
        double dXmax = this.AF.Maximum(max);
        max[0] = Math.abs(SigmaX * cosphi * sintheta);
        max[1] = Math.abs(SigmaY * sinalpha * sinphi * sintheta);
        max[2] = Math.abs(SigmaY * cosalpha * costheta);
        max[3] = Math.abs(SigmaZ * cosalpha * sinphi * costheta);
        max[4] = Math.abs(SigmaZ * sinalpha * costheta);
        double dYmax = this.AF.Maximum(max);
        max[0] = Math.abs(SigmaX * sinphi);
        max[1] = Math.abs(SigmaZ * sinalpha * cosphi);
        max[2] = Math.abs(SigmaZ * cosalpha * cosphi);
        double dZmax = this.AF.Maximum(max, 0, 3);
        max = null;
        int Xmax = (int)Math.max(1.0, Math.ceil(dXmax * 2.0 * (double)nstds));
        int Ymax = (int)Math.max(1.0, Math.ceil(dYmax * 2.0 * (double)nstds));
        int Zmax = (int)Math.max(1.0, Math.ceil(dZmax * 2.0 * (double)nstds));
        int dx = (Xmax << 1) + 1;
        int dy = (Ymax << 1) + 1;
        int dz = (Zmax << 1) + 1;
        double[][][] x_theta = new double[dz][dy][dx];
        double[][][] y_theta = new double[dz][dy][dx];
        double[][][] z_theta = new double[dz][dy][dx];
        double[][][] gabor = new double[dz][dy][dx];
        for (z = 0; z < dz; ++z) {
            for (y = 0; y < dy; ++y) {
                for (x = 0; x < dx; ++x) {
                    x_theta[z][y][x] = (double)(x - Xmax) * c0 + (double)(y - Ymax) * c1 + (double)(z - Zmax) * c2;
                    y_theta[z][y][x] = -((double)(x - Xmax)) * c3 + (double)(y - Ymax) * c4 + (double)(z - Zmax) * c5;
                    z_theta[z][y][x] = (double)(x - Xmax) * c6 - (double)(y - Ymax) * c7 + (double)(z - Zmax) * c8;
                }
            }
        }
        for (z = 0; z < dz; ++z) {
            for (y = 0; y < dy; ++y) {
                for (x = 0; x < dx; ++x) {
                    gabor[z][y][x] = Math.exp(-(x_theta[z][y][x] * x_theta[z][y][x] / SigmaX2 + y_theta[z][y][x] * y_theta[z][y][x] / SigmaY2 + z_theta[z][y][x] * z_theta[z][y][x] / SigmaZ2) / 2.0) * Math.cos(Math.PI * 2 / Lambda * y_theta[z][y][x] + Phase2);
                }
            }
        }
        if (this.minimumoscillation) {
            int[] testab = new int[dz * dy * dx];
            int pos = 0;
            for (int z2 = 0; z2 < dz; ++z2) {
                for (int y2 = 0; y2 < dy; ++y2) {
                    int x2 = 0;
                    while (x2 < dx) {
                        testab[pos] = gabor[z2][y2][x2] > 0.0 ? 1 : (gabor[z2][y2][x2] < 0.0 ? -1 : 0);
                        ++x2;
                        ++pos;
                    }
                }
            }
            this.ccl.Label(testab, dx, dy, dz, -10000, true);
            int[] labels = this.ccl.Labels1D();
            int[] dt = new int[5];
            dt[0] = labels[labels.length >> 1];
            boolean[] lab = new boolean[this.ccl.ConnectedComponentsNumber() + 1];
            Arrays.fill(lab, false);
            int dx1 = dx - 1;
            int dy1 = dy - 1;
            int dz1 = dz - 1;
            int dxy = dx * dy;
            lab[dt[0]] = true;
            for (int z3 = 1; z3 < dz1; ++z3) {
                for (int y3 = 1; y3 < dy1; ++y3) {
                    for (int x3 = 1; x3 < dx1; ++x3) {
                        if (labels[z3 * dxy + y3 * dx + x3] != dt[0]) continue;
                        for (int k = -1; k <= 1; ++k) {
                            for (int i2 = -1; i2 <= 1; ++i2) {
                                for (int j = -1; j <= 1; ++j) {
                                    lab[labels[(z3 + k) * dxy + (y3 + i2) * dx + x3 + j]] = true;
                                }
                            }
                        }
                    }
                }
            }
            int nb = 0;
            for (int x4 = 0; x4 < lab.length; ++x4) {
                if (!lab[x4]) continue;
                dt[nb++] = x4;
            }
            int pos2 = 0;
            for (int z4 = 0; z4 < dz; ++z4) {
                for (int y4 = 0; y4 < dy; ++y4) {
                    int x5 = 0;
                    while (x5 < dx) {
                        if (!ArrayTools.Contains((int[])dt, (int)0, (int)nb, (int)labels[pos2])) {
                            gabor[z4][y4][x5] = 0.0;
                        }
                        ++x5;
                        ++pos2;
                    }
                }
            }
            lab = null;
            dt = null;
            labels = null;
            testab = null;
        }
        this.gm3[num] = new StructuringElement3D(gabor);
        gabor = null;
    }

    public void Parameters(Object ... parameters) {
        switch (parameters.length) {
            case 13: {
                this.precomputefft = (Boolean)parameters[11];
                this.CreateKernels((Integer)parameters[0], (Integer)parameters[1], (Integer)parameters[2], (Double)parameters[3], (Double)parameters[4], (Double)parameters[5], (Double)parameters[6], (Boolean)parameters[10], (Integer)parameters[9]);
                this.fft = parameters[7] != null ? new FFT((FastFourierTransform)parameters[7]) : null;
                this.ForbiddenValue = (Integer)parameters[8];
                this.IgnoreBorders = (Boolean)parameters[12];
                break;
            }
            case 19: {
                this.precomputefft = false;
                this.CreateKernels3D_3Axes((Integer)parameters[0], (Integer)parameters[1], (Integer)parameters[2], (Integer)parameters[3], (Integer)parameters[4], (Integer)parameters[5], (Integer)parameters[6], (Integer)parameters[7], (Integer)parameters[8], (Double)parameters[9], (Double)parameters[10], (Double)parameters[11], (Double)parameters[12], (Double)parameters[13], (Boolean)parameters[17], (Integer)parameters[16]);
                this.fft = parameters[14] != null ? new FFT((FastFourierTransform)parameters[14]) : null;
                this.ForbiddenValue = (Integer)parameters[15];
                this.IgnoreBorders = (Boolean)parameters[18];
                break;
            }
            default: {
                throw new IllegalArgumentException("Exactly 12 (2D) or 18 (3D) parameters required.");
            }
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(19);
        params.add(this.ThetaStart);
        params.add(this.ThetaEnd);
        params.add(this.ThetaStep);
        if (this.gm3 != null) {
            params.add(this.PhiStart);
            params.add(this.PhiEnd);
            params.add(this.PhiStep);
            params.add(this.AlphaStart);
            params.add(this.AlphaEnd);
            params.add(this.AlphaStep);
        }
        params.add(this.SigmaX);
        params.add(this.SigmaY);
        if (this.gm3 != null) {
            params.add(this.SigmaZ);
        }
        params.add(this.Lambda);
        params.add(this.Phase);
        params.add(this.fft.fft);
        params.add(this.ForbiddenValue);
        params.add(this.action);
        params.add(this.minimumoscillation);
        if (this.gm3 == null) {
            params.add(this.precomputefft);
        }
        params.add(this.IgnoreBorders);
        return params;
    }

    public int BorderEffectSizeX() {
        int max = 0;
        if (this.gabormasks != null) {
            StructuringElement se = null;
            for (int i2 = 0; i2 < this.gabormasks.length; ++i2) {
                se = this.gabormasks[i2];
                if (max < se.getSizeX()) {
                    max = se.getSizeX();
                }
                se = null;
            }
            return max >> 1;
        }
        if (this.gm3 != null) {
            StructuringElement3D se3 = null;
            for (int i3 = 0; i3 < this.gm3.length; ++i3) {
                se3 = this.gm3[i3];
                if (max < se3.getSizeX()) {
                    max = se3.getSizeX();
                }
                se3 = null;
            }
            return max >> 1;
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeY() {
        int max = 0;
        if (this.gabormasks != null) {
            StructuringElement se = null;
            for (int i2 = 0; i2 < this.gabormasks.length; ++i2) {
                se = this.gabormasks[i2];
                if (max < se.getSizeY()) {
                    max = se.getSizeY();
                }
                se = null;
            }
            return max >> 1;
        }
        if (this.gm3 != null) {
            StructuringElement3D se3 = null;
            for (int i3 = 0; i3 < this.gm3.length; ++i3) {
                se3 = this.gm3[i3];
                if (max < se3.getSizeY()) {
                    max = se3.getSizeY();
                }
                se3 = null;
            }
            return max >> 1;
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public int BorderEffectSizeZ() {
        int max = 0;
        if (this.gabormasks != null) {
            return 0;
        }
        if (this.gm3 != null) {
            StructuringElement3D se3 = null;
            for (int i2 = 0; i2 < this.gm3.length; ++i2) {
                se3 = this.gm3[i2];
                if (max < se3.getSizeZ()) {
                    max = se3.getSizeZ();
                }
                se3 = null;
            }
            return max >> 1;
        }
        throw new IllegalStateException("Any structuring element defined.");
    }

    public void BasicProcessing(boolean BasicProcessing) {
        this.BasicProcessing = BasicProcessing;
    }

    public boolean BasicProcessing() {
        return this.BasicProcessing;
    }

    public void IgnoreBorders(boolean IgnoreBorders) {
        this.IgnoreBorders = IgnoreBorders;
    }

    public boolean IgnoreBorders() {
        return this.IgnoreBorders;
    }

    public Gabor Clone() {
        Gabor clone = new Gabor();
        List<Object> params = this.Parameters();
        Object[] parameters = params.toArray();
        int pos = -1;
        switch (params.size()) {
            case 12: {
                pos = 7;
                break;
            }
            case 19: {
                pos = 14;
                break;
            }
            default: {
                throw new IllegalStateException("Parameters length is different of 12 or 18. Must not occur.");
            }
        }
        parameters[pos] = ((FastFourierTransform)parameters[pos]).Clone();
        clone.Parameters(parameters);
        clone.BasicProcessing = this.BasicProcessing;
        return clone;
    }

    public double[][] Result() {
        return this.resultgabor;
    }

    public int[][] Orientations() {
        return this.answer;
    }
}

