/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import processing.filters.SignalFilter;

public class FastGaussian
implements SignalFilter {
    private double sigma2 = 1.0;
    private double[] kernel;
    private int[][] wbuffer;
    private int[][] hbuffer;
    private BufferedImage dwnscaled;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        int scale = 0;
        int factor = 1;
        double ds_sigma2 = this.sigma2;
        double us_sigma2 = 1.0;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Image have different type or dimensions");
        }
        while (us_sigma2 < ds_sigma2) {
            double next_us_sigma2 = Math.pow(factor, 2.0);
            double next_ds_sigma2 = (this.sigma2 - next_us_sigma2) / Math.pow(4.0, ++scale);
            if (next_ds_sigma2 <= 0.0) break;
            factor *= 2;
            ds_sigma2 = next_ds_sigma2;
            us_sigma2 = next_us_sigma2;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        if (this.dwnscaled == null || this.dwnscaled.getHeight() != height / factor || this.dwnscaled.getWidth() != width / factor) {
            this.dwnscaled = null;
            this.dwnscaled = new BufferedImage(width / factor, height / factor, 1);
        }
        this.dwnscaled.createGraphics().drawImage(source.getScaledInstance(width / factor, height / factor, 16), 0, 0, null);
        this.gaussianKernel1D(ds_sigma2);
        this.convolve2DSeparate(this.dwnscaled);
        result.createGraphics().drawImage(this.dwnscaled.getScaledInstance(width, height, 2), 0, 0, null);
        this.gaussianKernel1D(us_sigma2);
        this.convolve2DSeparate(result);
    }

    private void convolve2DSeparate(BufferedImage input) {
        int k;
        int c;
        int x;
        int y;
        int chanel;
        int width = input.getWidth();
        int height = input.getHeight();
        int kernelradius = this.kernel.length / 2;
        WritableRaster raster = input.getRaster();
        switch (input.getType()) {
            case 10: 
            case 11: {
                chanel = 1;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                chanel = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        float[] rgb = new float[chanel];
        if (this.wbuffer == null || this.wbuffer.length != width || this.wbuffer[0].length != chanel) {
            this.wbuffer = null;
            this.wbuffer = new int[width][chanel];
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                for (c = 0; c < chanel; ++c) {
                    this.wbuffer[x][c] = raster.getSample(x, y, c);
                }
            }
            for (x = 0; x < width; ++x) {
                Arrays.fill(rgb, 0.0f);
                for (k = -kernelradius; k <= kernelradius; ++k) {
                    if (x + k < 0 || x + k >= width) continue;
                    for (c = 0; c < chanel; ++c) {
                        int n = c;
                        rgb[n] = (float)((double)rgb[n] + this.kernel[kernelradius + k] * (double)this.wbuffer[x + k][c]);
                    }
                }
                for (c = 0; c < chanel; ++c) {
                    raster.setSample(x, y, c, (int)rgb[c]);
                }
            }
        }
        if (this.hbuffer == null || this.hbuffer.length != height || this.hbuffer[0].length != chanel) {
            this.hbuffer = null;
            this.hbuffer = new int[height][chanel];
        }
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                for (c = 0; c < chanel; ++c) {
                    this.hbuffer[y][c] = raster.getSample(x, y, c);
                }
            }
            for (y = 0; y < height; ++y) {
                Arrays.fill(rgb, 0.0f);
                for (k = -kernelradius; k <= kernelradius; ++k) {
                    if (y + k < 0 || y + k >= height) continue;
                    for (c = 0; c < chanel; ++c) {
                        int n = c;
                        rgb[n] = (float)((double)rgb[n] + this.kernel[kernelradius + k] * (double)this.hbuffer[y + k][c]);
                    }
                }
                for (c = 0; c < chanel; ++c) {
                    raster.setSample(x, y, c, (int)rgb[c]);
                }
            }
        }
        raster = null;
        rgb = null;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    private void gaussianKernel1D(double sigma2) {
        int i2;
        int radius = (int)Math.round(2.0 * Math.sqrt(sigma2));
        if (this.kernel == null || this.kernel.length != 1 + 2 * radius) {
            this.kernel = null;
            this.kernel = new double[1 + 2 * radius];
        }
        for (int r = -radius; r <= radius; ++r) {
            this.kernel[r + radius] = Math.exp((double)(-(r * r)) / (2.0 * sigma2));
        }
        double sum = 0.0;
        for (i2 = 0; i2 < this.kernel.length; ++i2) {
            sum += this.kernel[i2];
        }
        i2 = 0;
        while (i2 < this.kernel.length) {
            int n = i2++;
            this.kernel[n] = this.kernel[n] / sum;
        }
    }

    public double getSigma2() {
        return this.sigma2;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required (double sigma2).");
        }
        this.sigma2 = (Double)parameters[0];
        if (this.sigma2 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0.0.");
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.sigma2);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

