/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import processing.filters.SignalFilter;

public class FastBlurStack
implements SignalFilter {
    private int radius = 20;
    private int[] dv;
    private int[] r;
    private int[] g;
    private int[] b;
    private int[] vmin;
    private int[] pixels;
    private int[][] stack;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        int stackstart;
        int x;
        int stackpointer;
        int rbs;
        int[] sir;
        int p;
        int rinsum;
        int ginsum;
        int binsum;
        int routsum;
        int goutsum;
        int boutsum;
        int rsum;
        int gsum;
        int bsum;
        int y;
        int i2;
        int width = source.getWidth();
        int height = source.getHeight();
        int maxWH = Math.max(width, height);
        int widthm = width - 1;
        int heightm = height - 1;
        int aire = width * height;
        int div = (this.radius << 1) + 1;
        int divsum = div + 1 >> 1;
        int yi = 0;
        int yw = 0;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Image have different type or dimensions");
        }
        if (this.pixels == null || this.pixels.length != aire) {
            this.pixels = null;
            this.b = null;
            this.g = null;
            this.r = null;
            this.r = new int[aire];
            this.g = new int[aire];
            this.b = new int[aire];
            this.pixels = new int[aire];
        }
        if (this.vmin == null || this.vmin.length != maxWH) {
            this.vmin = null;
            this.vmin = new int[maxWH];
        }
        this.pixels = source.getRGB(0, 0, width, height, this.pixels, 0, width);
        divsum *= divsum;
        if (this.dv == null || this.dv.length != divsum << 8) {
            this.dv = null;
            this.dv = new int[divsum << 8];
            for (i2 = 0; i2 < this.dv.length; ++i2) {
                this.dv[i2] = i2 / divsum;
            }
        }
        if (this.stack == null || this.stack.length != div) {
            this.stack = null;
            this.stack = new int[div][3];
        }
        int r1 = this.radius + 1;
        for (y = 0; y < height; ++y) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            for (i2 = -this.radius; i2 <= this.radius; ++i2) {
                p = this.pixels[yi + Math.min(widthm, Math.max(i2, 0))];
                sir = this.stack[i2 + this.radius];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rbs = r1 - Math.abs(i2);
                rsum += sir[0] * rbs;
                gsum += sir[1] * rbs;
                bsum += sir[2] * rbs;
                if (i2 > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                    continue;
                }
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
            }
            stackpointer = this.radius;
            for (x = 0; x < width; ++x) {
                this.r[yi] = this.dv[rsum];
                this.g[yi] = this.dv[gsum];
                this.b[yi] = this.dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - this.radius + div;
                sir = this.stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (y == 0) {
                    this.vmin[x] = Math.min(x + this.radius + 1, widthm);
                }
                p = this.pixels[yw + this.vmin[x]];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = this.stack[stackpointer % div];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                ++yi;
            }
            yw += width;
        }
        for (x = 0; x < width; ++x) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            int yp = -this.radius * width;
            for (i2 = -this.radius; i2 <= this.radius; ++i2) {
                yi = Math.max(0, yp) + x;
                sir = this.stack[i2 + this.radius];
                sir[0] = this.r[yi];
                sir[1] = this.g[yi];
                sir[2] = this.b[yi];
                rbs = r1 - Math.abs(i2);
                rsum += this.r[yi] * rbs;
                gsum += this.g[yi] * rbs;
                bsum += this.b[yi] * rbs;
                if (i2 > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                if (i2 >= heightm) continue;
                yp += width;
            }
            yi = x;
            stackpointer = this.radius;
            for (y = 0; y < height; ++y) {
                this.pixels[yi] = 0xFF000000 | this.dv[rsum] << 16 | this.dv[gsum] << 8 | this.dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - this.radius + div;
                sir = this.stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (x == 0) {
                    this.vmin[y] = Math.min(y + r1, heightm) * width;
                }
                p = x + this.vmin[y];
                sir[0] = this.r[p];
                sir[1] = this.g[p];
                sir[2] = this.b[p];
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = this.stack[stackpointer];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                yi += width;
            }
        }
        result.setRGB(0, 0, width, height, this.pixels, 0, width);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public int getRadius() {
        return this.radius;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required (int radius).");
        }
        this.radius = (Integer)parameters[0];
        if (this.radius < 1) {
            throw new IllegalArgumentException("radius < 1.");
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.radius);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

