/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import processing.filters.SignalFilter;

public class FastBlur
implements SignalFilter {
    private int radius = 20;
    private int[] dv;
    private int[] r;
    private int[] g;
    private int[] b;
    private int[] vmin;
    private int[] vmax;
    private int[] pixels;

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)source);
        this.Filter(source, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage source, BufferedImage result, int nbCPU) {
        int p2;
        int p1;
        int x;
        int rsum;
        int gsum;
        int bsum;
        int y;
        int i2;
        int width = source.getWidth();
        int height = source.getHeight();
        int maxWH = Math.max(width, height);
        int widthm = width - 1;
        int heightm = height - 1;
        int aire = width * height;
        int div = 2 * this.radius + 1;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)result)) {
            throw new IllegalArgumentException("Image have different type or dimensions");
        }
        if (this.pixels == null || this.pixels.length != aire) {
            this.pixels = null;
            this.b = null;
            this.g = null;
            this.r = null;
            this.r = new int[aire];
            this.g = new int[aire];
            this.b = new int[aire];
            this.pixels = new int[aire];
        }
        if (this.vmin == null || this.vmin.length != maxWH) {
            this.vmax = null;
            this.vmin = null;
            this.vmin = new int[maxWH];
            this.vmax = new int[maxWH];
        }
        if (this.dv == null || this.dv.length != 256 * div) {
            this.dv = null;
            this.dv = new int[256 * div];
            for (i2 = 0; i2 < 256 * div; ++i2) {
                this.dv[i2] = i2 / div;
            }
        }
        source.getRGB(0, 0, width, height, this.pixels, 0, width);
        int yi = 0;
        int yw = 0;
        for (y = 0; y < height; ++y) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            for (i2 = -this.radius; i2 <= this.radius; ++i2) {
                int p = this.pixels[yi + Math.min(widthm, Math.max(i2, 0))];
                rsum += (p & 0xFF0000) >> 16;
                gsum += (p & 0xFF00) >> 8;
                bsum += p & 0xFF;
            }
            for (x = 0; x < width; ++x) {
                this.r[yi] = this.dv[rsum];
                this.g[yi] = this.dv[gsum];
                this.b[yi] = this.dv[bsum];
                if (y == 0) {
                    this.vmin[x] = Math.min(x + this.radius + 1, widthm);
                    this.vmax[x] = Math.max(x - this.radius, 0);
                }
                p1 = this.pixels[yw + this.vmin[x]];
                p2 = this.pixels[yw + this.vmax[x]];
                rsum += (p1 & 0xFF0000) - (p2 & 0xFF0000) >> 16;
                gsum += (p1 & 0xFF00) - (p2 & 0xFF00) >> 8;
                bsum += (p1 & 0xFF) - (p2 & 0xFF);
                ++yi;
            }
            yw += width;
        }
        for (x = 0; x < width; ++x) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            int yp = -this.radius * width;
            for (i2 = -this.radius; i2 <= this.radius; ++i2) {
                yi = Math.max(0, yp) + x;
                rsum += this.r[yi];
                gsum += this.g[yi];
                bsum += this.b[yi];
                yp += width;
            }
            yi = x;
            for (y = 0; y < height; ++y) {
                this.pixels[yi] = 0xFF000000 | this.dv[rsum] << 16 | this.dv[gsum] << 8 | this.dv[bsum];
                if (x == 0) {
                    this.vmin[y] = Math.min(y + this.radius + 1, heightm) * width;
                    this.vmax[y] = Math.max(y - this.radius, 0) * width;
                }
                p1 = x + this.vmin[y];
                p2 = x + this.vmax[y];
                rsum += this.r[p1] - this.r[p2];
                gsum += this.g[p1] - this.g[p2];
                bsum += this.b[p1] - this.b[p2];
                yi += width;
            }
        }
        result.setRGB(0, 0, width, height, this.pixels, 0, width);
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public int getRadius() {
        return this.radius;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Exactly 1 parameter required (int radius).");
        }
        this.radius = (Integer)parameters[0];
        if (this.radius < 1) {
            throw new IllegalArgumentException("radius < 1.");
        }
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.radius);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

