/*
 * Decompiled with CFR 0.152.
 */
package processing.filters;

import arrayTiTi.ArrayComparator;
import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.Arrays;
import java.util.List;
import measures.histogram.Histogram;
import processing.filters.SignalFilter;

public class DynamicExpansionFV0
implements SignalFilter {
    private Histogram histogram = new Histogram();
    private int[] Lut = null;

    public BufferedImage Filter(BufferedImage Original, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original);
        this.Filter(Original, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        short[] shortbufferout;
        int x;
        int length;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)Original, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Images source and result must have equal dimensions and types.");
        }
        switch (Original.getType()) {
            case 10: {
                length = 256;
                break;
            }
            case 11: {
                length = 65536;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        if (this.Lut == null || this.Lut.length != length) {
            this.Lut = new int[length];
        } else {
            Arrays.fill(this.Lut, 0);
        }
        this.histogram.Fill(Original);
        int[] hist = this.histogram.getValues(0);
        int flag = 0;
        for (x = 0; x < length; ++x) {
            if (hist[x] == 0) continue;
            this.Lut[x] = flag++;
        }
        switch (Original.getType()) {
            case 10: {
                byte[] bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                byte[] bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                for (x = 0; x < bytebufferin.length; ++x) {
                    bytebufferout[x] = (byte)this.Lut[bytebufferin[x] & 0xFF];
                }
                bytebufferout = null;
                bytebufferin = null;
                break;
            }
            case 11: {
                short[] shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                for (x = 0; x < shortbufferin.length; ++x) {
                    shortbufferout[x] = (short)this.Lut[shortbufferin[x] & 0xFFFF];
                }
                shortbufferout = null;
                shortbufferin = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        double a = (double)(--length) / (double)(--flag);
        for (x = 0; x <= flag; ++x) {
            this.Lut[x] = (int)(a * (double)x + 0.5);
        }
        switch (Original.getType()) {
            case 10: {
                byte[] bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                for (x = 0; x < bytebufferout.length; ++x) {
                    bytebufferout[x] = (byte)this.Lut[bytebufferout[x] & 0xFF];
                }
                bytebufferout = null;
                break;
            }
            case 11: {
                shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                for (x = 0; x < shortbufferout.length; ++x) {
                    shortbufferout[x] = (short)this.Lut[shortbufferout[x] & 0xFFFF];
                }
                shortbufferout = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public BufferedImage Filter(BufferedImage Original, double ratiomin, int nbCPU) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original);
        this.Filter(Original, ratiomin, result, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, double ratiomin, BufferedImage Result, int nbCPU) {
        short[] shortbufferout;
        int x;
        int length;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)Original, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Images source and result must have equal dimensions and types.");
        }
        switch (Original.getType()) {
            case 10: {
                length = 256;
                break;
            }
            case 11: {
                length = 65536;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        if (this.Lut == null || this.Lut.length != length) {
            this.Lut = new int[length];
        } else {
            Arrays.fill(this.Lut, 0);
        }
        this.histogram.Fill(Original);
        int thres = (int)((double)(Original.getWidth() * Original.getHeight()) * ratiomin / 100.0 + 0.5);
        int[] hist = this.histogram.getValues(0);
        ArrayComparator.Compare((int[])hist, (String)">=", (int)thres, (int[])hist, (int)0, (int[])hist);
        System.out.println("thres = " + thres);
        int flag = 0;
        for (x = 0; x < length; ++x) {
            this.Lut[x] = hist[x] != 0 ? flag++ : flag;
        }
        switch (Original.getType()) {
            case 10: {
                byte[] bytebufferin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                byte[] bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                for (x = 0; x < bytebufferin.length; ++x) {
                    bytebufferout[x] = (byte)this.Lut[bytebufferin[x] & 0xFF];
                }
                bytebufferout = null;
                bytebufferin = null;
                break;
            }
            case 11: {
                short[] shortbufferin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                for (x = 0; x < shortbufferin.length; ++x) {
                    shortbufferout[x] = (short)this.Lut[shortbufferin[x] & 0xFFFF];
                }
                shortbufferout = null;
                shortbufferin = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        double a = (double)(--length) / (double)(--flag);
        for (x = 0; x <= length; ++x) {
            this.Lut[x] = (int)(a * (double)x + 0.5);
        }
        switch (Original.getType()) {
            case 10: {
                byte[] bytebufferout = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                for (x = 0; x < bytebufferout.length; ++x) {
                    bytebufferout[x] = (byte)this.Lut[bytebufferout[x] & 0xFF];
                }
                bytebufferout = null;
                break;
            }
            case 11: {
                shortbufferout = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                for (x = 0; x < shortbufferout.length; ++x) {
                    shortbufferout[x] = (short)this.Lut[shortbufferout[x] & 0xFFFF];
                }
                shortbufferout = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Parameters(Object ... parameters) {
        throw new IllegalArgumentException("No parameters required.");
    }

    public List<Object> Parameters() {
        return null;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int[] Lut() {
        return this.Lut;
    }

    public SignalFilter Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }
}

